/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.random.RandomSource;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.CompanionSeries;
import iskallia.vault.item.core.DataInitializationItem;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CompanionEggItem
extends Item
implements DataInitializationItem {
    private static final String TIME_TAG = "HatchTime";
    private static final int DEFAULT_HATCH_TIME = 60;
    private static final String SERIES_TAG = "Series";

    public CompanionEggItem(ResourceLocation id, Item.Properties properties) {
        super(properties);
        this.setRegistryName(id);
    }

    @Override
    public void initialize(ItemStack stack, RandomSource rand) {
        int hatch = ModConfigs.COMPANIONS != null ? ModConfigs.COMPANIONS.getHatchingTime() : 60;
        CompanionEggItem.setRemainingTime(stack, hatch);
        CompanionEggItem.setSeries(stack, CompanionSeries.getRandomSeries(rand));
    }

    public static int getRemainingTime(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TIME_TAG)) {
            return tag.m_128451_(TIME_TAG);
        }
        return ModConfigs.COMPANIONS != null ? ModConfigs.COMPANIONS.getHatchingTime() : 60;
    }

    public static void setRemainingTime(ItemStack stack, int time) {
        stack.m_41784_().m_128405_(TIME_TAG, time);
    }

    public static CompanionSeries getSeries(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(SERIES_TAG)) {
            try {
                return CompanionSeries.valueOf(tag.m_128461_(SERIES_TAG));
            }
            catch (IllegalArgumentException ignored) {
                return CompanionSeries.LEGEND;
            }
        }
        return CompanionSeries.LEGEND;
    }

    public static void setSeries(ItemStack stack, CompanionSeries series) {
        stack.m_41784_().m_128359_(SERIES_TAG, series.name());
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        int time = CompanionEggItem.getRemainingTime(stack);
        int minutes = time / 60;
        int seconds = time % 60;
        tooltip.add((Component)new TextComponent("Hatch Time: ").m_130938_(style -> style.m_178520_(0xFFFFFF)).m_7220_((Component)new TextComponent(String.format("%d:%02d", minutes, seconds)).m_130938_(style -> style.m_178520_(11583738))));
        tooltip.add((Component)new TextComponent("Series: ").m_130938_(style -> style.m_178520_(0xFFFFFF)).m_7220_((Component)new TextComponent(CompanionEggItem.getSeries(stack).getDisplayName()).m_130938_(style -> style.m_178520_(11583738))));
    }
}

