/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import iskallia.vault.VaultMod;
import iskallia.vault.config.CompanionsConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.entity.entity.pet.PetHelper;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.CompanionItemClient;
import iskallia.vault.item.CompanionParticleTrailItem;
import iskallia.vault.item.CompanionPetManager;
import iskallia.vault.item.CompanionSeries;
import iskallia.vault.item.gear.TemporalShardItem;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.CommanderPrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.world.data.PlayerCompanionData;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.www.patreon.PatreonManager;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CompanionItem
extends BasicItem
implements IAnimatable,
ICurioItem {
    private static final ResourceLocation TEMPORAL_POOL = VaultMod.id("companion_temporal");
    private static final String PLAYER_PROFILE_TAG = "playerProfile";
    private static final String OWNER_TAG = "Owner";
    private static final String SERIES_TAG = "PetSeries";
    private static final String TYPE_TAG = "PetType";
    private static final String NAME_TAG = "PetName";
    private static final String COMPANION_UUID = "CompanionUUID";
    private static final String OWNER_NAME_TAG = "OwnerName";
    private static final String LEVEL_TAG = "level";
    private static final String XP_TAG = "xp";
    private static final String HEARTS_TAG = "hearts";
    private static final String MAX_HEARTS_TAG = "maxHearts";
    private static final String COOLDOWN_BASE_TAG = "baseCooldown";
    private static final String COOLDOWN_EXPIRY_TAG = "cooldownExpiry";
    private static final String LAST_TEMPORAL_VAULT_TAG = "lastTemporalVault";
    private static final String TEMPORAL_MODIFIER_TAG = "temporal";
    private static final String RELIC_SLOTS_TAG = "relicSlots";
    private static final String COSMETIC_SLOTS_TAG = "cosmeticSlots";
    private static final String RELICS_TAG = "relics";
    private static final String COSMETIC_COLOURS_TAG = "cosmeticColours";
    private static final String COSMETIC_TRAIL_TYPES_TAG = "cosmeticTrailTypes";
    private static final String SPAWN_DATA_TAG = "spawnData";
    private static final String VAULT_RUNS_TAG = "vaultRuns";
    private static final String HATCHED_DATE_TAG = "hatchedDate";
    private static final String ACTIVE_TAG = "active";
    private static final String MIGRATED_TAG = "DataMigrated";
    public static final String SLOT = "head";
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public CompanionItem(ResourceLocation id, Item.Properties properties) {
        super(id, properties);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        Player player;
        if (!SLOT.equals(slotContext.identifier())) {
            return false;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && !CompanionItem.isOwner(stack, player = (Player)livingEntity)) {
            return false;
        }
        if (CuriosApi.getSlotHelper() != null && !CuriosApi.getSlotHelper().getSlotType(SLOT).map(ISlotType::isVisible).orElse(false).booleanValue()) {
            return false;
        }
        return super.canEquip(slotContext, stack);
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        CompanionItem.setOwner(stack, player.m_142081_());
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (!level.f_46443_) {
            CompanionItem.migrateFromWorldData(stack);
        }
        if (entity instanceof Player) {
            UUID currentOwner;
            Player player = (Player)entity;
            if (!level.f_46443_ && (currentOwner = CompanionItem.getOwner(stack)) == null) {
                CompanionItem.setOwner(stack, player.m_142081_());
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.f_46443_) {
                CompanionPetManager.despawnPet((ServerPlayer)player);
            }
        }
        super.onUnequip(slotContext, newStack, stack);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent()) {
                return false;
            }
        }
        return super.canUnequip(slotContext, stack);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.f_46443_) {
                CompanionItem.migrateFromWorldData(stack);
                boolean shouldRender = true;
                try {
                    shouldRender = (Boolean)SlotContext.class.getMethod("visible", new Class[0]).invoke((Object)slotContext, new Object[0]);
                }
                catch (Exception e) {
                    VaultMod.LOGGER.debug("Could not determine curio visibility: {}", (Object)e.getMessage());
                }
                if (shouldRender) {
                    if (player.f_19797_ % 10 == 0) {
                        CompanionPetManager.ensurePetExists((ServerPlayer)player, stack);
                    }
                } else {
                    CompanionPetManager.despawnPet((ServerPlayer)player);
                }
            }
        }
        super.curioTick(slotContext, stack);
    }

    public static void migrateFromWorldData(ItemStack stack) {
        MinecraftServer server;
        if (!(stack.m_41720_() instanceof CompanionItem)) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(MIGRATED_TAG)) {
            return;
        }
        if (EffectiveSide.get() != LogicalSide.SERVER) {
            tag.m_128379_(MIGRATED_TAG, true);
            return;
        }
        UUID companionId = CompanionItem.getCompanionUUID(stack);
        if (companionId != null && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            try {
                PlayerCompanionData.CompanionData data = PlayerCompanionData.get(server).get(companionId).orElse(null);
                if (data != null) {
                    tag.m_128405_(LEVEL_TAG, data.getLevel());
                    tag.m_128405_(XP_TAG, data.getXp());
                    tag.m_128405_(HEARTS_TAG, data.getHearts());
                    tag.m_128405_(MAX_HEARTS_TAG, data.getMaxHearts());
                    tag.m_128405_(COOLDOWN_BASE_TAG, data.getBaseCooldownMinutes());
                    tag.m_128356_(COOLDOWN_EXPIRY_TAG, data.getCooldownExpiry());
                    tag.m_128405_(RELIC_SLOTS_TAG, data.getRelicSlots());
                    tag.m_128405_(COSMETIC_SLOTS_TAG, data.getCosmeticSlots());
                    tag.m_128405_(VAULT_RUNS_TAG, data.getVaultRuns());
                    tag.m_128359_(HATCHED_DATE_TAG, data.getHatchedDate());
                    tag.m_128379_(ACTIVE_TAG, data.isActive());
                    data.getTemporalModifier().ifPresent(modifier -> tag.m_128359_(TEMPORAL_MODIFIER_TAG, modifier.toString()));
                    CompoundTag spawnData = data.getSpawnData();
                    if (spawnData != null) {
                        tag.m_128365_(SPAWN_DATA_TAG, (Tag)spawnData);
                    }
                    CompanionItem.migrateRelicsToNBT(stack, data.getAllRelicMap());
                    CompanionItem.migrateCosmeticsToNBT(stack, data);
                }
            }
            catch (Exception e) {
                VaultMod.LOGGER.warn("Failed to migrate companion data for UUID: " + String.valueOf(companionId), (Throwable)e);
            }
        }
        tag.m_128379_(MIGRATED_TAG, true);
    }

    private static void migrateRelicsToNBT(ItemStack stack, Map<Integer, Pair<Integer, List<ResourceLocation>>> relics) {
        if (relics.isEmpty()) {
            return;
        }
        CompoundTag relicsTag = new CompoundTag();
        for (Map.Entry<Integer, Pair<Integer, List<ResourceLocation>>> entry : relics.entrySet()) {
            CompoundTag relicData = new CompoundTag();
            Pair<Integer, List<ResourceLocation>> pair = entry.getValue();
            relicData.m_128405_("model", ((Integer)pair.getFirst()).intValue());
            ListTag modifiersList = new ListTag();
            for (ResourceLocation id : (List)pair.getSecond()) {
                modifiersList.add((Object)StringTag.m_129297_((String)id.toString()));
            }
            relicData.m_128365_("modifiers", (Tag)modifiersList);
            relicsTag.m_128365_(String.valueOf(entry.getKey()), (Tag)relicData);
        }
        stack.m_41784_().m_128365_(RELICS_TAG, (Tag)relicsTag);
    }

    private static void migrateCosmeticsToNBT(ItemStack stack, PlayerCompanionData.CompanionData data) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag coloursTag = new CompoundTag();
        for (int i = 0; i < data.getCosmeticSlots(); ++i) {
            int colour = data.getCosmeticColour(i);
            if (colour == -1) continue;
            coloursTag.m_128405_(String.valueOf(i), colour);
        }
        if (!coloursTag.m_128456_()) {
            tag.m_128365_(COSMETIC_COLOURS_TAG, (Tag)coloursTag);
        }
        CompoundTag trailTypesTag = new CompoundTag();
        for (int i = 0; i < data.getCosmeticSlots(); ++i) {
            CompanionParticleTrailItem.TrailType trailType = data.getCosmeticTrailType(i);
            if (trailType == null) continue;
            trailTypesTag.m_128405_(String.valueOf(i), trailType.ordinal());
        }
        if (!trailTypesTag.m_128456_()) {
            tag.m_128365_(COSMETIC_TRAIL_TYPES_TAG, (Tag)trailTypesTag);
        }
    }

    public Component m_7626_(ItemStack stack) {
        String name = CompanionItem.getOwnerName(stack);
        if (name != null && !name.isEmpty() && !name.matches("^[0-9a-fA-F\\-]{36}$")) {
            return new TextComponent(name + "'s Companion").m_130940_(ChatFormatting.AQUA);
        }
        return new TextComponent("Companion").m_130940_(ChatFormatting.WHITE);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (CompanionItem.hasCompanionData(stack)) {
            this.addLevelTooltip(stack, tooltip);
            this.addHealthTooltip(stack, tooltip);
            this.addCooldownTooltip(stack, tooltip);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CompanionItemClient.addSeriesTooltip(stack, tooltip));
            tooltip.add(TextComponent.f_131282_);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                CompanionItemClient.addTemporalModifierTooltip(stack, tooltip);
                CompanionItemClient.addPassiveModifiersTooltip(stack, tooltip);
            });
        }
    }

    private void addCooldownTooltip(ItemStack stack, List<Component> tooltip) {
        if (CompanionItem.getCompanionHearts(stack) <= 0) {
            return;
        }
        int current = CompanionItem.getCurrentCooldown(stack);
        if (current <= 0) {
            tooltip.add((Component)new TextComponent("Cooldown: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent("Ready!").m_130940_(ChatFormatting.GREEN)));
        } else {
            long remainingTicks = (long)current * 20L;
            long seconds = remainingTicks / 20L % 60L;
            long minutes = remainingTicks / 20L / 60L % 60L;
            long hours = remainingTicks / 20L / 60L / 60L;
            String time = hours > 0L ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
            tooltip.add((Component)new TextComponent("Cooldown: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(time).m_130940_(ChatFormatting.RED)));
        }
    }

    private void addLevelTooltip(ItemStack stack, List<Component> tooltip) {
        int companionLevel = CompanionItem.getCompanionLevel(stack);
        tooltip.add((Component)new TextComponent("Level: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(String.valueOf(companionLevel)).m_130948_(Style.f_131099_.m_178520_(11583738))));
    }

    private void addHealthTooltip(ItemStack stack, List<Component> tooltip) {
        int hearts = CompanionItem.getCompanionHearts(stack);
        if (hearts > 0) {
            tooltip.add((Component)new TextComponent("Health: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent("\u2764".repeat(hearts)).m_130940_(ChatFormatting.RED)));
        } else {
            tooltip.add((Component)new TextComponent("Health: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent("Retired").m_130940_(ChatFormatting.GRAY)));
        }
    }

    public static void generateCompanionData(ItemStack stack, RandomSource rand) {
        CompanionSeries series = CompanionSeries.getRandomSeries(rand);
        CompanionItem.generateCompanionDataForSeries(stack, rand, series);
    }

    public static void generateCompanionDataForSeries(ItemStack stack, RandomSource rand, CompanionSeries series) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(SERIES_TAG, series.name());
        tag.m_128359_(COMPANION_UUID, UUID.randomUUID().toString());
        tag.m_128405_(LEVEL_TAG, 1);
        tag.m_128405_(XP_TAG, 0);
        tag.m_128405_(HEARTS_TAG, 1);
        tag.m_128405_(MAX_HEARTS_TAG, 1);
        tag.m_128405_(RELIC_SLOTS_TAG, 0);
        tag.m_128405_(COSMETIC_SLOTS_TAG, 0);
        tag.m_128405_(VAULT_RUNS_TAG, 0);
        tag.m_128379_(ACTIVE_TAG, false);
        int cooldownMinutes = ModConfigs.COMPANIONS.getRandomCooldown(rand);
        tag.m_128405_(COOLDOWN_BASE_TAG, cooldownMinutes);
        VaultModifier<?> temporal = CompanionItem.getRandomTemporalModifier();
        tag.m_128359_(TEMPORAL_MODIFIER_TAG, temporal.getId().toString());
        String date = ZonedDateTime.now().withZoneSameInstant(ZoneId.of("UTC")).toLocalDate().toString();
        tag.m_128359_(HATCHED_DATE_TAG, date);
        switch (series) {
            case LEGEND: {
                CompanionItem.generateLegendCompanion(stack, rand);
                break;
            }
            case PET: {
                CompanionItem.generatePetCompanion(tag, rand);
            }
        }
    }

    private static void generateLegendCompanion(ItemStack stack, RandomSource rand) {
        CompoundTag tag = stack.m_41784_();
        Map<String, String> players = PatreonManager.getInstance().getAllPlayers();
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(players.entrySet());
        String username = "Legend";
        if (!entries.isEmpty()) {
            Map.Entry entry = (Map.Entry)entries.get(rand.nextInt(entries.size()));
            username = (String)entry.getKey();
        }
        String[] types = new String[]{"Minion", "Antlion"};
        String type = types[rand.nextInt(types.length)];
        tag.m_128359_(NAME_TAG, username);
        tag.m_128359_(TYPE_TAG, type);
        GameProfile profile = new GameProfile(null, username);
        CompanionItem.setUserProfile(stack, profile);
    }

    private static void generatePetCompanion(CompoundTag tag, RandomSource rand) {
        PetHelper.PetVariant variant = PetHelper.rollVariant();
        tag.m_128359_(NAME_TAG, variant.displayName());
        tag.m_128359_(TYPE_TAG, variant.type());
    }

    public static VaultModifier<?> getRandomTemporalModifier() {
        return (VaultModifier)ModConfigs.VAULT_MODIFIER_POOLS.getRandom(TEMPORAL_POOL, 0, JavaRandom.ofNanoTime()).stream().findFirst().orElseThrow(() -> new IllegalStateException("No temporal modifier found in pool: " + String.valueOf(TEMPORAL_POOL)));
    }

    public static int getTemporalDuration(ItemStack stack) {
        int duration = ModConfigs.COMPANIONS.getTemporalModifierTime(CompanionItem.getCompanionLevel(stack));
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            int finalDuration = duration;
            duration = (Integer)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> CompanionItemClient.applyPrestigeMultiplier(finalDuration));
        }
        return duration;
    }

    public static void activateTemporalModifier(ServerPlayer player, ItemStack stack, Vault vault) {
        ResourceLocation temporalModifier;
        Object vaultModifier;
        if (CompanionItem.getCompanionHearts(stack) <= 0) {
            return;
        }
        Optional<ResourceLocation> temporalModOpt = CompanionItem.getTemporalModifier(stack);
        if (temporalModOpt.isEmpty()) {
            VaultModifier<?> newTemporal = CompanionItem.getRandomTemporalModifier();
            CompanionItem.setTemporalModifier(stack, newTemporal.getId());
            temporalModOpt = Optional.of(newTemporal.getId());
        }
        if ((vaultModifier = VaultModifierRegistry.get(temporalModifier = temporalModOpt.get())) != null) {
            int duration = CompanionItem.getTemporalDuration(stack);
            for (CommanderPrestigePower power : PrestigeHelper.getPrestige((Player)player).getAll(CommanderPrestigePower.class, Skill::isUnlocked)) {
                duration = Math.round((float)duration * power.getDurationMultiplier());
            }
            int finalDuration = duration;
            vault.get(Vault.MODIFIERS).addModifier((VaultModifier<?>)vaultModifier, 1, true, JavaRandom.ofNanoTime(), context -> {
                if (finalDuration > 0) {
                    context.set(ModifierContext.TICKS_LEFT, finalDuration);
                }
            });
            MutableComponent text = new TextComponent("").m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent("'s Companion added ").m_130940_(ChatFormatting.GRAY)).m_7220_(((VaultModifier)vaultModifier).getChatDisplayNameComponent(1)).m_7220_((Component)new TextComponent(" for ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(TemporalShardItem.formatTime(duration / 20))).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
            for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                listener.getPlayer().ifPresent(arg_0 -> CompanionItem.lambda$activateTemporalModifier$9(listener, (Component)text, arg_0));
            }
        }
        CompanionItem.markTemporalUsed(stack, vault.get(Vault.ID));
    }

    public static Optional<ItemStack> getCompanion(LivingEntity entity) {
        if (entity.m_5833_()) {
            return Optional.empty();
        }
        return CuriosApi.getCuriosHelper().getCuriosHandler(entity).map(handler -> handler).flatMap(handler -> handler.getStacksHandler(SLOT)).map(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStacks().getStackInSlot(i);
                if (stack.m_41720_() != ModItems.COMPANION) continue;
                return stack;
            }
            return null;
        });
    }

    public static UUID getCompanionUUID(ItemStack stack) {
        if (!(stack.m_41720_() instanceof CompanionItem)) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(COMPANION_UUID)) {
            return null;
        }
        try {
            return UUID.fromString(tag.m_128461_(COMPANION_UUID));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void setUserProfile(ItemStack stack, GameProfile gameProfile) {
        if (stack.m_41720_() instanceof CompanionItem) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128365_(PLAYER_PROFILE_TAG, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)gameProfile));
        }
    }

    public static Optional<GameProfile> getUserProfile(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41720_() instanceof CompanionItem && (tag = stack.m_41784_()).m_128441_(PLAYER_PROFILE_TAG)) {
            return Optional.ofNullable(NbtUtils.m_129228_((CompoundTag)tag.m_128469_(PLAYER_PROFILE_TAG)));
        }
        return Optional.empty();
    }

    public static void setCompanionLevel(ItemStack stack, int level) {
        stack.m_41784_().m_128405_(LEVEL_TAG, level);
    }

    public static int getCompanionLevel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(LEVEL_TAG) ? tag.m_128451_(LEVEL_TAG) : 1;
    }

    public static void setCompanionXP(ItemStack stack, int xp) {
        stack.m_41784_().m_128405_(XP_TAG, xp);
    }

    public static void addCompanionXP(ItemStack stack, int xpToAdd) {
        CompanionsConfig.CompanionLevelMeta meta;
        int required;
        if (CompanionItem.getCompanionHearts(stack) <= 0) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int level = CompanionItem.getCompanionLevel(stack);
        int xp = tag.m_128451_(XP_TAG);
        int relicSlots = tag.m_128451_(RELIC_SLOTS_TAG);
        int cosmeticSlots = tag.m_128451_(COSMETIC_SLOTS_TAG);
        int hearts = tag.m_128451_(HEARTS_TAG);
        int maxHearts = tag.m_128451_(MAX_HEARTS_TAG);
        int newXP = xp + xpToAdd;
        newXP = Math.round((float)newXP * ModConfigs.COMPANIONS.getExpMultiplier());
        ArrayList<String> rewards = new ArrayList<String>();
        while (level < ModConfigs.COMPANIONS.getMaxLevel() && newXP >= (required = (meta = ModConfigs.COMPANIONS.getLevelMeta(level)).getTnl())) {
            newXP -= required;
            if (++level == 2 || level == 5 || level == 8 || level == 10) {
                relicSlots = Math.min(4, relicSlots + 1);
                rewards.add("Relic Slot");
            }
            if (level == 3 || level == 6 || level == 10) {
                cosmeticSlots = Math.min(3, cosmeticSlots + 1);
                rewards.add("Particle Slot");
            }
            if (level != 4 && level != 7 && level != 9 && level != 10) continue;
            ++maxHearts;
            ++hearts;
            rewards.add("Heart");
        }
        if (level >= ModConfigs.COMPANIONS.getMaxLevel()) {
            newXP = 0;
        }
        tag.m_128405_(LEVEL_TAG, level);
        tag.m_128405_(XP_TAG, newXP);
        tag.m_128405_(RELIC_SLOTS_TAG, relicSlots);
        tag.m_128405_(COSMETIC_SLOTS_TAG, cosmeticSlots);
        tag.m_128405_(MAX_HEARTS_TAG, maxHearts);
        tag.m_128405_(HEARTS_TAG, hearts);
        if (!rewards.isEmpty()) {
            CompanionItem.notifyOwnerLevelUp(stack, String.join((CharSequence)" and ", rewards));
        }
    }

    private static MinecraftServer getCurrentServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    private static void notifyOwnerLevelUp(ItemStack stack, String reward) {
        MinecraftServer server = CompanionItem.getCurrentServer();
        UUID owner = CompanionItem.getOwner(stack);
        if (server == null || owner == null) {
            return;
        }
        ServerPlayer player = server.m_6846_().m_11259_(owner);
        if (player == null) {
            return;
        }
        String name = CompanionItem.getPetName(stack);
        String compName = name == null || name.isEmpty() ? "Companion" : name;
        MutableComponent msg = new TextComponent("<" + compName + "> ").m_7220_((Component)new TextComponent("I have levelled up! I gained an extra ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(reward).m_130940_(ChatFormatting.GOLD));
        player.m_6352_((Component)msg, player.m_142081_());
    }

    public static int getXPRequiredForNextLevel(ItemStack stack) {
        int level = CompanionItem.getCompanionLevel(stack);
        if (level >= ModConfigs.COMPANIONS.getMaxLevel()) {
            return 0;
        }
        CompanionsConfig.CompanionLevelMeta meta = ModConfigs.COMPANIONS.getLevelMeta(level);
        return meta.getTnl();
    }

    public static int getCompanionXP(ItemStack stack) {
        return stack.m_41784_().m_128451_(XP_TAG);
    }

    public static void startCompanionCooldown(ItemStack stack) {
        if (CompanionItem.isOnCooldown(stack)) {
            return;
        }
        int base = CompanionItem.getBaseCooldown(stack);
        float multiplier = ModConfigs.COMPANIONS.getCooldownMultiplier();
        int extra = Math.round((float)base * multiplier * (float)(CompanionItem.getCompanionLevel(stack) - 1));
        int total = base + extra;
        CompanionItem.setCompanionCooldown(stack, total);
    }

    public static void incrementVaultRuns(ItemStack stack) {
        int runs = CompanionItem.getVaultRuns(stack);
        stack.m_41784_().m_128405_(VAULT_RUNS_TAG, runs + 1);
    }

    public static int getVaultRuns(ItemStack stack) {
        return stack.m_41784_().m_128451_(VAULT_RUNS_TAG);
    }

    public static void setVaultRuns(ItemStack stack, int amount) {
        stack.m_41784_().m_128405_(VAULT_RUNS_TAG, amount);
    }

    public static String getHatchedDate(ItemStack stack) {
        return stack.m_41784_().m_128461_(HATCHED_DATE_TAG);
    }

    public static void setHatchedDate(ItemStack stack, String date) {
        stack.m_41784_().m_128359_(HATCHED_DATE_TAG, date);
    }

    public static void setCompanionCooldown(ItemStack stack, int minutes) {
        long expiry = ZonedDateTime.now().withZoneSameInstant(ZoneId.of("UTC")).toInstant().toEpochMilli() + (long)minutes * 60L * 1000L;
        stack.m_41784_().m_128356_(COOLDOWN_EXPIRY_TAG, expiry);
    }

    public static void addCooldownTime(ItemStack stack, int seconds) {
        long expiry = stack.m_41784_().m_128454_(COOLDOWN_EXPIRY_TAG);
        stack.m_41784_().m_128356_(COOLDOWN_EXPIRY_TAG, expiry += (long)seconds * 1000L);
    }

    public static void reduceCooldown(ItemStack stack, int seconds) {
        long expiry = stack.m_41784_().m_128454_(COOLDOWN_EXPIRY_TAG);
        long now = ZonedDateTime.now().withZoneSameInstant(ZoneId.of("UTC")).toInstant().toEpochMilli();
        if ((expiry -= (long)seconds * 1000L) < now) {
            expiry = now;
        }
        stack.m_41784_().m_128356_(COOLDOWN_EXPIRY_TAG, expiry);
    }

    public static int getCurrentCooldown(ItemStack stack) {
        long now = ZonedDateTime.now().withZoneSameInstant(ZoneId.of("UTC")).toInstant().toEpochMilli();
        long expiry = stack.m_41784_().m_128454_(COOLDOWN_EXPIRY_TAG);
        return (int)Math.max(0L, (expiry - now) / 1000L);
    }

    public static int getBaseCooldown(ItemStack stack) {
        return stack.m_41784_().m_128451_(COOLDOWN_BASE_TAG);
    }

    public static boolean isOnCooldown(ItemStack stack) {
        return CompanionItem.getCurrentCooldown(stack) > 0;
    }

    public static void setTemporalModifier(ItemStack stack, ResourceLocation modifierId) {
        if (modifierId == null) {
            stack.m_41784_().m_128473_(TEMPORAL_MODIFIER_TAG);
        } else {
            stack.m_41784_().m_128359_(TEMPORAL_MODIFIER_TAG, modifierId.toString());
        }
    }

    public static Optional<ResourceLocation> getTemporalModifier(ItemStack stack) {
        ResourceLocation id;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(TEMPORAL_MODIFIER_TAG) && (id = ResourceLocation.m_135820_((String)tag.m_128461_(TEMPORAL_MODIFIER_TAG))) != null) {
            return Optional.of(id);
        }
        return Optional.empty();
    }

    public static boolean hasUsedTemporalIn(ItemStack stack, UUID vaultId) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(LAST_TEMPORAL_VAULT_TAG)) {
            return false;
        }
        try {
            UUID lastVault = UUID.fromString(tag.m_128461_(LAST_TEMPORAL_VAULT_TAG));
            return vaultId != null && vaultId.equals(lastVault);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void markTemporalUsed(ItemStack stack, UUID vaultId) {
        stack.m_41784_().m_128359_(LAST_TEMPORAL_VAULT_TAG, vaultId.toString());
    }

    public static void setRelic(ItemStack stack, int slot, int model, ResourceLocation id) {
        CompanionItem.setRelic(stack, slot, model, id == null ? Collections.emptyList() : List.of(id));
    }

    public static void setRelic(ItemStack stack, int slot, int model, List<ResourceLocation> ids) {
        if (slot < 0 || slot >= CompanionItem.getRelicSlots(stack)) {
            return;
        }
        CompoundTag relics = stack.m_41784_().m_128469_(RELICS_TAG);
        if (ids == null || ids.isEmpty()) {
            relics.m_128473_(String.valueOf(slot));
        } else {
            CompoundTag r = new CompoundTag();
            r.m_128405_("model", model);
            ListTag list = new ListTag();
            for (ResourceLocation id : ids) {
                list.add((Object)StringTag.m_129297_((String)id.toString()));
            }
            r.m_128365_("modifiers", (Tag)list);
            relics.m_128365_(String.valueOf(slot), (Tag)r);
        }
        stack.m_41784_().m_128365_(RELICS_TAG, (Tag)relics);
    }

    public static Optional<Pair<Integer, List<ResourceLocation>>> getRelic(ItemStack stack, int slot) {
        CompoundTag relics = stack.m_41784_().m_128469_(RELICS_TAG);
        if (!relics.m_128441_(String.valueOf(slot))) {
            return Optional.empty();
        }
        CompoundTag r = relics.m_128469_(String.valueOf(slot));
        int model = r.m_128451_("model");
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        ListTag list = r.m_128437_("modifiers", 8);
        for (Tag t : list) {
            ResourceLocation id = ResourceLocation.m_135820_((String)t.m_7916_());
            if (id == null) continue;
            ids.add(id);
        }
        return Optional.of(Pair.of((Object)model, ids));
    }

    public static Map<Integer, Pair<Integer, List<ResourceLocation>>> getAllRelics(ItemStack stack) {
        HashMap<Integer, Pair<Integer, List<ResourceLocation>>> map = new HashMap<Integer, Pair<Integer, List<ResourceLocation>>>();
        CompoundTag relics = stack.m_41784_().m_128469_(RELICS_TAG);
        for (String key : relics.m_128431_()) {
            try {
                int s = Integer.parseInt(key);
                CompoundTag r = relics.m_128469_(key);
                int model = r.m_128451_("model");
                ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
                ListTag list = r.m_128437_("modifiers", 8);
                for (Tag t : list) {
                    ResourceLocation id = ResourceLocation.m_135820_((String)t.m_7916_());
                    if (id == null) continue;
                    ids.add(id);
                }
                map.put(s, (Pair<Integer, List<ResourceLocation>>)Pair.of((Object)model, ids));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return map;
    }

    public static int getRelicSlots(ItemStack stack) {
        return stack.m_41784_().m_128451_(RELIC_SLOTS_TAG);
    }

    public static void clearAllRelics(ItemStack stack) {
        stack.m_41784_().m_128473_(RELICS_TAG);
    }

    public static void setCosmeticColour(ItemStack stack, int slot, int colour) {
        if (slot < 0 || slot >= CompanionItem.getCosmeticSlots(stack)) {
            return;
        }
        CompoundTag cosmetics = stack.m_41784_().m_128469_(COSMETIC_COLOURS_TAG);
        if (colour == -1) {
            cosmetics.m_128473_(String.valueOf(slot));
            if (cosmetics.m_128456_()) {
                stack.m_41784_().m_128473_(COSMETIC_COLOURS_TAG);
            } else {
                stack.m_41784_().m_128365_(COSMETIC_COLOURS_TAG, (Tag)cosmetics);
            }
        } else {
            cosmetics.m_128405_(String.valueOf(slot), colour);
            stack.m_41784_().m_128365_(COSMETIC_COLOURS_TAG, (Tag)cosmetics);
        }
    }

    public static void setCosmeticTrailType(ItemStack stack, int slot, CompanionParticleTrailItem.TrailType type) {
        if (slot < 0 || slot >= CompanionItem.getCosmeticSlots(stack)) {
            return;
        }
        CompoundTag types = stack.m_41784_().m_128469_(COSMETIC_TRAIL_TYPES_TAG);
        if (type == null) {
            types.m_128473_(String.valueOf(slot));
            if (types.m_128456_()) {
                stack.m_41784_().m_128473_(COSMETIC_TRAIL_TYPES_TAG);
            } else {
                stack.m_41784_().m_128365_(COSMETIC_TRAIL_TYPES_TAG, (Tag)types);
            }
        } else {
            types.m_128405_(String.valueOf(slot), type.ordinal());
            stack.m_41784_().m_128365_(COSMETIC_TRAIL_TYPES_TAG, (Tag)types);
        }
    }

    public static CompanionParticleTrailItem.TrailType getCosmeticTrailType(ItemStack stack, int slot) {
        CompoundTag types = stack.m_41784_().m_128469_(COSMETIC_TRAIL_TYPES_TAG);
        if (!types.m_128441_(String.valueOf(slot))) {
            return null;
        }
        int ordinal = types.m_128451_(String.valueOf(slot));
        if (ordinal >= 0 && ordinal < CompanionParticleTrailItem.TrailType.values().length) {
            return CompanionParticleTrailItem.TrailType.values()[ordinal];
        }
        return null;
    }

    public static int getCosmeticColour(ItemStack stack, int slot) {
        CompoundTag cosmetics = stack.m_41784_().m_128469_(COSMETIC_COLOURS_TAG);
        if (!cosmetics.m_128441_(String.valueOf(slot))) {
            return -1;
        }
        return cosmetics.m_128451_(String.valueOf(slot));
    }

    public static List<Integer> getAllCosmeticColours(ItemStack stack) {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        for (int i = 0; i < CompanionItem.getCosmeticSlots(stack); ++i) {
            cols.add(CompanionItem.getCosmeticColour(stack, i));
        }
        return cols;
    }

    public static List<CompanionParticleTrailItem.TrailType> getAllCosmeticTrailTypes(ItemStack stack) {
        ArrayList<CompanionParticleTrailItem.TrailType> list = new ArrayList<CompanionParticleTrailItem.TrailType>();
        for (int i = 0; i < CompanionItem.getCosmeticSlots(stack); ++i) {
            list.add(CompanionItem.getCosmeticTrailType(stack, i));
        }
        return list;
    }

    public static int getCosmeticSlots(ItemStack stack) {
        return stack.m_41784_().m_128451_(COSMETIC_SLOTS_TAG);
    }

    public static void addCosmeticSlot(ItemStack stack) {
        int current = CompanionItem.getCosmeticSlots(stack);
        if (current < 3) {
            stack.m_41784_().m_128405_(COSMETIC_SLOTS_TAG, current + 1);
        }
    }

    public static void setCosmeticSlots(ItemStack stack, int slots) {
        stack.m_41784_().m_128405_(COSMETIC_SLOTS_TAG, slots);
    }

    public static CompoundTag getSpawnData(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(SPAWN_DATA_TAG)) {
            return null;
        }
        return tag.m_128469_(SPAWN_DATA_TAG).m_6426_();
    }

    public static void setSpawnData(ItemStack stack, CompoundTag spawnData) {
        if (spawnData == null) {
            stack.m_41784_().m_128473_(SPAWN_DATA_TAG);
        } else {
            stack.m_41784_().m_128365_(SPAWN_DATA_TAG, (Tag)spawnData.m_6426_());
        }
    }

    public static void grantVaultCompletionXP(Player player, int experience) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        CompanionItem.getCompanion((LivingEntity)player).ifPresent(stack -> {
            if (!CompanionItem.isActive(stack) || !CompanionItem.isOwner(stack, player)) {
                return;
            }
            int xp = Math.round((float)experience * ModConfigs.COMPANIONS.getCompletionXpShare());
            if (xp > 0) {
                CompanionItem.addCompanionXP(stack, xp);
            }
        });
    }

    public static boolean isActive(ItemStack stack) {
        return stack.m_41784_().m_128471_(ACTIVE_TAG);
    }

    public static void setActive(ItemStack stack, boolean active) {
        stack.m_41784_().m_128379_(ACTIVE_TAG, active);
    }

    public static void setCompanionHearts(ItemStack stack, int hearts) {
        stack.m_41784_().m_128405_(HEARTS_TAG, hearts);
    }

    public static int getCompanionHearts(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(HEARTS_TAG) ? tag.m_128451_(HEARTS_TAG) : 1;
    }

    public static int getCompanionMaxHearts(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(MAX_HEARTS_TAG) ? tag.m_128451_(MAX_HEARTS_TAG) : 1;
    }

    public static void setCompanionMaxHearts(ItemStack stack, int maxHearts) {
        stack.m_41784_().m_128405_(MAX_HEARTS_TAG, maxHearts);
        stack.m_41784_().m_128405_(HEARTS_TAG, maxHearts);
    }

    public static void addMaxHeart(ItemStack stack, int hearts) {
        int currentMax = CompanionItem.getCompanionMaxHearts(stack);
        int currentHearts = CompanionItem.getCompanionHearts(stack);
        CompanionItem.setCompanionMaxHearts(stack, currentMax + hearts);
        CompanionItem.setCompanionHearts(stack, currentHearts + hearts);
    }

    public static UUID getOwner(ItemStack stack) {
        if (stack.m_41720_() instanceof CompanionItem) {
            String str = stack.m_41784_().m_128461_(OWNER_TAG);
            try {
                return str.isEmpty() ? null : UUID.fromString(str);
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
        return null;
    }

    public static void setOwner(ItemStack stack, UUID owner) {
        if (stack.m_41720_() instanceof CompanionItem) {
            stack.m_41784_().m_128359_(OWNER_TAG, owner.toString());
        }
    }

    public static boolean isOwner(ItemStack stack, Player player) {
        if (stack.m_41720_() instanceof CompanionItem) {
            UUID owner = CompanionItem.getOwner(stack);
            return owner != null && owner.equals(player.m_142081_());
        }
        return false;
    }

    public static String getOwnerName(ItemStack stack) {
        if (stack.m_41720_() instanceof CompanionItem) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_(OWNER_NAME_TAG)) {
                return tag.m_128461_(OWNER_NAME_TAG);
            }
            UUID owner = CompanionItem.getOwner(stack);
            return owner != null ? owner.toString() : "Unknown";
        }
        return "Unknown";
    }

    public static void setOwnerName(ItemStack stack, String name) {
        if (stack.m_41720_() instanceof CompanionItem) {
            stack.m_41784_().m_128359_(OWNER_NAME_TAG, name);
        }
    }

    public static boolean hasCompanionData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(NAME_TAG) && tag.m_128441_(TYPE_TAG) && tag.m_128441_(SERIES_TAG);
    }

    public static String getPetName(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        CompanionSeries series = CompanionItem.getPetSeries(stack);
        if (series == CompanionSeries.LEGEND && CompanionItem.getUserProfile(stack).isPresent()) {
            return CompanionItem.getUserProfile(stack).get().getName();
        }
        return tag != null ? tag.m_128461_(NAME_TAG) : null;
    }

    public static String getPetType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128461_(TYPE_TAG) : null;
    }

    public static CompanionSeries getPetSeries(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(SERIES_TAG)) {
            try {
                return CompanionSeries.valueOf(tag.m_128461_(SERIES_TAG));
            }
            catch (IllegalArgumentException ignored) {
                return CompanionSeries.LEGEND;
            }
        }
        return CompanionSeries.LEGEND;
    }

    public static String getPetId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128461_(COMPANION_UUID) : null;
    }

    public static void setSkinName(ItemStack stack, String skinName) {
        Optional<GameProfile> currentProfile;
        if (stack.m_41720_() instanceof CompanionItem && CompanionItem.getPetSeries(stack) == CompanionSeries.LEGEND && skinName != null && !skinName.trim().isEmpty() && (currentProfile = CompanionItem.getUserProfile(stack)).isPresent()) {
            GameProfile newProfile = new GameProfile(null, skinName.trim());
            CompanionItem.setUserProfile(stack, newProfile);
            CompoundTag tag = stack.m_41784_();
            tag.m_128473_("defaultSkin");
            tag.m_128473_("updatingSkin");
        }
    }

    public static String getSkinName(ItemStack stack) {
        Optional<GameProfile> profile = CompanionItem.getUserProfile(stack);
        return profile.map(GameProfile::getName).orElse("Steve");
    }

    public static void setPetName(ItemStack stack, String name) {
        if (!(stack.m_41720_() instanceof CompanionItem)) {
            return;
        }
        if (name == null || name.trim().isEmpty()) {
            return;
        }
        String trimmed = name.trim();
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(NAME_TAG, trimmed);
        if (CompanionItem.getPetSeries(stack) == CompanionSeries.LEGEND) {
            GameProfile profile = new GameProfile(null, trimmed);
            CompanionItem.setUserProfile(stack, profile);
            tag.m_128473_("defaultSkin");
            tag.m_128473_("updatingSkin");
        }
    }

    public static void setPetType(ItemStack stack, String type) {
        if (!(stack.m_41720_() instanceof CompanionItem)) {
            return;
        }
        if (type == null || type.trim().isEmpty()) {
            return;
        }
        String trimmed = type.trim();
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(TYPE_TAG, trimmed);
    }

    public static void setPetSeries(ItemStack stack, CompanionSeries series) {
        if (!(stack.m_41720_() instanceof CompanionItem)) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(SERIES_TAG, series.name());
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CompanionItemClient.initializeClient(consumer));
    }

    private static /* synthetic */ void lambda$activateTemporalModifier$9(Listener listener, Component text, ServerPlayer other) {
        if (!(listener instanceof Runner)) {
            return;
        }
        other.m_5661_(text, false);
    }
}

