/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.VaultMod;
import iskallia.vault.client.render.CompanionItemRenderer;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionSeries;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.CommanderPrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import software.bernie.geckolib3.model.AnimatedGeoModel;

@OnlyIn(value=Dist.CLIENT)
public class CompanionItemClient {
    public static void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return CompanionItemRenderer.INSTANCE;
            }
        });
    }

    public static boolean isShiftDown() {
        return Screen.m_96638_();
    }

    public static void addSeriesTooltip(ItemStack stack, List<Component> tooltip) {
        if (CompanionItem.hasCompanionData(stack)) {
            Object series = CompanionItemClient.capitalize(CompanionItem.getPetSeries(stack).name().toLowerCase());
            String type = CompanionItem.getPetType(stack);
            if (Objects.equals(series, CompanionSeries.PET.toString())) {
                type = CompanionItemClient.capitalize(type);
            }
            if (CompanionItemClient.isShiftDown()) {
                series = (String)series + " (" + type + ")";
            }
            tooltip.add((Component)new TextComponent("Series: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent((String)series).m_130948_(Style.f_131099_.m_178520_(11583738))));
            if (CompanionItemClient.isShiftDown() && CompanionItem.getPetSeries(stack).equals((Object)CompanionSeries.LEGEND)) {
                tooltip.add((Component)new TextComponent("Skin: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(CompanionItem.getSkinName(stack)).m_130948_(Style.f_131099_.m_178520_(11583738))));
            }
        }
    }

    public static void addTemporalModifierTooltip(ItemStack stack, List<Component> tooltip) {
        CompanionItem.getTemporalModifier(stack).ifPresent(modifierId -> {
            VaultModifier vaultModifier = VaultModifierRegistry.getOpt(modifierId).orElse(null);
            if (vaultModifier != null) {
                String descriptionTxt;
                tooltip.add((Component)new TextComponent("Temporal Modifier").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)new TextComponent("  " + vaultModifier.getDisplayName()).m_130948_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor())));
                if (CompanionItemClient.isShiftDown() && !(descriptionTxt = vaultModifier.getDisplayDescriptionFormatted(1)).isEmpty()) {
                    MutableComponent description = new TextComponent("  " + descriptionTxt).m_130940_(ChatFormatting.DARK_GRAY);
                    tooltip.add((Component)description);
                }
            }
        });
    }

    public static void addPassiveModifiersTooltip(ItemStack stack, List<Component> tooltip) {
        Map<Integer, Pair<Integer, List<ResourceLocation>>> relics = CompanionItem.getAllRelics(stack);
        if (!relics.isEmpty()) {
            tooltip.add((Component)new TextComponent("Relics").m_130940_(ChatFormatting.GREEN));
            HashMap<ResourceLocation, Integer> modifierCounts = new HashMap<ResourceLocation, Integer>();
            relics.values().forEach(list -> ((List)list.getSecond()).forEach(id -> modifierCounts.merge((ResourceLocation)id, 1, Integer::sum)));
            modifierCounts.forEach((id, count) -> {
                VaultModifier vaultModifier = VaultModifierRegistry.getOpt(id).orElse(null);
                if (vaultModifier != null) {
                    String descriptionTxt;
                    TextComponent modifierName = new TextComponent(vaultModifier.getDisplayNameFormatted((int)count));
                    modifierName.m_6270_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor()));
                    if (count > 1) {
                        MutableComponent stackSize = new TextComponent(String.format("%dx", count)).m_130940_(ChatFormatting.GRAY);
                        tooltip.add((Component)new TextComponent("  ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)stackSize).m_130946_(" ").m_7220_((Component)modifierName));
                    } else {
                        tooltip.add((Component)new TextComponent("  ").m_7220_((Component)modifierName));
                    }
                    if (CompanionItemClient.isShiftDown() && !(descriptionTxt = vaultModifier.getDisplayDescriptionFormatted((int)count)).isEmpty()) {
                        MutableComponent description = new TextComponent("  " + descriptionTxt).m_130940_(ChatFormatting.DARK_GRAY);
                        tooltip.add((Component)description);
                    }
                } else {
                    MutableComponent fallbackText = new TextComponent("  " + id.toString()).m_130940_(ChatFormatting.GRAY);
                    tooltip.add((Component)fallbackText);
                }
            });
        }
    }

    public static int applyPrestigeMultiplier(int duration) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            for (CommanderPrestigePower power : PrestigeHelper.getPrestige((Player)player).getAll(CommanderPrestigePower.class, Skill::isUnlocked)) {
                duration = Math.round((float)duration * power.getDurationMultiplier());
            }
        }
        return duration;
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CompanionItemModel
    extends AnimatedGeoModel<CompanionItem> {
        public ResourceLocation getModelLocation(CompanionItem object) {
            return VaultMod.id("geo/plushie.geo.json");
        }

        public ResourceLocation getTextureLocation(CompanionItem object) {
            return VaultMod.id("textures/item/companion/default.png");
        }

        public ResourceLocation getAnimationFileLocation(CompanionItem animatable) {
            return null;
        }
    }
}

