/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.init.ModItems;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CompanionParticleTrailItem
extends Item {
    private static final String COLOR_TAG = "color";
    private static final String TYPE_TAG = "type";
    private static final Random RANDOM = new Random();

    public CompanionParticleTrailItem(ResourceLocation id) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
        this.setRegistryName(id);
    }

    public static ItemStack create(int rgb) {
        return CompanionParticleTrailItem.create(rgb, TrailType.DUST);
    }

    public static ItemStack create(int rgb, TrailType type) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.COMPANION_PARTICLE_TRAIL);
        CompanionParticleTrailItem.setColour(stack, rgb);
        CompanionParticleTrailItem.setType(stack, type);
        return stack;
    }

    public static ItemStack createRandom() {
        float hue = RANDOM.nextFloat();
        float saturation = 0.85f + RANDOM.nextFloat() * 0.15f;
        float brightness = 0.85f + RANDOM.nextFloat() * 0.15f;
        int rgb = Color.HSBtoRGB(hue, saturation, brightness) & 0xFFFFFF;
        TrailType type = TrailType.random(RANDOM);
        return CompanionParticleTrailItem.create(rgb, type);
    }

    public static int getColour(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41784_().m_128451_(COLOR_TAG) : 0xFFFFFF;
    }

    public static void setColour(ItemStack stack, int rgb) {
        stack.m_41784_().m_128405_(COLOR_TAG, rgb);
    }

    public static TrailType getType(ItemStack stack) {
        if (!stack.m_41782_()) {
            return TrailType.DUST;
        }
        int ord = stack.m_41784_().m_128451_(TYPE_TAG);
        if (ord < 0 || ord >= TrailType.values().length) {
            return TrailType.DUST;
        }
        return TrailType.values()[ord];
    }

    public static void setType(ItemStack stack, TrailType type) {
        stack.m_41784_().m_128405_(TYPE_TAG, type.ordinal());
    }

    public static Vec3 rgbVec(int hex) {
        return new Vec3((double)(hex >> 16 & 0xFF) / 255.0, (double)(hex >> 8 & 0xFF) / 255.0, (double)(hex & 0xFF) / 255.0);
    }

    public Component m_7626_(ItemStack stack) {
        int rgb = CompanionParticleTrailItem.getColour(stack);
        TrailType type = CompanionParticleTrailItem.getType(stack);
        return new TextComponent(type.getDisplayName() + " Particle Trail").m_130938_(style -> style.m_178520_(rgb));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
    }

    public static enum TrailType {
        DUST("Dust"),
        SCRAPE("Star"),
        GRID_GATEWAY("Vault"),
        HEART("Heart");

        private final String displayName;

        private TrailType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static TrailType random(Random rand) {
            TrailType[] values = TrailType.values();
            return values[rand.nextInt(values.length)];
        }
    }
}

