/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.mojang.authlib.GameProfile;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.entity.entity.pet.PetHelper;
import iskallia.vault.init.ModEntities;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionParticleTrailItem;
import iskallia.vault.item.CompanionSeries;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class CompanionPetManager {
    private static final ConcurrentHashMap<UUID, Integer> SPAWNED_PETS = new ConcurrentHashMap();

    public static void spawnPet(ServerPlayer player, ItemStack stack) {
        CompoundTag spawnData;
        if (player.m_5833_()) {
            return;
        }
        CompanionPetManager.despawnPet(player);
        ServerLevel level = (ServerLevel)player.f_19853_;
        CompanionSeries series = CompanionItem.getPetSeries(stack);
        String petType = CompanionItem.getPetType(stack);
        EntityType<PetEntity> type = series == CompanionSeries.PET ? PetHelper.getVariant(petType).map(PetHelper.PetVariant::entityType).orElse(ModEntities.PET) : ModEntities.PET;
        PetEntity pet = (PetEntity)type.m_20615_((Level)level);
        if (pet == null) {
            throw new IllegalStateException("Failed to create pet entity of type: " + String.valueOf(type));
        }
        pet.setOwner(player);
        pet.setCompanionData(stack);
        if (series == CompanionSeries.PET) {
            Optional<PetHelper.PetVariant> petPetType = PetHelper.getVariant(petType);
            petPetType.ifPresent(petVariant -> {
                if (petVariant.traits() != null) {
                    petVariant.traits().apply(pet);
                }
            });
        }
        if ((spawnData = CompanionItem.getSpawnData(stack)) != null) {
            pet.setVanillaEntityData(spawnData);
        } else {
            Entity entity;
            EntityType vanilla = EntityType.m_20632_((String)petType).orElse(null);
            if (vanilla != null && (entity = vanilla.m_20615_((Level)level)) instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(player.m_142538_()), MobSpawnType.MOB_SUMMONED, null, null);
                if (mob instanceof AgeableMob) {
                    AgeableMob ageMob = (AgeableMob)mob;
                    ageMob.m_146762_(0);
                }
                CompoundTag newSpawnData = mob.m_20240_(new CompoundTag());
                CompanionItem.setSpawnData(stack, newSpawnData);
                pet.setVanillaEntityData(newSpawnData);
            }
        }
        List<Integer> cols = CompanionItem.getAllCosmeticColours(stack);
        List<CompanionParticleTrailItem.TrailType> types = CompanionItem.getAllCosmeticTrailTypes(stack);
        ArrayList<Integer> validCols = new ArrayList<Integer>();
        ArrayList<CompanionParticleTrailItem.TrailType> validTypes = new ArrayList<CompanionParticleTrailItem.TrailType>();
        for (int i = 0; i < cols.size(); ++i) {
            if (i >= types.size() || cols.get(i) == -1) continue;
            validCols.add(cols.get(i));
            validTypes.add(types.get(i));
        }
        pet.setParticleColours(validCols);
        pet.setParticleTrailTypes(validTypes);
        CompanionPetManager.applySkinsToEntity(pet, stack);
        pet.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        level.m_7967_((Entity)pet);
        SPAWNED_PETS.put(player.m_142081_(), pet.m_142049_());
    }

    public static void despawnPet(ServerPlayer player) {
        Entity entity;
        ServerLevel level = (ServerLevel)player.f_19853_;
        Integer petId = SPAWNED_PETS.remove(player.m_142081_());
        if (petId != null && (entity = level.m_6815_(petId.intValue())) instanceof PetEntity) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        level.m_45976_(PetEntity.class, player.m_142469_().m_82400_(20.0)).stream().filter(pet -> player.equals((Object)pet.getOwner())).forEach(pet -> pet.m_142687_(Entity.RemovalReason.DISCARDED));
    }

    public static void ensurePetExists(ServerPlayer player, ItemStack stack) {
        if (player.m_5833_()) {
            CompanionPetManager.despawnPet(player);
            return;
        }
        ServerLevel level = (ServerLevel)player.f_19853_;
        Optional<ItemStack> equipped = CompanionItem.getCompanion((LivingEntity)player);
        if (equipped.isEmpty() || !ItemStack.m_41728_((ItemStack)equipped.get(), (ItemStack)stack)) {
            CompanionPetManager.despawnPet(player);
            return;
        }
        List<PetEntity> pets = level.m_45976_(PetEntity.class, player.m_142469_().m_82400_(32.0)).stream().filter(p -> player.equals((Object)p.getOwner())).toList();
        if (!pets.isEmpty()) {
            PetEntity keep = pets.get(0);
            SPAWNED_PETS.put(player.m_142081_(), keep.m_142049_());
            for (int i = 1; i < pets.size(); ++i) {
                pets.get(i).m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        CompanionPetManager.spawnPet(player, stack);
    }

    public static void applySkinsToEntity(PetEntity entity, ItemStack stack) {
        String playerName;
        CompanionSeries series = CompanionItem.getPetSeries(stack);
        if (series == CompanionSeries.LEGEND && (playerName = CompanionItem.getPetName(stack)) != null && !playerName.isEmpty()) {
            GameProfile profile = new GameProfile(null, playerName);
            entity.setGameProfile(profile);
        }
    }

    public static void cleanupPlayer(ServerPlayer player, ServerLevel level) {
        CompanionPetManager.cleanupPlayer(level, player.m_142081_());
    }

    public static void cleanupPlayer(ServerLevel level, UUID playerId) {
        PetEntity pet;
        Integer petId = SPAWNED_PETS.remove(playerId);
        if (petId == null) {
            return;
        }
        Entity entity = level.m_6815_(petId.intValue());
        if (entity instanceof PetEntity && (pet = (PetEntity)entity).m_6084_()) {
            pet.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public static Integer getSpawnedPetId(UUID playerUUID) {
        return SPAWNED_PETS.get(playerUUID);
    }
}

