/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.config.CompanionRelicsConfig;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.render.CompanionRelicItemRenderer;
import iskallia.vault.item.render.core.IManualModelLoading;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;

public class CompanionRelicItem
extends Item
implements IManualModelLoading {
    private static final String MODIFIERS_TAG = "modifiers";
    private static final String MODEL_TAG = "model";

    public CompanionRelicItem(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(1));
        this.setRegistryName(id);
    }

    public Component m_7626_(ItemStack stack) {
        return new TextComponent("Companion Relic").m_130948_(Style.f_131099_.m_178520_(14274371));
    }

    public static ItemStack create(Pair<Integer, List<ResourceLocation>> modifier) {
        return CompanionRelicItem.create((List)modifier.getSecond(), (int)((Integer)modifier.getFirst()));
    }

    public static ItemStack create(ResourceLocation modifier, int model) {
        return CompanionRelicItem.create(List.of(modifier), model);
    }

    public static ItemStack create(List<ResourceLocation> modifiers, int model) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.COMPANION_RELIC);
        CompanionRelicItem.setModifiers(stack, modifiers);
        CompanionRelicItem.setModel(stack, model);
        return stack;
    }

    public static List<ResourceLocation> getModifiers(ItemStack stack) {
        ArrayList<ResourceLocation> modifiers = new ArrayList<ResourceLocation>();
        if (stack.m_41782_()) {
            ListTag list = stack.m_41783_().m_128437_(MODIFIERS_TAG, 8);
            for (Tag child : list) {
                if (!(child instanceof StringTag)) continue;
                StringTag stringTag = (StringTag)child;
                modifiers.add(new ResourceLocation(stringTag.m_7916_()));
            }
        }
        return modifiers;
    }

    public static void setModifiers(ItemStack stack, List<ResourceLocation> modifiers) {
        ListTag list = new ListTag();
        for (ResourceLocation id : modifiers) {
            list.add((Object)StringTag.m_129297_((String)id.toString()));
        }
        stack.m_41784_().m_128365_(MODIFIERS_TAG, (Tag)list);
    }

    public static void setModel(ItemStack stack, int model) {
        stack.m_41784_().m_128405_(MODEL_TAG, model);
    }

    public static int getModel(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128451_(MODEL_TAG) : 0;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        List<ResourceLocation> modifiers = CompanionRelicItem.getModifiers(stack);
        if (!modifiers.isEmpty()) {
            for (ResourceLocation id : modifiers) {
                VaultModifierRegistry.getOpt(id).ifPresent(modifier -> {
                    String desc;
                    tooltip.add((Component)new TextComponent(" \u2022 " + modifier.getDisplayName()).m_130948_(Style.f_131099_.m_131148_(modifier.getDisplayTextColor())));
                    if (Screen.m_96638_() && !(desc = modifier.getDisplayDescription()).isEmpty()) {
                        tooltip.add((Component)new TextComponent("    " + desc).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                });
            }
        }
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        CompanionRelicsConfig relicsConfig = (CompanionRelicsConfig)new CompanionRelicsConfig().readConfig();
        ModConfigs.CONFIGS.remove(relicsConfig);
        for (int i = 1; i < relicsConfig.getMaxModels() + 1; ++i) {
            consumer.accept(new ModelResourceLocation("the_vault:companion_relics/%d#inventory".formatted(i)));
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return CompanionRelicItemRenderer.INSTANCE;
            }
        });
    }
}

