/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.random.RandomSource;
import iskallia.vault.init.ModConfigs;

public enum CompanionSeries {
    LEGEND("Legend"),
    PET("Pet");

    private final String displayName;

    private CompanionSeries(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public double getWeight() {
        return ModConfigs.COMPANIONS.getSeriesWeight(this);
    }

    public static CompanionSeries getRandomSeries(RandomSource rand) {
        double total = 0.0;
        for (CompanionSeries s : CompanionSeries.values()) {
            total += s.getWeight();
        }
        double r = rand.nextDouble() * total;
        double cur = 0.0;
        for (CompanionSeries s : CompanionSeries.values()) {
            if (!(r <= (cur += s.getWeight()))) continue;
            return s;
        }
        return LEGEND;
    }
}

