/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.VaultMod;
import iskallia.vault.block.DungeonDoorBlock;
import iskallia.vault.block.TreasureDoorBlock;
import iskallia.vault.block.base.GodAltarTileEntity;
import iskallia.vault.block.entity.DungeonDoorTileEntity;
import iskallia.vault.block.entity.TreasureDoorTileEntity;
import iskallia.vault.client.gui.screen.VaultCompassScreen;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.PortalData;
import iskallia.vault.core.vault.PortalLogic;
import iskallia.vault.core.vault.RoomCache;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.entity.entity.FloatingItemEntity;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.VaultCompassMode;
import iskallia.vault.skill.ability.effect.spi.HunterAbility;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.VaultPlayerCompassData;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CompassItem
extends BasicItem
implements ICurioItem {
    private static final int TARGET_SET_DURATION = 40;
    private static final double TILE_SEARCH_RADIUS = 256.0;
    private static final String MODE_TAG = "Mode";
    private static final Map<VaultCompassMode, TargetProvider> MODE_TARGETS = new EnumMap<VaultCompassMode, TargetProvider>(VaultCompassMode.class);

    public CompassItem() {
        super(VaultMod.id("vault_compass"), new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
    }

    public static Optional<ItemStack> getCompass(Player player) {
        ItemStack curioItemStack = IntegrationCurios.getCurioItemStack((LivingEntity)player, "compass", 0);
        if (curioItemStack.m_41720_() == ModItems.VAULT_COMPASS) {
            return Optional.of(curioItemStack);
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != ModItems.VAULT_COMPASS) continue;
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return "compass".equals(slotContext.identifier());
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_183503_().m_46467_() % 10L != 0L) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!CompassItem.hasCompass((Player)player2)) {
            return;
        }
        CompassItem.updateCompassMode(player2);
        if (!VaultUtils.isVaultLevel(player2.f_19853_)) {
            return;
        }
        CompassItem.updateCompassTarget(player2);
    }

    private static boolean hasCompass(Player player) {
        return CompassItem.getCompass((Player)((ServerPlayer)player)).isPresent();
    }

    private static void setMode(ItemStack stack, VaultCompassMode mode) {
        stack.m_41784_().m_128359_(MODE_TAG, mode.name());
    }

    public static void updateCompassMode(ServerPlayer player) {
        VaultCompassMode mode = VaultPlayerCompassData.get().get(player.m_142081_()).getMode();
        player.m_150109_().f_35974_.stream().filter(stack -> stack.m_41720_() == ModItems.VAULT_COMPASS).forEach(stack -> CompassItem.setMode(stack, mode));
        ItemStack curio = IntegrationCurios.getCurioItemStack((LivingEntity)player, "compass", 0);
        if (curio.m_41720_() == ModItems.VAULT_COMPASS) {
            CompassItem.setMode(curio, mode);
        }
    }

    private static void updateCompassTarget(ServerPlayer player) {
        VaultPlayerCompassData data = VaultPlayerCompassData.get();
        VaultCompassMode mode = data.get(player.m_142081_()).getMode();
        TargetProvider provider = MODE_TARGETS.get((Object)mode);
        if (provider == null) {
            return;
        }
        ServerVaults.get(player.f_19853_).ifPresent(vault -> {
            StatCollector stats = (StatCollector)vault.get(Vault.STATS).getMap().get(player.m_142081_());
            if (stats == null) {
                return;
            }
            Listeners listeners = vault.get(Vault.LISTENERS);
            if (!listeners.contains(player.m_142081_())) {
                return;
            }
            Listener listener = listeners.get(player.m_142081_());
            BlockPos target = provider.findTarget((Vault)vault, player, stats);
            if (target != null) {
                listener.set(Listener.COMPASS_TARGET, target);
            } else {
                listener.remove(Listener.COMPASS_TARGET);
            }
        });
    }

    private static BlockPos findNearestRoom(Vault vault, ServerPlayer player, StatCollector stats, RoomCache.RoomType type) {
        if (!vault.has(Vault.ROOM_CACHE)) {
            return null;
        }
        RoomCache.RoomMap rooms = vault.get(Vault.ROOM_CACHE).get(type);
        if (rooms.isEmpty()) {
            return null;
        }
        Map<BlockPos, ResourceLocation> discovered = stats.getRoomsDiscovered();
        BlockPos playerPos = player.m_142538_();
        return rooms.entrySet().stream().filter(entry -> {
            RegionPos region = (RegionPos)((Object)((Object)entry.getKey()));
            BlockPos key = new BlockPos(region.m_123341_(), 0, region.m_123343_());
            return !discovered.containsKey(key);
        }).min(Comparator.comparingDouble(entry -> {
            RegionPos region = (RegionPos)((Object)((Object)entry.getKey()));
            BlockPos center = region.toBlockPos().m_142082_(region.getSizeX() / 2, 0, region.getSizeZ() / 2);
            return center.m_123331_((Vec3i)playerPos);
        })).map(entry -> {
            RegionPos region = (RegionPos)((Object)((Object)entry.getKey()));
            return region.toBlockPos().m_142082_(region.getSizeX() / 2, 0, region.getSizeZ() / 2);
        }).orElse(null);
    }

    private static BlockPos findCompanionEgg(Vault vault, ServerPlayer player, StatCollector stats) {
        return CompassItem.findNearestTile(player, tile -> tile.m_58904_().m_45976_(FloatingItemEntity.class, new AABB(player.m_142538_()).m_82400_(256.0)).stream().anyMatch(entity -> entity.m_32055_().m_41720_() == ModItems.COMPANION_EGG));
    }

    private static BlockPos findNearestOreRoom(Vault vault, ServerPlayer player, StatCollector stats) {
        return CompassItem.findNearestRoom(vault, player, stats, RoomCache.RoomType.ORE);
    }

    private static BlockPos findNearestChallengeRoom(Vault vault, ServerPlayer player, StatCollector stats) {
        return CompassItem.findNearestRoom(vault, player, stats, RoomCache.RoomType.CHALLENGE);
    }

    private static BlockPos findExit(Vault vault, ServerPlayer player, StatCollector stats) {
        PortalLogic logic = vault.get(Vault.WORLD).get(WorldManager.PORTAL_LOGIC);
        if (logic instanceof ClassicPortalLogic) {
            ClassicPortalLogic classic = (ClassicPortalLogic)logic;
            return classic.getPortals(ClassicPortalLogic.EXIT).findAny().map(data -> {
                BlockPos min = data.get(PortalData.MIN);
                BlockPos max = data.get(PortalData.MAX);
                return new BlockPos((min.m_123341_() + max.m_123341_()) / 2, min.m_123342_(), (min.m_123343_() + max.m_123343_()) / 2);
            }).orElse(null);
        }
        return null;
    }

    private static BlockPos findNearestGodAltar(Vault vault, ServerPlayer player, StatCollector stats) {
        return CompassItem.findNearestTile(player, tile -> {
            GodAltarTileEntity altar;
            return tile instanceof GodAltarTileEntity && !(altar = (GodAltarTileEntity)((Object)tile)).isCompleted();
        });
    }

    private static BlockPos findNearestObjectivePillar(Vault vault, ServerPlayer player, StatCollector stats) {
        return CompassItem.findNearestHunterTarget(player, HunterAbility.Target.OBJECTIVES);
    }

    private static BlockPos findNearestDungeonDoor(Vault vault, ServerPlayer player, StatCollector stats) {
        return CompassItem.findNearestTile(player, tile -> {
            DungeonDoorTileEntity door;
            return tile instanceof DungeonDoorTileEntity && (Boolean)(door = (DungeonDoorTileEntity)((Object)tile)).m_58900_().m_61143_((Property)DungeonDoorBlock.f_52727_) == false;
        });
    }

    private static BlockPos findNearestTreasureDoor(Vault vault, ServerPlayer player, StatCollector stats) {
        return CompassItem.findNearestTile(player, tile -> tile.getClass() == TreasureDoorTileEntity.class && (Boolean)((TreasureDoorTileEntity)((Object)tile)).m_58900_().m_61143_((Property)TreasureDoorBlock.f_52727_) == false);
    }

    private static BlockPos findNearestHunterTarget(ServerPlayer player, HunterAbility.Target target) {
        return CompassItem.findNearestTile(player, tile -> HunterAbility.getHighlightType(tile).map(t -> t == target).orElse(false));
    }

    private static BlockPos findNearestTile(ServerPlayer player, Predicate<BlockEntity> predicate) {
        BlockPos origin = player.m_142538_();
        return HunterAbility.selectPositions((ServerLevel)player.f_19853_, (Player)player, 256.0, tile -> predicate.test((BlockEntity)tile) ? Optional.of(new HunterAbility.HighlightPosition(tile.m_58899_(), null, 0)) : Optional.empty()).stream().min(Comparator.comparingDouble(p -> p.blockPos().m_123331_((Vec3i)origin))).map(HunterAbility.HighlightPosition::blockPos).orElse(null);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            if (level.m_5776_()) {
                this.openCompassScreen();
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, hand);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 40;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!VaultUtils.isVaultLevel(context.m_43725_()) || context.m_43723_() == null || !context.m_43723_().m_6144_()) {
            return InteractionResult.PASS;
        }
        context.m_43723_().m_6672_(context.m_43724_());
        return super.m_6225_(context);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (stack.m_41782_() && stack.m_41783_().m_128441_(MODE_TAG)) {
            try {
                VaultCompassMode mode = VaultCompassMode.valueOf(stack.m_41783_().m_128461_(MODE_TAG));
                tooltip.add((Component)new TextComponent("Mode: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(mode.getDisplayName()).m_130940_(ChatFormatting.GOLD)));
            }
            catch (IllegalArgumentException e) {
                VaultMod.LOGGER.info("Invalid compass mode {} on item", (Object)stack.m_41783_().m_128461_(MODE_TAG));
            }
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player.m_183503_().m_46467_() % 5L == 0L) {
            player.m_5496_(SoundEvents.f_12210_, 1.0f, (float)player.m_21252_() / 40.0f);
        }
        super.onUsingTick(stack, player, count);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (!(livingEntity instanceof Player)) {
            return super.m_5922_(stack, level, livingEntity);
        }
        Player player = (Player)livingEntity;
        if (level.m_5776_()) {
            return stack;
        }
        BlockHitResult blockHitResult = CompassItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.setTarget(player, level, blockHitResult.m_82425_());
        }
        player.m_36335_().m_41524_(stack.m_41720_(), 10);
        player.m_5661_((Component)new TextComponent("New compass target set"), true);
        return super.m_5922_(stack, level, livingEntity);
    }

    private void setTarget(Player player, Level level, BlockPos pos) {
        ServerVaults.get(level).ifPresent(vault -> {
            Listeners listeners = vault.get(Vault.LISTENERS);
            if (listeners.contains(player.m_142081_())) {
                listeners.get(player.m_142081_()).set(Listener.COMPASS_TARGET, pos);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openCompassScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new VaultCompassScreen());
    }

    static {
        MODE_TARGETS.put(VaultCompassMode.ORE_ROOM, CompassItem::findNearestOreRoom);
        MODE_TARGETS.put(VaultCompassMode.CHALLENGE_ROOM, CompassItem::findNearestChallengeRoom);
        MODE_TARGETS.put(VaultCompassMode.EXIT, CompassItem::findExit);
        MODE_TARGETS.put(VaultCompassMode.GOD_ALTAR, CompassItem::findNearestGodAltar);
        MODE_TARGETS.put(VaultCompassMode.OBJECTIVE_PILLAR, CompassItem::findNearestObjectivePillar);
        MODE_TARGETS.put(VaultCompassMode.DUNGEON_DOOR, CompassItem::findNearestDungeonDoor);
        MODE_TARGETS.put(VaultCompassMode.TREASURE_DOOR, CompassItem::findNearestTreasureDoor);
        MODE_TARGETS.put(VaultCompassMode.COMPANION_EGG, CompassItem::findCompanionEgg);
    }

    private static interface TargetProvider {
        public BlockPos findTarget(Vault var1, ServerPlayer var2, StatCollector var3);
    }
}

