/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.init.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class InfiniteWaterBucketItem
extends BucketItem {
    public InfiniteWaterBucketItem(ResourceLocation id) {
        super(() -> Fluids.f_76193_, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
        this.setRegistryName(id);
    }

    public Fluid getFluid() {
        return Fluids.f_76193_;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return new ItemStack((ItemLike)ModItems.INFINITE_WATER_BUCKET);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new InfiniteWaterBucketHandler(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        BlockHitResult blockhitresult = InfiniteWaterBucketItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockPos blockpos = blockhitresult.m_82425_();
        BlockState state = pLevel.m_8055_(blockpos);
        if (!(state.m_60734_() instanceof CauldronBlock) && !(state.m_60734_() instanceof LayeredCauldronBlock)) {
            InteractionResultHolder result = super.m_7203_(pLevel, pPlayer, pHand);
            return new InteractionResultHolder(result.m_19089_(), (Object)new ItemStack((ItemLike)ModItems.INFINITE_WATER_BUCKET));
        }
        pLevel.m_7731_(blockpos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 3);
        if (pPlayer instanceof ServerPlayer) {
            CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)pPlayer, blockpos, itemstack);
        }
        pLevel.m_5594_(null, blockpos, this.getFluid().getAttributes().getEmptySound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19090_((Object)new ItemStack((ItemLike)ModItems.INFINITE_WATER_BUCKET));
    }

    public static class InfiniteWaterBucketHandler
    implements IFluidHandlerItem,
    ICapabilityProvider {
        private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
        protected ItemStack container;

        public InfiniteWaterBucketHandler(@Nonnull ItemStack container) {
            this.container = container;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.container;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return new FluidStack((Fluid)Fluids.f_76193_, 1000);
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || resource.getFluid() != Fluids.f_76193_) {
                return FluidStack.EMPTY;
            }
            return new FluidStack((Fluid)Fluids.f_76193_, resource.getAmount());
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.f_76193_, maxDrain);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.holder);
        }
    }
}

