/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.core.DataInitializationItem;
import iskallia.vault.item.core.VaultLevelItem;
import iskallia.vault.item.render.CatalystItemRenderer;
import iskallia.vault.item.render.core.IManualModelLoading;
import iskallia.vault.util.CodecUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;

public class InfusedCatalystItem
extends Item
implements VaultLevelItem,
IManualModelLoading,
DataInitializationItem {
    public static int MODELS = 15;

    public InfusedCatalystItem(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(1));
        this.setRegistryName(id);
    }

    public Component m_7626_(ItemStack stack) {
        String superString = "";
        if (InfusedCatalystItem.isSuper(stack)) {
            superString = "Super ";
        }
        return new TextComponent(superString).m_7220_(super.m_7626_(stack));
    }

    public static ItemStack create(int size, List<ResourceLocation> modifiers) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.VAULT_CATALYST_INFUSED);
        InfusedCatalystItem.setSize(stack, size);
        InfusedCatalystItem.setModifiers(stack, modifiers);
        return stack;
    }

    public static ItemStack createRandomSuperCatalyst(int modifiers) {
        JavaRandom random = JavaRandom.ofNanoTime();
        ItemStack stack = new ItemStack((ItemLike)ModItems.VAULT_CATALYST_INFUSED);
        InfusedCatalystItem.setSuper(stack, true);
        ResourceLocation pool = ModConfigs.PERSONAL_VAULT.getCatalystModifierPool();
        List<VaultModifier<?>> available = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(pool, 0, random);
        if (!available.isEmpty()) {
            Collections.shuffle(available, random.asRandomView());
            ArrayList<ResourceLocation> selected = new ArrayList<ResourceLocation>();
            int max = Math.min(modifiers, available.size());
            for (int i = 0; i < max; ++i) {
                selected.add(available.get(i).getId());
            }
            InfusedCatalystItem.setModifiers(stack, selected);
        }
        return stack;
    }

    public static ItemStack createDisplay(ResourceLocation pool, int minSize, int maxSize, List<ResourceLocation> modifiers) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.VAULT_CATALYST_INFUSED);
        stack.m_41784_().m_128359_("pool", pool.toString());
        if (minSize == maxSize) {
            InfusedCatalystItem.setSize(stack, minSize);
        } else {
            ListTag size = new ListTag();
            size.add((Object)IntTag.m_128679_((int)minSize));
            size.add((Object)IntTag.m_128679_((int)maxSize));
            stack.m_41784_().m_128365_("size", (Tag)size);
        }
        InfusedCatalystItem.setModifiers(stack, modifiers);
        return stack;
    }

    public static Optional<Integer> getSize(ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128425_("size", 99)) {
            return Optional.of(10);
        }
        return Optional.of(stack.m_41783_().m_128451_("size"));
    }

    public static List<ResourceLocation> getModifiers(ItemStack stack) {
        ArrayList<ResourceLocation> modifiers = new ArrayList<ResourceLocation>();
        if (stack.m_41783_() == null) {
            return modifiers;
        }
        ListTag list = stack.m_41783_().m_128437_("modifiers", 8);
        for (Tag child : list) {
            if (!(child instanceof StringTag)) continue;
            StringTag string = (StringTag)child;
            modifiers.add(new ResourceLocation(string.m_7916_()));
        }
        return modifiers;
    }

    public static void setSuper(ItemStack stack, boolean isSuper) {
        stack.m_41784_().m_128379_("isSuper", isSuper);
    }

    public static boolean isSuper(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_("isSuper");
    }

    public static void setSize(ItemStack stack, int size) {
        stack.m_41784_().m_128405_("size", size);
    }

    private static void setModifiers(ItemStack stack, List<ResourceLocation> modifiers) {
        ListTag list = new ListTag();
        modifiers.forEach(modifier -> list.add((Object)StringTag.m_129297_((String)modifier.toString())));
        stack.m_41784_().m_128365_("modifiers", (Tag)list);
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        List<ResourceLocation> modifiers = InfusedCatalystItem.getModifiers(stack);
        if (InfusedCatalystItem.isSuper(stack)) {
            tooltip.add((Component)new TextComponent("Used to modify your Personal Vault").m_130940_(ChatFormatting.GRAY));
        }
        if (!InfusedCatalystItem.isSuper(stack)) {
            InfusedCatalystItem.getSize(stack).ifPresentOrElse(size -> tooltip.add((Component)new TextComponent("Size: ").m_7220_((Component)new TextComponent(String.valueOf(size)).m_130948_(Style.f_131099_.m_178520_(0xDDDDDD)))), () -> tooltip.add((Component)new TextComponent("Size: ???").m_130940_(ChatFormatting.GRAY)));
        }
        if (!modifiers.isEmpty()) {
            for (ResourceLocation modifierId : modifiers) {
                VaultModifierRegistry.getOpt(modifierId).ifPresent(vaultModifier -> {
                    tooltip.add((Component)new TextComponent(" \u2022 " + vaultModifier.getDisplayName()).m_130948_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor())));
                    if (Screen.m_96638_()) {
                        tooltip.add((Component)new TextComponent("    " + vaultModifier.getDisplayDescription()).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                });
            }
        }
    }

    public static void setJeiModifiers(ItemStack itemStack, List<ResourceLocation> result) {
        if (itemStack.m_41720_() != ModItems.VAULT_CATALYST_INFUSED) {
            return;
        }
        CompoundTag tag = itemStack.m_41784_();
        CodecUtils.writeNBT(ResourceLocation.f_135803_.listOf(), result, nbt -> tag.m_128365_("modifiers", nbt));
    }

    @Override
    public void initializeVaultLoot(int vaultLevel, ItemStack stack, @Nullable BlockPos pos, @Nullable Vault vault) {
        stack.m_41784_().m_128405_("level", vaultLevel);
    }

    @Override
    public void initialize(ItemStack stack, RandomSource rand) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return;
        }
        if (nbt.m_128425_("pool", 8)) {
            ResourceLocation pool = new ResourceLocation(nbt.m_128461_("pool"));
            int level = nbt.m_128451_("level");
            ModConfigs.CATALYST.generate(pool, level, rand).ifPresent(result -> stack.m_41784_().m_128391_(result));
            nbt.m_128473_("pool");
            nbt.m_128473_("level");
        }
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        for (int i = 0; i < MODELS; ++i) {
            consumer.accept(new ModelResourceLocation("the_vault:catalyst/%d#inventory".formatted(i)));
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return CatalystItemRenderer.INSTANCE;
            }
        });
    }
}

