/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.entity.entity.DrillArrowEntity;
import iskallia.vault.util.MiscUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemDrillArrow
extends ArrowItem {
    public ItemDrillArrow(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(63));
        this.setRegistryName(id);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            for (ArrowTier tier : ArrowTier.values()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemDrillArrow.setArrowTier(stack, tier);
                items.add((Object)stack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent(ItemDrillArrow.getArrowTier(stack).getName()).m_130940_(ChatFormatting.GOLD));
    }

    public AbstractArrow m_6394_(Level world, ItemStack stack, LivingEntity shooter) {
        return new DrillArrowEntity(world, shooter).setMaxBreakCount(ItemDrillArrow.getArrowTier(stack).getBreakCount());
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, Player player) {
        return false;
    }

    @Nonnull
    public static ArrowTier getArrowTier(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ItemDrillArrow)) {
            return ArrowTier.NORMAL;
        }
        int tierOrd = stack.m_41784_().m_128451_("tier");
        return MiscUtils.getEnumEntry(ArrowTier.class, tierOrd);
    }

    public static void setArrowTier(ItemStack stack, @Nonnull ArrowTier tier) {
        if (!(stack.m_41720_() instanceof ItemDrillArrow)) {
            return;
        }
        stack.m_41784_().m_128405_("tier", tier.ordinal());
    }

    public static enum ArrowTier {
        NORMAL(400),
        RARE(700),
        EPIC(1000);

        private final int breakCount;

        private ArrowTier(int breakCount) {
            this.breakCount = breakCount;
        }

        public int getBreakCount() {
            return this.breakCount;
        }

        public String getName() {
            return "item.the_vault.drill_arrow." + this.name().toLowerCase();
        }
    }
}

