/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.ability.LegacyAbilityMapper;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRespecFlask
extends Item {
    public ItemRespecFlask(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(64));
        this.setRegistryName(id);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (ModConfigs.ABILITIES == null) {
            return;
        }
        if (this.m_41389_(group)) {
            ModConfigs.ABILITIES.get().ifPresent(tree -> tree.iterate(SpecializedSkill.class, skill -> {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemRespecFlask.setAbility(stack, skill.getId());
                items.add((Object)stack);
            }));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        String abilityStr = ItemRespecFlask.getAbility(stack);
        if (abilityStr != null) {
            ModConfigs.ABILITIES.getAbilityById(abilityStr).ifPresent(grp -> {
                MutableComponent ability = new TextComponent(grp.getName()).m_130940_(ChatFormatting.GOLD);
                tooltip.add(TextComponent.f_131282_);
                tooltip.add((Component)new TextComponent("Use to remove selected specialization"));
                tooltip.add((Component)new TextComponent("of ability ").m_7220_((Component)ability));
            });
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public static void setAbility(ItemStack stack, @Nullable String ability) {
        if (!(stack.m_41720_() instanceof ItemRespecFlask)) {
            return;
        }
        stack.m_41784_().m_128359_("Ability", ability);
    }

    @Nullable
    public static String getAbility(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ItemRespecFlask)) {
            return null;
        }
        CompoundTag tag = stack.m_41784_();
        return tag.m_128425_("Ability", 8) ? LegacyAbilityMapper.mapAbilityName(tag.m_128461_("Ability")) : null;
    }

    public static int getIndexOfAbility(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ItemRespecFlask)) {
            return -1;
        }
        String abilityStr = ItemRespecFlask.getAbility(stack);
        if (abilityStr == null) {
            return -1;
        }
        if (ModConfigs.ABILITIES == null) {
            return -1;
        }
        return ModConfigs.ABILITIES.getAbilityById(abilityStr).isPresent() && ModConfigs.ABILITIES.get().isPresent() ? ModConfigs.ABILITIES.get().get().skills.indexOf(ModConfigs.ABILITIES.getAbilityById(abilityStr).get()) : -1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        String abilityStr = ItemRespecFlask.getAbility(held);
        if (abilityStr == null) {
            return InteractionResultHolder.m_19098_((Object)held);
        }
        if (world.m_5776_()) {
            if (!this.hasAbilityClient(abilityStr)) {
                return InteractionResultHolder.m_19098_((Object)held);
            }
        } else if (player instanceof ServerPlayer) {
            SpecializedSkill specialized;
            AbilityTree tree = PlayerAbilitiesData.get(((ServerPlayer)player).m_183503_()).getAbilities(player);
            Skill skill = tree.getForId(abilityStr).orElse(null);
            if (!(skill instanceof SpecializedSkill) || (specialized = (SpecializedSkill)skill).getIndex() == 0) {
                return InteractionResultHolder.m_19098_((Object)held);
            }
        } else {
            return InteractionResultHolder.m_19098_((Object)held);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)held);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean hasAbilityClient(String abilityStr) {
        return ClientAbilityData.getTree().getForId(abilityStr).isPresent();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 24;
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entityLiving) {
        if (world instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)world;
            if (entityLiving instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityLiving;
                String abilityStr = ItemRespecFlask.getAbility(stack);
                if (abilityStr == null) {
                    return stack;
                }
                PlayerAbilitiesData data = PlayerAbilitiesData.get(sWorld);
                data.getAbilities((Player)player).getForId(abilityStr).ifPresent(skill -> {
                    if (skill instanceof SpecializedSkill) {
                        SpecializedSkill specialized = (SpecializedSkill)skill;
                        SkillContext context = SkillContext.of(player);
                        specialized.resetSpecialization(context);
                        PlayerVaultStats stats = PlayerVaultStatsData.get(sWorld).getVaultStats((Player)player);
                        stats.setSkillPoints(context.getLearnPoints());
                        if (!player.m_7500_()) {
                            stack.m_41774_(1);
                        }
                    }
                });
            }
        }
        return stack;
    }

    public boolean m_5812_(ItemStack pStack) {
        return true;
    }
}

