/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.objective.NullCrystalObjective;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ItemVaultCrystalSeal
extends Item {
    public static final String GREED_TIER_TAG = "greed_tier";

    public ItemVaultCrystalSeal(ResourceLocation id) {
        this(id, 1);
    }

    public ItemVaultCrystalSeal(ResourceLocation id, int maxStackSize) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(maxStackSize));
        this.setRegistryName(id);
    }

    public boolean configure(CrystalData crystal) {
        return ModConfigs.VAULT_CRYSTAL.applySeal(new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL), new ItemStack((ItemLike)this), new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL), crystal);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (ItemVaultCrystalSeal.hasGreedTier(stack)) {
            int tier = ItemVaultCrystalSeal.getGreedTier(stack);
            tooltip.add((Component)new TextComponent("Greed Tier: ").m_130948_(Style.f_131099_.m_178520_(0xE0E0E0)).m_7220_((Component)new TextComponent(String.valueOf(tier)).m_130948_(Style.f_131099_.m_178520_(1499360))));
        }
        if (!ModConfigs.isInitialized()) {
            return;
        }
        CrystalData crystal = CrystalData.empty();
        if (!this.configure(crystal)) {
            return;
        }
        if (crystal.getObjective() != NullCrystalObjective.INSTANCE) {
            crystal.getObjective().addText(tooltip, tooltip.size(), flag, ClientScheduler.INSTANCE.getTick());
        }
    }

    public static void setGreedTier(ItemStack stack, int tier) {
        if (tier < 0) {
            stack.m_41749_(GREED_TIER_TAG);
        } else {
            stack.m_41784_().m_128405_(GREED_TIER_TAG, tier);
        }
    }

    public static int getGreedTier(ItemStack stack) {
        return stack.m_41784_().m_128451_(GREED_TIER_TAG);
    }

    public static boolean hasGreedTier(ItemStack seal) {
        return seal.m_41782_() && seal.m_41783_() != null && seal.m_41783_().m_128441_(GREED_TIER_TAG);
    }
}

