/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.modifier.PlayerNoVaultFruitModifier;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemVaultFruit
extends Item {
    private static final Random rand = new Random();
    public static final UUID MAX_HEALTH_REDUCTION_ATTRIBUTE_MODIFIER_UUID = UUID.fromString("94574f3d-49dc-4fc5-8ca5-74707eb1c34d");
    public static FoodProperties VAULT_FRUIT_FOOD = new FoodProperties.Builder().m_38758_(0.0f).m_38760_(0).m_38766_().m_38765_().m_38767_();
    protected int extraVaultTicks;

    public ItemVaultFruit(ResourceLocation id, int extraVaultTicks) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41489_(VAULT_FRUIT_FOOD).m_41487_(64));
        this.setRegistryName(id);
        this.extraVaultTicks = extraVaultTicks;
    }

    public boolean onEaten(Level level, Player player) {
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
        float effectiveness = snapshot.getAttributeValue(ModGearAttributes.FRUIT_EFFECTIVENESS, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        int time = (int)((float)this.extraVaultTicks * (1.0f + effectiveness));
        CommonEvents.FRUIT_EATEN.invoke(this, player, time);
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        Vault vault;
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.m_5776_() && ServerVaults.get(level).isEmpty()) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (ServerVaults.get(level).isPresent() && (vault = ServerVaults.get(level).get()).get(Vault.MODIFIERS).getModifiers().stream().anyMatch(modifier -> modifier instanceof PlayerNoVaultFruitModifier)) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (!this.isPlayerMaxHealthGreaterThan(player, 2)) {
            if (player.f_19853_.m_5776_()) {
                player.m_5661_((Component)new TextComponent("Your max health is too low to eat this!").m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return super.m_7203_(level, player, hand);
    }

    @ParametersAreNonnullByDefault
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag tooltipFlag) {
        int seconds = Mth.m_14143_((float)((float)this.extraVaultTicks / 20.0f));
        String timeText = String.format("%d seconds", seconds);
        if (seconds > 90) {
            int minutes = seconds / 60;
            timeText = String.format("%d minutes", minutes);
        }
        MutableComponent cmp = new TextComponent("Adds ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(timeText).m_130940_(ChatFormatting.GREEN)).m_130946_(" to the Vault timer");
        tooltip.add(TextComponent.f_131282_);
        tooltip.add((Component)new TextComponent("Removes").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" 10% max health").m_130940_(ChatFormatting.RED)));
        tooltip.add((Component)cmp);
        tooltip.add(TextComponent.f_131282_);
        tooltip.add((Component)new TextComponent("Only edible inside a Vault").m_130940_(ChatFormatting.RED));
        super.m_7373_(itemStack, worldIn, tooltip, tooltipFlag);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack itemStack) {
        MutableComponent displayName = (MutableComponent)super.m_7626_(itemStack);
        return displayName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16563456)));
    }

    protected boolean isPlayerMaxHealthGreaterThan(Player player, int threshold) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22276_);
        if (attributeInstance == null) {
            return false;
        }
        return attributeInstance.m_22135_() > (double)threshold;
    }

    protected void reducePlayerMaxHealth(ServerPlayer serverPlayer) {
        this.reducePlayerMaxHealth(serverPlayer, 0.1f, 2);
    }

    protected void reducePlayerMaxHealth(ServerPlayer serverPlayer, float percentageReduction, int minimumReduction) {
        AttributeInstance attributeInstance = serverPlayer.m_21051_(Attributes.f_22276_);
        if (attributeInstance == null) {
            return;
        }
        AttributeModifier existingModifier = attributeInstance.m_22111_(MAX_HEALTH_REDUCTION_ATTRIBUTE_MODIFIER_UUID);
        double reductionAmount = 0.0;
        if (existingModifier != null) {
            reductionAmount += existingModifier.m_22218_();
            attributeInstance.m_22120_(MAX_HEALTH_REDUCTION_ATTRIBUTE_MODIFIER_UUID);
        }
        double reductionTarget = Math.max((double)minimumReduction, attributeInstance.m_22135_() * (double)percentageReduction);
        double multiplier = this.getAttributeMultiplier(attributeInstance);
        if (multiplier <= 0.0) {
            multiplier = 1.0;
        }
        attributeInstance.m_22125_(new AttributeModifier(MAX_HEALTH_REDUCTION_ATTRIBUTE_MODIFIER_UUID, "VaultFruitMaxHealthReduction", reductionAmount -= reductionTarget / multiplier, AttributeModifier.Operation.ADDITION));
    }

    private double getAttributeMultiplier(AttributeInstance attributeInstance) {
        double baseMultiplier = 1.0;
        for (AttributeModifier modifier : attributeInstance.m_22104_(AttributeModifier.Operation.MULTIPLY_BASE)) {
            baseMultiplier += modifier.m_22218_();
        }
        double totalMultiplier = baseMultiplier;
        for (AttributeModifier modifier : attributeInstance.m_22104_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            totalMultiplier *= 1.0 + modifier.m_22218_();
        }
        return totalMultiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void on(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT || event.player.m_183503_().m_46467_() % 10L != 0L || ServerVaults.get(event.player.f_19853_).isPresent()) {
            return;
        }
        Player player = event.player;
        synchronized (player) {
            AttributeInstance attributeInstance = event.player.m_21051_(Attributes.f_22276_);
            if (attributeInstance != null) {
                attributeInstance.m_22120_(MAX_HEALTH_REDUCTION_ATTRIBUTE_MODIFIER_UUID);
            }
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (!level.m_5776_() && entityLiving instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entityLiving;
            if (this.onEaten(level, (Player)player)) {
                this.reducePlayerMaxHealth(player);
                this.successEaten(level, player);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11767_, SoundSource.MASTER, 1.0f, 1.0f);
            } else {
                return stack;
            }
        }
        return entityLiving.m_5584_(level, stack);
    }

    protected void successEaten(Level level, ServerPlayer sPlayer) {
    }

    public static class MysticPear
    extends ItemVaultFruit {
        public MysticPear(ResourceLocation id, int extraVaultTicks) {
            super(id, extraVaultTicks);
        }

        @Override
        protected void successEaten(Level level, ServerPlayer sPlayer) {
            sPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 600));
        }

        @Override
        public void m_7373_(ItemStack itemStack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag tooltipFlag) {
            tooltip.add(TextComponent.f_131282_);
            tooltip.add((Component)new TextComponent("Inflicts Wither or Poison").m_130940_(ChatFormatting.RED));
            super.m_7373_(itemStack, worldIn, tooltip, tooltipFlag);
        }
    }
}

