/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.block.entity.base.InventoryRetainerTileEntity;
import iskallia.vault.container.oversized.OverSizedInvWrapper;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.container.provider.VaultKeyringProvider;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.ItemVaultKey;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ItemVaultKeyring
extends Item {
    public ItemVaultKeyring(ResourceLocation id) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
        this.setRegistryName(id);
    }

    public void m_6787_(CreativeModeTab cat, NonNullList<ItemStack> items) {
        if (this.m_41389_(cat)) {
            items.add((Object)new ItemStack((ItemLike)this));
            ItemStack keyring = new ItemStack((ItemLike)ModItems.TREAUSURE_KEYRING);
            ArrayList<OverSizedItemStack> stacks = new ArrayList<OverSizedItemStack>();
            ForgeRegistries.ITEMS.forEach(item -> {
                if (item instanceof ItemVaultKey) {
                    stacks.add(OverSizedItemStack.of(new ItemStack((ItemLike)item, 64)));
                }
            });
            ItemVaultKeyring.setStoredStacks(keyring, stacks);
            items.add((Object)keyring);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack inHand = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            int slot = hand == InteractionHand.MAIN_HAND ? sPlayer.m_150109_().f_35977_ : 40;
            ItemVaultKeyring.openKeyring(sPlayer, slot, inHand);
            return InteractionResultHolder.m_19090_((Object)inHand);
        }
        return InteractionResultHolder.m_19098_((Object)inHand);
    }

    public static void openKeyring(ServerPlayer player, int slot, ItemStack keyringStack) {
        VaultKeyringProvider provider = new VaultKeyringProvider(player, slot, keyringStack);
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)provider, provider.extraDataWriter());
    }

    public static OverSizedInventory getInventory(ItemStack stack) {
        return ItemVaultKeyring.getInventory(stack, player -> true);
    }

    public static OverSizedInventory getInventory(ItemStack stack, Predicate<Player> stillValidCheck) {
        if (!(stack.m_41720_() instanceof ItemVaultKeyring)) {
            return OverSizedInventory.EMPTY;
        }
        List<OverSizedItemStack> stored = ItemVaultKeyring.getStoredStacks(stack);
        if (stored.isEmpty()) {
            return OverSizedInventory.EMPTY;
        }
        NonNullList mutableStored = NonNullList.m_122780_((int)stored.size(), (Object)OverSizedItemStack.EMPTY);
        for (int i = 0; i < stored.size(); ++i) {
            mutableStored.set(i, (Object)stored.get(i));
        }
        return new OverSizedInventory((NonNullList<OverSizedItemStack>)mutableStored, stacks -> ItemVaultKeyring.setStoredStacks(stack, (List<OverSizedItemStack>)stacks), stillValidCheck);
    }

    public static List<OverSizedItemStack> getStoredStacks(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ItemVaultKeyring)) {
            return new ArrayList<OverSizedItemStack>();
        }
        int keyCount = (int)ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof ItemVaultKey).map(item -> (ItemVaultKey)((Object)item)).filter(ItemVaultKey::isActive).count();
        CompoundTag tag = stack.m_41784_();
        ListTag stacksTag = tag.m_128437_("stacks", 10);
        ArrayList<OverSizedItemStack> stacks = new ArrayList<OverSizedItemStack>();
        for (int i = 0; i < Math.max(keyCount, stacksTag.size()); ++i) {
            CompoundTag stackTag = stacksTag.m_128728_(i);
            stacks.add(OverSizedItemStack.deserialize(stackTag));
        }
        return stacks;
    }

    public static void setStoredStacks(ItemStack stack, List<OverSizedItemStack> stacks) {
        if (!(stack.m_41720_() instanceof ItemVaultKeyring)) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        ListTag stacksTag = new ListTag();
        stacks.forEach(s -> stacksTag.add((Object)s.serialize()));
        tag.m_128365_("stacks", (Tag)stacksTag);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public static NonNullSupplier<IItemHandler> getInventorySupplier(final ItemStack stack) {
        return new NonNullSupplier<IItemHandler>(){

            @Nonnull
            public IItemHandler get() {
                return new OverSizedInvWrapper(ItemVaultKeyring.getInventory(stack));
            }
        };
    }

    @javax.annotation.Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @javax.annotation.Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
                return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? LazyOptional.of(ItemVaultKeyring.getInventorySupplier(stack)).cast() : LazyOptional.empty();
            }
        };
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        super.m_7373_(stack, pLevel, tooltip, pIsAdvanced);
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        InventoryRetainerTileEntity.ContentDisplayInfo itemContent = InventoryRetainerTileEntity.displayContentsOverSized(5, stacks -> stacks.addAll(ItemVaultKeyring.getStoredStacks(stack).stream().filter(item -> !item.isEmpty()).toList()));
        if (itemContent.display().isEmpty()) {
            return;
        }
        tooltip.add(TextComponent.f_131282_);
        tooltip.add((Component)new TextComponent("Contains:").m_130940_(ChatFormatting.GRAY));
        tooltip.addAll(itemContent.display().subList(0, Math.min(itemContent.display().size(), itemContent.displayCount())));
        Component moreCmp = itemContent.hasMoreCmp().apply(itemContent.display().size() - itemContent.displayCount());
        if (moreCmp != null) {
            tooltip.add(moreCmp);
        }
    }
}

