/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.gear.GearScoreHelper;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.core.DataTransferItem;
import iskallia.vault.item.core.VaultLevelItem;
import iskallia.vault.network.message.OpenClientScreenMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.JewelExpertise;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.util.LootInitialization;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;

public class JewelPouchItem
extends Item
implements VaultLevelItem,
IdentifiableItem {
    public JewelPouchItem(ResourceLocation id, Item.Properties properties) {
        super(properties);
        this.setRegistryName(id);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag advanced) {
        String levelDescription = JewelPouchItem.getStoredLevel(stack).map(String::valueOf).orElse("???");
        MutableComponent lvlComponent = new TextComponent(levelDescription).m_130940_(ChatFormatting.AQUA);
        tooltip.add((Component)new TextComponent("Level: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)lvlComponent));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND) {
            if (!level.m_5776_() && player.m_6144_()) {
                if (JewelPouchItem.instantOpen(player, stack, true)) {
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
            } else if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                List<RolledJewel> jewels = JewelPouchItem.getJewels(stack);
                if (jewels.isEmpty()) {
                    int vaultLevel = JewelPouchItem.getStoredLevel(stack).orElseGet(() -> PlayerVaultStatsData.get(sPlayer.m_183503_()).getVaultStats((Player)sPlayer).getVaultLevel());
                    int additionalIdentifiedJewels = 0;
                    ExpertiseTree expertises = PlayerExpertisesData.get(sPlayer.m_183503_()).getExpertises((Player)sPlayer);
                    for (JewelExpertise expertise : expertises.getAll(JewelExpertise.class, Skill::isUnlocked)) {
                        additionalIdentifiedJewels += expertise.getAdditionalIdentifiedJewels();
                    }
                    JewelPouchItem.generateJewels(stack, vaultLevel, additionalIdentifiedJewels);
                    jewels = JewelPouchItem.getJewels(stack);
                    player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11680_, player.m_5720_(), 1.0f, 0.9f + player.m_183503_().m_5822_().nextFloat(0.1f));
                }
                if (!jewels.isEmpty()) {
                    ServerScheduler.INSTANCE.schedule(1, () -> ModNetwork.CHANNEL.sendTo((Object)new OpenClientScreenMessage(OpenClientScreenMessage.Type.JEWEL_POUCH), sPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT));
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private static void generateJewels(ItemStack stack, int vaultLevel, int additionalIdentifiedJewels) {
        ModConfigs.JEWEL_POUCH.getJewel().ifPresent(entry -> {
            ItemStack jewelStack;
            int i;
            ArrayList<RolledJewel> results = new ArrayList<RolledJewel>();
            int jewelCount = ModConfigs.JEWEL_POUCH.getIdentifiedJewelCount() + additionalIdentifiedJewels;
            for (i = 0; i < jewelCount; ++i) {
                jewelStack = entry.createItemStack();
                jewelStack = LootInitialization.initializeVaultLoot(jewelStack, vaultLevel);
                results.add(new RolledJewel(jewelStack, true));
            }
            for (i = 0; i < ModConfigs.JEWEL_POUCH.getUnidentifiedJewelCount(); ++i) {
                jewelStack = entry.createItemStack();
                Item patt5415$temp = jewelStack.m_41720_();
                if (patt5415$temp instanceof VaultLevelItem) {
                    VaultLevelItem levelItem = (VaultLevelItem)patt5415$temp;
                    levelItem.initializeVaultLoot(vaultLevel, jewelStack, null, null);
                }
                jewelStack = DataTransferItem.doConvertStack(jewelStack);
                results.add(new RolledJewel(jewelStack, false));
            }
            JewelPouchItem.setJewels(stack, results);
        });
    }

    private static boolean instantOpen(@Nonnull Player player, ItemStack jewelPouch, boolean playEffects) {
        int storedLevel = JewelPouchItem.getStoredLevel(jewelPouch).or(() -> Optional.of(player).filter(p -> p instanceof ServerPlayer).map(p -> (ServerPlayer)p).map(sPlayer -> PlayerVaultStatsData.get(sPlayer.m_183503_()).getVaultStats((Player)sPlayer).getVaultLevel())).orElse(-1);
        if (storedLevel == -1) {
            return false;
        }
        Level level = player.m_183503_();
        return ModConfigs.JEWEL_POUCH.getJewel().map(entry -> {
            int additionalIdentifiedJewels = 0;
            if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                ExpertiseTree expertises = PlayerExpertisesData.get(sPlayer.m_183503_()).getExpertises((Player)sPlayer);
                for (JewelExpertise expertise : expertises.getAll(JewelExpertise.class, Skill::isUnlocked)) {
                    additionalIdentifiedJewels += expertise.getAdditionalIdentifiedJewels();
                }
            }
            int jewelCount = ModConfigs.JEWEL_POUCH.getIdentifiedJewelCount() + additionalIdentifiedJewels + 1;
            ArrayList<ItemStack> jewels = new ArrayList<ItemStack>();
            for (int i = 0; i < jewelCount; ++i) {
                ItemStack jewelStack2 = entry.createItemStack();
                jewelStack2 = LootInitialization.initializeVaultLoot(jewelStack2, storedLevel);
                jewels.add(jewelStack2);
            }
            return GearScoreHelper.pickHighestWeight(jewels).map(jewelStack -> {
                player.m_7197_(jewelStack, false, false);
                if (level instanceof ServerLevel) {
                    ServerLevel sLevel = (ServerLevel)level;
                    if (playEffects) {
                        Vec3 pos = player.m_20182_();
                        sLevel.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11688_, SoundSource.PLAYERS, 1.0f, 2.0f);
                        sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123799_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 500, 1.0, 1.0, 1.0, 0.5);
                    }
                }
                if (!player.m_7500_()) {
                    jewelPouch.m_41774_(1);
                }
                return true;
            }).orElse(false);
        }).orElse(false);
    }

    @Override
    public void initializeVaultLoot(int vaultLevel, ItemStack stack, @Nullable BlockPos pos, @Nullable Vault vault) {
        JewelPouchItem.setStoredLevel(stack, vaultLevel);
    }

    @Override
    public VaultGearState getState(ItemStack stack) {
        if (!JewelPouchItem.getJewels(stack).isEmpty()) {
            return VaultGearState.IDENTIFIED;
        }
        return VaultGearState.UNIDENTIFIED;
    }

    @Override
    public void setState(ItemStack stack, VaultGearState state) {
    }

    @Override
    public void inventoryIdentificationTick(Player player, ItemStack stack) {
    }

    @Override
    public void tickRoll(ItemStack stack, @Nullable Player player) {
    }

    @Override
    public void tickFinishRoll(ItemStack stack, @Nullable Player player, boolean identify) {
        if (player == null) {
            return;
        }
        int count = Math.min(32, stack.m_41613_());
        for (int i = 0; i < count; ++i) {
            JewelPouchItem.instantOpen(player, stack, false);
        }
    }

    @Override
    public boolean canIdentify(Player player, ItemStack stack) {
        return JewelPouchItem.getJewels(stack).isEmpty();
    }

    public static void setStoredLevel(ItemStack stack, int vaultLevel) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("vaultLevel", vaultLevel);
    }

    public static Optional<Integer> getStoredLevel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("vaultLevel")) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128451_("vaultLevel"));
    }

    public static void setJewels(ItemStack stack, List<RolledJewel> results) {
        CompoundTag tag = stack.m_41784_();
        ListTag resultTag = new ListTag();
        for (RolledJewel outcome : results) {
            resultTag.add((Object)outcome.serialize());
        }
        tag.m_128365_("jewels", (Tag)resultTag);
    }

    public static List<RolledJewel> getJewels(ItemStack stack) {
        ArrayList<RolledJewel> results = new ArrayList<RolledJewel>();
        CompoundTag tag = stack.m_41784_();
        ListTag resultTag = tag.m_128437_("jewels", 10);
        resultTag.forEach(entry -> results.add(RolledJewel.fromTag((CompoundTag)entry)));
        return results;
    }

    public record RolledJewel(ItemStack stack, boolean identified) {
        public static RolledJewel fromTag(CompoundTag tag) {
            return new RolledJewel(ItemStack.m_41712_((CompoundTag)tag.m_128469_("item")), tag.m_128471_("identified"));
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("item", (Tag)this.stack.serializeNBT());
            tag.m_128379_("identified", this.identified);
            return tag;
        }
    }
}

