/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.VaultMod;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.type.Research;
import iskallia.vault.util.PlayerReference;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KnowledgeBrewItem
extends Item {
    public KnowledgeBrewItem(Item.Properties properties) {
        super(properties);
        this.setRegistryName(VaultMod.id("knowledge_brew"));
    }

    public int m_8105_(ItemStack pStack) {
        return 40;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        super.m_7836_(pStack, pLevel, pPlayer);
        if (pLevel instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)pLevel;
            KnowledgeBrewItem.setOwner(pStack, pPlayer);
            PlayerResearchesData data = PlayerResearchesData.get(level);
            KnowledgeBrewItem.setResearchTree(pStack, data.getResearches(pPlayer));
        }
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pLevel instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)pLevel;
                if (KnowledgeBrewItem.getOwner(pStack) == null) {
                    KnowledgeBrewItem.setOwner(pStack, player);
                }
                if (KnowledgeBrewItem.getResearchTree(pStack) == null) {
                    PlayerResearchesData data = PlayerResearchesData.get(level);
                    KnowledgeBrewItem.setResearchTree(pStack, data.getResearches(player));
                }
            }
        }
    }

    public static void setExp(ItemStack stack, int exp) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("VaultExp", exp);
    }

    public static void setResearchTree(ItemStack stack, ResearchTree researchTree) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("ResearchTree", (Tag)researchTree.serializeNBT());
    }

    @Nullable
    public static ResearchTree getResearchTree(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("ResearchTree")) {
            return null;
        }
        ResearchTree researchTree = ResearchTree.empty();
        researchTree.deserializeNBT(tag.m_128469_("ResearchTree"));
        return researchTree;
    }

    public static void setOwner(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128362_("Owner", player.m_142081_());
    }

    public static UUID getOwner(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128403_("Owner") ? stack.m_41784_().m_128342_("Owner") : null;
    }

    @NotNull
    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        ResearchTree researchTree;
        Player player;
        Player player2 = player = pEntityLiving instanceof Player ? (Player)pEntityLiving : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, pStack);
        }
        if (!pLevel.f_46443_ && (researchTree = KnowledgeBrewItem.getResearchTree(pStack)) != null) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            researchTree.getResearchesDone().forEach(research -> {
                if (research != null) {
                    PlayerResearchesData data = PlayerResearchesData.get((ServerLevel)pLevel);
                    if (data.getResearches((Player)serverPlayer).isResearched((String)research)) {
                        return;
                    }
                    Research researchType = ModConfigs.RESEARCHES.getByName((String)research);
                    if (researchType == null) {
                        VaultMod.LOGGER.error("Research " + research + " not found");
                        return;
                    }
                    data.research(serverPlayer, researchType, false);
                    if (researchType.getDiscoversModels() != null && !researchType.getDiscoversModels().isEmpty()) {
                        DiscoveredModelsData discoveredModelsData = DiscoveredModelsData.get((ServerLevel)pLevel);
                        Collection<PlayerReference> discoveringPlayers = data.isInTeam(serverPlayer.m_142081_()) ? data.getTeamMembers(serverPlayer.m_142081_()) : Collections.singleton(new PlayerReference((Player)serverPlayer));
                        researchType.getDiscoversModels().stream().map(ResourceLocation::new).forEach(modelId -> ModDynamicModels.REGISTRIES.getModelAndAssociatedItem((ResourceLocation)modelId).ifPresent(pair -> {
                            for (PlayerReference discoveringPlayer : discoveringPlayers) {
                                DynamicModel gearModel = (DynamicModel)pair.getFirst();
                                Item associatedItem = (Item)pair.getSecond();
                                discoveredModelsData.discoverModelAndBroadcast(associatedItem, gearModel.getId(), discoveringPlayer);
                            }
                        }));
                    }
                }
            });
        }
        if (player != null) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                pStack.m_41774_(1);
            }
        }
        if ((player == null || !player.m_150110_().f_35937_) && pStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        pLevel.m_142346_((Entity)pEntityLiving, GameEvent.f_157805_, pEntityLiving.m_146901_());
        return pStack;
    }

    public SoundEvent m_6023_() {
        return SoundEvents.f_11911_;
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_11911_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (!pLevel.f_46443_) {
            UUID playerUUID;
            UUID owner;
            if (!((ServerLevel)pLevel).m_142572_().m_129900_().m_46207_(ModGameRules.ALLOW_KNOWLEDGE_BREW)) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            ResearchTree researchTree = KnowledgeBrewItem.getResearchTree(pPlayer.m_21120_(pHand));
            if (KnowledgeBrewItem.getOwner(pPlayer.m_21120_(pHand)) != null && (owner = KnowledgeBrewItem.getOwner(pPlayer.m_21120_(pHand))) == (playerUUID = pPlayer.m_142081_())) {
                return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pHand));
            }
            if (researchTree != null && pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
            }
            return ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level level, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        ResearchTree researchTree;
        super.m_7373_(pStack, level, pTooltipComponents, pIsAdvanced);
        if (KnowledgeBrewItem.getOwner(pStack) != null) {
            UUID ownerUUID = KnowledgeBrewItem.getOwner(pStack);
            assert (ownerUUID != null);
            String playerName = "";
            if (level != null) {
                Player player = level.m_46003_(ownerUUID);
                if (player != null) {
                    playerName = player.m_7755_().getString();
                }
                pTooltipComponents.add((Component)new TextComponent("Owner: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(playerName).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#FFE637")))));
            }
        }
        if ((researchTree = KnowledgeBrewItem.getResearchTree(pStack)) != null) {
            researchTree.getResearchesDone().stream().limit(5L).forEach(research -> pTooltipComponents.add((Component)new TextComponent(" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(research).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#FFE637"))))));
            if (researchTree.getResearchesDone().size() > 5) {
                pTooltipComponents.add((Component)new TextComponent(" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent("...").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#FFE637")))));
            }
        } else {
            pTooltipComponents.add((Component)new TextComponent("Research Tree: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent("None").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#FFE637")))));
        }
    }
}

