/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import iskallia.vault.block.entity.DemagnetizerTileEntity;
import iskallia.vault.event.InputEvents;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.item.CuriosGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.IConditionalDamageable;
import iskallia.vault.mana.Mana;
import iskallia.vault.world.data.ServerVaults;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Deprecated(forRemoval=true)
public class LegacyMagnetItem
extends Item
implements DyeableLeatherItem,
IConditionalDamageable,
ICurioItem,
CuriosGearItem {
    private static final UUID HEALTH_MODIFIER_ID = UUID.fromString("6d7e39e3-b6c8-4410-a8ce-d2cd344e465a");
    private static final HashMap<UUID, UUID> PULLED_ITEMS_TO_PULLING_PLAYERS = new HashMap();
    private static int PULLED_ITEM_BEING_PICKED_UP_COUNT = 0;

    public LegacyMagnetItem(ResourceLocation id) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
        this.setRegistryName(id);
    }

    @Override
    public boolean isImmuneToDamage(ItemStack stack, Player player) {
        return LegacyMagnetItem.getPerk(stack) == Perk.IMMORTAL && ServerVaults.get(player.f_19853_).isEmpty();
    }

    public static int getTextureColor(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : -65536;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        int level = (100 - LegacyMagnetItem.getSturdiness(stack)) / ModConfigs.MAGNET_CONFIG.getSturdinessDecrement();
        tooltip.add((Component)new TextComponent("Level " + String.valueOf(ChatFormatting.YELLOW) + level));
        LegacyMagnetItem.addRepairTooltip(tooltip, LegacyMagnetItem.getUsedRepairSlots(stack), LegacyMagnetItem.getMaxRepairSlots(stack));
        if (LegacyMagnetItem.getMagnetInCurio((LivingEntity)Minecraft.m_91087_().f_91074_) == stack) {
            tooltip.add((Component)new TextComponent(" "));
            tooltip.add((Component)new TextComponent(String.valueOf(ChatFormatting.BLUE) + "Enabled"));
        }
        tooltip.add((Component)new TextComponent(" "));
        for (Stat s : Stat.values()) {
            int value = LegacyMagnetItem.getStatUpgrade(stack, s);
            if (value == 0) continue;
            MutableComponent component = new TextComponent(s.getReadableName() + (value > 0 ? " +" : " ") + value).m_130948_(Style.f_131099_.m_131148_(ModConfigs.MAGNET_CONFIG.getStatColor(s)));
            if (InputEvents.isShiftDown()) {
                component.m_7220_((Component)new TextComponent(" " + String.valueOf(ChatFormatting.DARK_GRAY) + ModConfigs.MAGNET_CONFIG.getUpgrade(s).getAdvancedTooltip()));
            }
            tooltip.add((Component)component);
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        int mana = LegacyMagnetItem.getUsableStat(pStack, Stat.MANA_EFFICIENCY);
        int range = LegacyMagnetItem.getUsableStat(pStack, Stat.RANGE);
        int speed = LegacyMagnetItem.getUsableStat(pStack, Stat.VELOCITY);
        int perkPower = 0;
        Perk p = LegacyMagnetItem.getPerk(pStack);
        if (p != Perk.NONE) {
            perkPower = LegacyMagnetItem.getPerkPower(pStack);
        }
        return Optional.of(new MagnetTooltip(range, speed, mana, p, perkPower));
    }

    public static ChatFormatting getSturdinessColor(int sturdiness) {
        float cc = ModConfigs.MAGNET_CONFIG.getSturdinessCutoff();
        ChatFormatting cl = (float)sturdiness <= cc ? ChatFormatting.RED : ((float)sturdiness < cc + (100.0f - cc) / 2.0f ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
        return cl;
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (itemSlot == -1 && this.hasDurabilityLeft(stack) && !player.m_36335_().m_41519_(stack.m_41720_()) && !DemagnetizerTileEntity.hasDemagnetizerAround(entity) && LegacyMagnetItem.getMagnetInCurio((LivingEntity)player) == stack) {
                boolean instant = this.shouldPullInstantly(stack);
                boolean moveItems = this.shouldPullItems(stack);
                boolean moveXp = this.shouldPullExperience(stack);
                float speed = (float)LegacyMagnetItem.getUsableStat(stack, Stat.VELOCITY) * 0.05f;
                float radius = LegacyMagnetItem.getUsableStat(stack, Stat.RANGE);
                if (moveXp) {
                    List orbs = world.m_45976_(ExperienceOrb.class, player.m_142469_().m_82400_((double)radius));
                    for (ExperienceOrb orb : orbs) {
                        this.moveXpToPlayer(orb, player, speed, instant);
                    }
                }
                if (moveItems) {
                    int itemsForOneMana;
                    float manaCostPerItem;
                    float maxMana = Mana.get(player);
                    int itemsICanPickUp = (int)(maxMana / (manaCostPerItem = 1.0f / ((float)(itemsForOneMana = LegacyMagnetItem.getUsableStat(stack, Stat.MANA_EFFICIENCY)) * 20.0f)));
                    if (itemsICanPickUp <= 0) {
                        return;
                    }
                    List items = world.m_45976_(ItemEntity.class, player.m_142469_().m_82400_((double)radius));
                    items.sort(Comparator.comparingDouble(e -> e.m_20182_().m_82557_(player.m_20182_())));
                    for (ItemEntity itemEntity : items) {
                        if (itemsICanPickUp <= 0) {
                            return;
                        }
                        if (!itemEntity.m_6084_() || stack.m_41784_().m_128471_("PreventRemoteMovement") || itemEntity.m_19880_().contains("PreventMagnetMovement")) continue;
                        if (!PULLED_ITEMS_TO_PULLING_PLAYERS.containsKey(itemEntity.m_142081_())) {
                            Player closest = this.getClosestPlayerWithMagnet(itemEntity, radius);
                            PULLED_ITEMS_TO_PULLING_PLAYERS.put(itemEntity.m_142081_(), closest == null ? player.m_142081_() : closest.m_142081_());
                        }
                        if (!PULLED_ITEMS_TO_PULLING_PLAYERS.get(itemEntity.m_142081_()).equals(player.m_142081_())) continue;
                        ItemStack entityStack = itemEntity.m_32055_();
                        int amount = entityStack.m_41613_();
                        itemEntity.m_32061_();
                        if (itemsICanPickUp < amount) {
                            ItemEntity split = itemEntity.m_32066_();
                            world.m_7967_((Entity)split);
                            split.m_32055_().m_41764_(amount - itemsICanPickUp);
                            itemEntity.m_32055_().m_41764_(itemsICanPickUp);
                        }
                        this.moveItemToPlayer(itemEntity, player, speed, instant);
                        itemsICanPickUp -= itemEntity.m_32055_().m_41613_();
                    }
                }
            }
        }
    }

    public boolean hasDurabilityLeft(ItemStack stack) {
        return stack.m_41773_() < stack.m_41776_() - 1;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int missing = stack.m_41776_() - 1 - stack.m_41773_();
        return Math.min(missing, amount);
    }

    private void moveItemToPlayer(ItemEntity item, Player player, float speed, boolean instant) {
        if (instant) {
            item.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        } else {
            Vec3 target = player.m_20182_();
            Vec3 current = item.m_20182_();
            Vec3 velocity = target.m_82546_(current).m_82541_().m_82490_((double)speed);
            item.m_5997_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            item.f_19864_ = true;
        }
    }

    private void moveXpToPlayer(ExperienceOrb orb, Player player, float speed, boolean instant) {
        if (instant) {
            orb.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        } else {
            Vec3 target = player.m_20182_();
            Vec3 current = orb.m_20182_();
            Vec3 velocity = target.m_82546_(current).m_82541_().m_82490_((double)speed);
            orb.m_5997_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            orb.f_19864_ = true;
        }
    }

    public static int getMaxRepairSlots(ItemStack stack) {
        return ModConfigs.MAGNET_CONFIG.getBaseRepairSlots() + (LegacyMagnetItem.getPerk(stack) == Perk.REINFORCED ? 2 : 0);
    }

    public static int getUsedRepairSlots(ItemStack stack) {
        return stack.m_41784_().m_128451_("UsedRepairs");
    }

    public static void useRepairSlot(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int current = tag.m_128451_("UsedRepairs");
        tag.m_128405_("UsedRepairs", current + 1);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return toRepair.m_41720_() instanceof LegacyMagnetItem && repair.m_41720_() == ModItems.REPAIR_CORE;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @Nullable
    private Player getClosestPlayerWithMagnet(ItemEntity item, double radius) {
        List players = item.m_20193_().m_45976_(Player.class, item.m_142469_().m_82400_(radius));
        if (players.isEmpty()) {
            return null;
        }
        Player closest = (Player)players.get(0);
        double distance = radius;
        for (Player player : players) {
            double temp = player.m_20270_((Entity)item);
            if (!(temp < distance) || !this.hasEnabledMagnetInRange(player, radius)) continue;
            closest = player;
            distance = temp;
        }
        return closest;
    }

    private boolean hasEnabledMagnetInRange(Player player, double radius) {
        ItemStack magnet = LegacyMagnetItem.getMagnetInCurio((LivingEntity)player);
        if (!magnet.m_41619_()) {
            int range = LegacyMagnetItem.getUsableStat(magnet, Stat.RANGE);
            return (double)range >= radius;
        }
        return false;
    }

    public static ItemStack getMagnetInCurio(LivingEntity entity) {
        AtomicReference<ItemStack> magnet = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(c -> c.getStacksHandler("belt").ifPresent(s -> {
            ItemStack stack = s.getStacks().getStackInSlot(0);
            if (stack.m_41720_() instanceof LegacyMagnetItem) {
                magnet.set(stack);
            }
        }));
        return magnet.get();
    }

    public int getMaxDamage(ItemStack stack) {
        return LegacyMagnetItem.getUsableStat(stack, Stat.DURABILITY);
    }

    public static int getUsableStat(ItemStack stack, Stat stat) {
        return LegacyMagnetItem.getBaseStat(stat) + LegacyMagnetItem.getStatUpgrade(stack, stat);
    }

    public static int getBaseStat(Stat stat) {
        return ModConfigs.MAGNET_CONFIG.getUpgrade(stat).getBaseValue();
    }

    public static int getStatUpgrade(ItemStack stack, Stat stat) {
        CompoundTag c = stack.m_41784_();
        return c.m_128451_(stat.name);
    }

    public static void setStatUpgrade(ItemStack stack, int statValue, Stat stat) {
        stack.m_41784_().m_128405_(stat.name, statValue);
    }

    public static void increaseStatUpgrade(ItemStack stack, Stat stat, int increase) {
        CompoundTag c = stack.m_41784_();
        c.m_128405_(stat.name, c.m_128451_(stat.name) + increase);
    }

    public static int getSturdiness(ItemStack stack) {
        CompoundTag c = stack.m_41784_();
        return 100 - c.m_128451_("SturdinessDamage");
    }

    public static void decreaseSturdiness(ItemStack stack, int decrease) {
        CompoundTag c = stack.m_41784_();
        c.m_128405_("SturdinessDamage", c.m_128451_("SturdinessDamage") + decrease);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap attrMap = HashMultimap.create();
        if (this.isIntendedSlot(stack, slotContext.identifier()) && LegacyMagnetItem.getPerk(stack) == Perk.CHUNKY) {
            attrMap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(HEALTH_MODIFIER_ID, "Chunky Health Mod", 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        return attrMap;
    }

    @Override
    public boolean isIntendedSlot(ItemStack stack, String slot) {
        return "belt".equals(slot);
    }

    public static Perk getPerk(ItemStack stack) {
        CompoundTag c = stack.m_41784_();
        return Perk.values()[c.m_128451_("Perk")];
    }

    public static int getPerkPower(ItemStack stack) {
        CompoundTag c = stack.m_41784_();
        return c.m_128451_("PerkPower");
    }

    public static void setPerk(ItemStack stack, Perk perk, int perkValue) {
        stack.m_41784_().m_128405_("Perk", perk.ordinal());
        stack.m_41784_().m_128405_("PerkPower", perkValue);
        switch (perk) {
            case HOARD: {
                Float data = AttributeGearData.read(stack);
                ((AttributeGearData)((Object)data)).createOrReplaceAttributeValue(ModGearAttributes.ITEM_QUANTITY, (Float)Float.valueOf(0.25f));
                ((AttributeGearData)((Object)data)).write(stack);
                break;
            }
            case TREASURE: {
                Float data = AttributeGearData.read(stack);
                ((AttributeGearData)((Object)data)).createOrReplaceAttributeValue(ModGearAttributes.ITEM_RARITY, (Float)Float.valueOf(0.25f));
                ((AttributeGearData)((Object)data)).write(stack);
                break;
            }
            case SHARP: {
                Float data = AttributeGearData.read(stack);
                ((AttributeGearData)((Object)data)).createOrReplaceAttributeValue(ModGearAttributes.DAMAGE_INCREASE, (Float)Float.valueOf(0.25f));
                ((AttributeGearData)((Object)data)).write(stack);
                break;
            }
            case SOUL_HUNTING: {
                Float data = AttributeGearData.read(stack);
                ((AttributeGearData)((Object)data)).createOrReplaceAttributeValue(ModGearAttributes.SOUL_QUANTITY, (Float)Float.valueOf(0.5f));
                ((AttributeGearData)((Object)data)).write(stack);
            }
        }
    }

    public static void addRandomPerk(ItemStack magnet, Random random) {
        Perk perk = Perk.values()[1 + random.nextInt(Perk.values().length - 1)];
        LegacyMagnetItem.setPerk(magnet, perk, ModConfigs.MAGNET_CONFIG.getPerkUpgrade(perk).getYield(random));
    }

    private boolean shouldPullInstantly(ItemStack stack) {
        return LegacyMagnetItem.getPerk(stack) == Perk.TELEPORTING;
    }

    private boolean shouldPullExperience(ItemStack stack) {
        return false;
    }

    private boolean shouldPullItems(ItemStack stack) {
        return true;
    }

    public static void onBeforeItemPickup(EntityItemPickupEvent event) {
        if (event.getPlayer().m_183503_().m_5776_()) {
            return;
        }
        ItemEntity itemBeingPickedUp = event.getItem();
        if (!PULLED_ITEMS_TO_PULLING_PLAYERS.containsKey(itemBeingPickedUp.m_142081_()) || itemBeingPickedUp.m_146910_()) {
            PULLED_ITEM_BEING_PICKED_UP_COUNT = 0;
            return;
        }
        PULLED_ITEM_BEING_PICKED_UP_COUNT = itemBeingPickedUp.m_32055_().m_41613_();
    }

    public static void onAfterItemPickup(Player player, ItemEntity itemEntity) {
        int countAfterPickup;
        if (player.m_183503_().m_5776_() || PULLED_ITEM_BEING_PICKED_UP_COUNT == 0) {
            return;
        }
        int n = countAfterPickup = itemEntity.m_6084_() ? itemEntity.m_32055_().m_41613_() : 0;
        if (countAfterPickup < PULLED_ITEM_BEING_PICKED_UP_COUNT) {
            ItemStack magnet;
            if (countAfterPickup == 0) {
                PULLED_ITEMS_TO_PULLING_PLAYERS.remove(itemEntity.m_142081_());
            }
            if (!(magnet = LegacyMagnetItem.getMagnetInCurio((LivingEntity)player)).m_41619_()) {
                LegacyMagnetItem.handleMagnetDurabilityAndManaCost(player, magnet, PULLED_ITEM_BEING_PICKED_UP_COUNT - countAfterPickup);
            }
        }
    }

    public static void onItemActuallyPickedUp(PlayerEvent.ItemPickupEvent event) {
        ItemEntity itemEntity = event.getOriginalEntity();
        Player player = event.getPlayer();
        UUID pulling = PULLED_ITEMS_TO_PULLING_PLAYERS.get(itemEntity.m_142081_());
        if (pulling == player.m_142081_()) {
            ItemStack magnet;
            PULLED_ITEMS_TO_PULLING_PLAYERS.remove(itemEntity.m_142081_());
            PULLED_ITEM_BEING_PICKED_UP_COUNT = 0;
            if (!player.f_19853_.f_46443_ && !(magnet = LegacyMagnetItem.getMagnetInCurio((LivingEntity)player)).m_41619_()) {
                LegacyMagnetItem.handleMagnetDurabilityAndManaCost(player, magnet, event.getStack().m_41613_());
            }
        }
    }

    private static void handleMagnetDurabilityAndManaCost(Player player, ItemStack magnet, int stackSize) {
        Perk perk = LegacyMagnetItem.getPerk(magnet);
        if (perk == Perk.IMMORTAL && ServerVaults.get(player.f_19853_).isEmpty()) {
            return;
        }
        float itemsForOneDurability = ModConfigs.MAGNET_CONFIG.getItemsForOneDurability();
        float amount = (float)stackSize / itemsForOneDurability;
        if (player.f_19853_.f_46441_.nextFloat() < amount) {
            int i = (int)Math.ceil(amount);
            magnet.m_41622_(i, (LivingEntity)player, breakEvent -> CuriosApi.getCuriosHelper().onBrokenCurio(new SlotContext("belt", (LivingEntity)player, 0, false, true)));
        }
        int itemsForOneMana = LegacyMagnetItem.getUsableStat(magnet, Stat.MANA_EFFICIENCY);
        float manaCostPerItem = 1.0f / ((float)itemsForOneMana * 20.0f);
    }

    public boolean m_41465_() {
        return true;
    }

    private static void addRepairTooltip(List<Component> tooltip, int usedRepairs, int totalRepairs) {
        if (totalRepairs <= 0) {
            return;
        }
        int remaining = totalRepairs - usedRepairs;
        tooltip.add((Component)new TextComponent("Repairs: ").m_7220_(LegacyMagnetItem.tooltipDots(usedRepairs, ChatFormatting.YELLOW)).m_7220_(LegacyMagnetItem.tooltipDots(remaining, ChatFormatting.GRAY)));
    }

    private static Component tooltipDots(int amount, ChatFormatting formatting) {
        return new TextComponent("\u2b22 ".repeat(Math.max(0, amount))).m_130940_(formatting);
    }

    public static enum Perk implements StringRepresentable
    {
        NONE("None"),
        CHUNKY("Chunky"),
        HOARD("Hoard"),
        IMMORTAL("Immortal"),
        REINFORCED("Reinforced"),
        SHARP("Sharp"),
        SOUL_HUNTING("SoulHunting"),
        TELEPORTING("Teleporting"),
        TREASURE("Treasure");

        private final String name;

        private Perk(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum Stat implements StringRepresentable
    {
        DURABILITY("Durability", "Durability"),
        RANGE("Range", "Range"),
        VELOCITY("Velocity", "Velocity"),
        MANA_EFFICIENCY("ManaEfficiency", "Mana Efficiency");

        private final String name;
        private final String readableName;

        private Stat(String name, String readableName) {
            this.name = name;
            this.readableName = readableName;
        }

        public String m_7912_() {
            return this.name;
        }

        public String getReadableName() {
            return this.readableName;
        }
    }

    public static final class MagnetTooltip
    implements TooltipComponent {
        public final int[] stats;
        public final int perkPower;
        @Nullable
        public final Perk perk;

        public MagnetTooltip(int range, int speed, int manaCost, Perk perk, int perkPower) {
            this.stats = new int[]{range, speed, manaCost};
            this.perk = perk;
            this.perkPower = perkPower;
        }
    }
}

