/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.DemagnetizerTileEntity;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.core.util.ThemeBlockRetriever;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.CuriosGearItem;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.gear.trinket.effects.EnderAnchorTrinket;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.util.calc.MagnetRangeHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.ServerVaults;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MagnetItem
extends Item
implements VaultGearItem,
CuriosGearItem,
ICurioItem {
    public static final String SLOT = "belt";
    public static final String BLACKLIST = "PreventMagnetMovement";
    public static final String PULLED = "MagnetPulled";
    private static final String STATE_TAG = "MagnetState";
    public static final Set<String> LEGACY_KEYS = new HashSet<String>(Arrays.asList("Perk", "PerkPower", "UsedRepairs", "Durability", "Range", "Velocity", "ManaEfficiency", "SturdinessDamage"));

    public MagnetItem(ResourceLocation id, Item.Properties properties) {
        super(properties);
        this.setRegistryName(id);
    }

    public boolean isDamageable(ItemStack stack) {
        return GearDataCache.of(stack).getState() == VaultGearState.IDENTIFIED;
    }

    public int getMaxDamage(ItemStack stack) {
        if (MagnetItem.isLegacy(stack)) {
            return 0;
        }
        return VaultGearData.read(stack).get(ModGearAttributes.DURABILITY, VaultGearAttributeTypeMerger.intSum());
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public Component m_7626_(@NotNull ItemStack stack) {
        if (MagnetItem.isLegacy(stack)) {
            return super.m_7626_(stack);
        }
        return VaultGearHelper.getDisplayName(stack, super.m_7626_(stack));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext context, UUID uuid, ItemStack stack) {
        Player player;
        if (MagnetItem.isLegacy(stack)) {
            return ImmutableMultimap.of();
        }
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_36335_().m_41519_(stack.m_41720_())) {
            return ImmutableMultimap.of();
        }
        return SLOT.equals(context.identifier()) ? VaultGearHelper.getModifiers(VaultGearData.read(stack)) : ImmutableMultimap.of();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return VaultGearHelper.shouldPlayGearReequipAnimation(oldStack, newStack, slotChanged);
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.m_41809_();
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        return Collections.emptyList();
    }

    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (MagnetItem.isLegacy(heldStack)) {
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        EquipmentSlot slot = Mob.m_147233_((ItemStack)heldStack);
        InteractionResultHolder defaultAction = this.canEquip(heldStack, slot, (Entity)player) ? super.m_7203_(world, player, hand) : InteractionResultHolder.m_19100_((Object)heldStack);
        return VaultGearHelper.rightClick(world, player, hand, (InteractionResultHolder<ItemStack>)defaultAction);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (MagnetItem.isLegacy(stack)) {
            return;
        }
        tooltip.addAll(this.createTooltip(stack, GearTooltip.itemTooltip()));
    }

    public void m_6787_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            VaultGearData data = VaultGearData.read(stack);
            data.setState(VaultGearState.UNIDENTIFIED);
            data.write(stack);
            items.add((Object)stack);
        }
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (MagnetItem.isLegacy(stack) && !MagnetItem.hasLegacyDataRemoved(stack)) {
            MagnetItem.removeLegacyData(stack);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.vaultGearTick(stack, player);
        }
    }

    @Override
    public VaultRecyclerConfig.RecyclerOutput getOutput(ItemStack input) {
        return ModConfigs.VAULT_RECYCLER.getRecyclingOutputOrDefault(input.m_41720_());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ServerPlayer player;
        Player player2;
        block5: {
            block4: {
                if (event.phase != TickEvent.Phase.START) {
                    return;
                }
                player2 = event.player;
                if (!(player2 instanceof ServerPlayer)) break block4;
                player = (ServerPlayer)player2;
                player2 = player.f_19853_;
                if (player2 instanceof ServerLevel) break block5;
            }
            return;
        }
        ServerLevel world = (ServerLevel)player2;
        MagnetItem.getMagnet((LivingEntity)event.player).ifPresent(stack -> {
            VaultGearItem gearItem;
            Item patt8767$temp = stack.m_41720_();
            if (patt8767$temp instanceof VaultGearItem && (gearItem = (VaultGearItem)patt8767$temp).isBroken((ItemStack)stack)) {
                return;
            }
            if (DemagnetizerTileEntity.hasDemagnetizerAround((Entity)event.player)) {
                return;
            }
            VaultGearData data = VaultGearData.read(stack);
            float range = MagnetRangeHelper.getRange((LivingEntity)player);
            float speed = data.get(ModGearAttributes.VELOCITY, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            List items = world.m_6443_(ItemEntity.class, player.m_142469_().m_82400_((double)range), entity -> entity.m_20280_((Entity)player) <= (double)(range * range) && !entity.m_19880_().contains(BLACKLIST));
            List orbs = world.m_6443_(ExperienceOrb.class, player.m_142469_().m_82400_((double)range), entity -> entity.m_20280_((Entity)player) <= (double)(range * range) && !entity.m_19880_().contains(BLACKLIST));
            TrinketHelper.getTrinkets((LivingEntity)player, EnderAnchorTrinket.class).forEach(enderTrinket -> {
                if (!enderTrinket.isUsable((Player)player)) {
                    return;
                }
                MagnetItem.teleportToPlayer((Player)player, items);
                MagnetItem.teleportToPlayer((Player)player, orbs);
            });
            MagnetItem.moveToPlayer((Player)player, items, speed);
            MagnetItem.moveToPlayer((Player)player, orbs, speed);
        });
    }

    public static void moveToPlayer(Player player, List<? extends Entity> entities, float speed) {
        for (Entity entity : entities) {
            ItemEntity item;
            if (entity instanceof ItemEntity && MagnetItem.allowsNoPickupDelay(item = (ItemEntity)entity, player)) {
                item.m_32061_();
            }
            Vec3 velocity = player.m_20182_().m_82546_(entity.m_20182_()).m_82541_().m_82490_((double)speed);
            entity.m_5997_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            entity.f_19864_ = true;
            entity.m_19880_().add(PULLED);
        }
    }

    public static void teleportToPlayer(Player player, List<? extends Entity> entities) {
        for (Entity entity : entities) {
            Level level;
            ItemEntity item;
            if (entity instanceof ItemEntity && MagnetItem.allowsNoPickupDelay(item = (ItemEntity)entity, player)) {
                item.m_32061_();
            }
            if ((level = player.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ENDER_ANCHOR.get()), entity.m_20182_().f_82479_, entity.m_20182_().f_82480_ + 0.25, entity.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            entity.m_6021_(player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_);
            entity.f_19864_ = true;
            entity.m_19880_().add(PULLED);
        }
    }

    private static boolean allowsNoPickupDelay(ItemEntity itemEntity, Player player) {
        if (itemEntity.m_32057_() == null || itemEntity.m_32057_().equals(player.m_142081_())) {
            return true;
        }
        for (Player otherPlayer : player.m_183503_().m_6907_()) {
            if (otherPlayer.m_142081_().equals(player.m_142081_()) || !otherPlayer.m_142469_().m_82400_(1.0).m_82381_(itemEntity.m_142469_())) continue;
            return false;
        }
        return true;
    }

    public static void onPlayerPickup(Player player, ItemEntity item) {
        if (!item.m_19880_().contains(PULLED)) {
            return;
        }
        MagnetItem.getMagnet((LivingEntity)player).ifPresent(stack -> {
            ResourceLocation theme;
            ServerPlayer sPlayer;
            ServerLevel world;
            Optional<Vault> vault;
            if (player instanceof ServerPlayer && (vault = ServerVaults.get((Level)(world = (sPlayer = (ServerPlayer)player).m_183503_()))).isPresent() && MagnetItem.getPickupState(stack) == PickupState.VOID && ThemeBlockRetriever.shouldVoidItem(sPlayer, item, world, theme = vault.get().get(Vault.WORLD).get(WorldManager.THEME))) {
                return;
            }
            if (!item.m_32055_().m_150930_((Item)ModItems.SOUL_SHARD)) {
                stack.m_41622_(1, (LivingEntity)player, entity -> {
                    if (!entity.m_20067_()) {
                        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12018_, entity.m_5720_(), 0.8f, 0.8f + entity.f_19853_.f_46441_.nextFloat() * 0.4f);
                    }
                    MagnetItem.spawnItemParticles((Entity)entity, stack, 5);
                });
            }
        });
    }

    private static void spawnItemParticles(Entity entity, ItemStack stack, int count) {
        Random random = new Random();
        for (int i = 0; i < count; ++i) {
            Vec3 vec3 = new Vec3(((double)random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
            vec3 = vec3.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            double d0 = (double)(-random.nextFloat()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)random.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82520_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
            Level level = entity.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                world.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.0);
                continue;
            }
            entity.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
        }
    }

    public static void cycleState(Player player) {
        MagnetItem.getMagnet((LivingEntity)player, PickupState.values()).ifPresent(stack -> {
            PickupState state = MagnetItem.getPickupState(stack);
            int nextOrdinal = (state.ordinal() + 1) % PickupState.values().length;
            PickupState newState = PickupState.values()[nextOrdinal];
            MagnetItem.setPickupState(stack, newState);
            player.m_5661_((Component)new TranslatableComponent("message.the_vault.magnet_toggled", new Object[]{new TranslatableComponent(newState.translateString()).m_130940_(newState.colour())}), true);
        });
    }

    public static PickupState getPickupState(ItemStack magnet) {
        if (!magnet.m_41782_() || !magnet.m_41783_().m_128441_(STATE_TAG)) {
            return PickupState.PICKUP_ONLY;
        }
        String stateStr = magnet.m_41783_().m_128461_(STATE_TAG);
        try {
            return PickupState.valueOf(stateStr);
        }
        catch (IllegalArgumentException e) {
            VaultMod.LOGGER.error("Magnet has invalid state: {}", (Object)stateStr);
            return PickupState.PICKUP_ONLY;
        }
    }

    public static void setPickupState(ItemStack magnet, PickupState state) {
        magnet.m_41784_().m_128359_(STATE_TAG, state.name());
    }

    public static boolean isSwitchedOn(ItemStack magnet) {
        return MagnetItem.getPickupState(magnet) != PickupState.OFF;
    }

    public static boolean isVoidingItems(ItemStack magnet) {
        return MagnetItem.getPickupState(magnet) == PickupState.VOID;
    }

    public static Optional<ItemStack> getMagnet(LivingEntity entity) {
        return MagnetItem.getMagnet(entity, PickupState.PICKUP_ONLY, PickupState.VOID);
    }

    public static Optional<ItemStack> getMagnet(LivingEntity entity, PickupState ... filter) {
        if (entity.m_5833_()) {
            return Optional.empty();
        }
        return CuriosApi.getCuriosHelper().getCuriosHandler(entity).map(handler -> handler).flatMap(handler -> handler.getStacksHandler(SLOT)).map(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStacks().getStackInSlot(i);
                if (stack.m_41720_() != ModItems.MAGNET || MagnetItem.isLegacy(stack) || !Arrays.stream(filter).anyMatch(state -> state == MagnetItem.getPickupState(stack))) continue;
                return stack;
            }
            return null;
        }).map(stack -> {
            Player player;
            VaultGearData data = VaultGearData.read(stack);
            if (entity instanceof Player && SidedHelper.getVaultLevel(player = (Player)entity) < data.getItemLevel()) {
                return null;
            }
            return stack;
        });
    }

    public static boolean isLegacy(ItemStack stack) {
        return MagnetItem.hasLegacyDataRemoved(stack) || MagnetItem.hasLegacyData(stack);
    }

    public static boolean hasLegacyData(ItemStack stack) {
        Set keys = stack.m_41784_().m_128431_();
        for (String key : keys) {
            if (!LEGACY_KEYS.contains(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLegacyDataRemoved(ItemStack stack) {
        return stack.m_41784_().m_128471_("Legacy");
    }

    public static void removeLegacyData(ItemStack stack) {
        stack.m_41784_().m_128473_("vaultGearData");
        stack.m_41784_().m_128379_("Legacy", true);
    }

    @Override
    @NotNull
    public VaultGearClassification getClassification(ItemStack stack) {
        return VaultGearClassification.MAGNET;
    }

    @Override
    @Nonnull
    public VaultGearType getGearType(ItemStack stack) {
        return VaultGearType.MAGNET;
    }

    @Override
    @Nullable
    public ResourceLocation getRandomModel(ItemStack stack, Random random, @javax.annotation.Nullable Player player, @javax.annotation.Nullable DiscoveredModelsData discoveredModelsData) {
        VaultGearData gearData = VaultGearData.read(stack);
        return ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRandomMagnetRoll(stack, gearData, random, player, discoveredModelsData);
    }

    @Override
    public boolean isIntendedSlot(ItemStack stack, String slot) {
        return SLOT.equals(slot);
    }

    public static enum PickupState {
        VOID(ChatFormatting.DARK_PURPLE, "message.the_vault.magnet_state.void"),
        PICKUP_ONLY(ChatFormatting.GREEN, "message.the_vault.magnet_state.pickup_only"),
        OFF(ChatFormatting.RED, "message.the_vault.magnet_state.off");

        private final ChatFormatting colour;
        private final String translate;

        private PickupState(ChatFormatting colour, String translate) {
            this.colour = colour;
            this.translate = translate;
        }

        public ChatFormatting colour() {
            return this.colour;
        }

        public String translateString() {
            return this.translate;
        }
    }
}

