/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.config.MaterialBoxConfig;
import iskallia.vault.config.entry.vending.ProductEntry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MaterialBoxItem
extends Item {
    public MaterialBoxItem(ResourceLocation id) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(16));
        this.setRegistryName(id);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        MaterialBoxConfig config = ModConfigs.MATERIAL_BOX;
        ServerPlayer serverPlayer = (ServerPlayer)player;
        int vaultLevel = this.getVaultLevel(serverPlayer);
        WeightedList<ProductEntry> pool = config.getPool(vaultLevel);
        if (pool.isEmpty()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ProductEntry selectedEntry = pool.getRandom(new Random());
        if (selectedEntry == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ItemStack reward = selectedEntry.generateItemStack();
        if (!player.m_150109_().m_36054_(reward)) {
            player.m_36176_(reward, false);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
        stack.m_41774_(1);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private int getVaultLevel(ServerPlayer sPlayer) {
        return PlayerVaultStatsData.get(sPlayer.m_183503_()).getVaultStats((Player)sPlayer).getVaultLevel();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)new TextComponent("Right-click to open and receive materials").m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }
}

