/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.util.StringUtils;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MentorsBrewItem
extends Item {
    public MentorsBrewItem(Item.Properties properties) {
        super(properties);
        this.setRegistryName(VaultMod.id("mentors_brew"));
    }

    public int m_8105_(ItemStack pStack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    private static void createItemData(ItemStack stack, ServerLevel world, ServerPlayer player) {
        PlayerVaultStatsData data = PlayerVaultStatsData.get(world);
        int exp = data.getVaultStats(player.m_142081_()).getExp();
        int vaultLevel = data.getVaultStats(player.m_142081_()).getVaultLevel();
        MentorsBrewItem.setExp(stack, exp);
        MentorsBrewItem.setLevel(stack, vaultLevel);
        MentorsBrewItem.setOwner(stack, (Player)player);
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        super.m_7836_(pStack, pLevel, pPlayer);
        if (pLevel instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)pLevel;
            MentorsBrewItem.createItemData(pStack, level, (ServerPlayer)pPlayer);
        }
    }

    private static void isMissingData(ItemStack stack, ServerLevel world, ServerPlayer player) {
        if (MentorsBrewItem.getExp(stack) == -1 || MentorsBrewItem.getLevel(stack) == -1 || MentorsBrewItem.getOwner(stack) == null) {
            MentorsBrewItem.createItemData(stack, world, player);
        }
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pLevel instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)pLevel;
                CompoundTag tag = pStack.m_41784_();
                if (!(tag.m_128441_("VaultExp") && tag.m_128441_("VaultLevel") && tag.m_128403_("Owner"))) {
                    MentorsBrewItem.createItemData(pStack, level, (ServerPlayer)player);
                }
            }
        }
    }

    public static void setExp(ItemStack stack, int exp) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("VaultExp", exp);
    }

    public static int getExp(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("VaultExp") ? tag.m_128451_("VaultExp") : -1;
    }

    public static void setOwner(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128362_("Owner", player.m_142081_());
    }

    public static UUID getOwner(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128403_("Owner") ? stack.m_41784_().m_128342_("Owner") : null;
    }

    public static void setLevel(ItemStack stack, int level) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("VaultLevel", Math.min(level, 100));
    }

    public static int getLevel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("VaultLevel") ? tag.m_128451_("VaultLevel") : -1;
    }

    @NotNull
    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        Player player;
        Player player2 = player = pEntityLiving instanceof Player ? (Player)pEntityLiving : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, pStack);
        }
        if (!pLevel.f_46443_) {
            int exp = MentorsBrewItem.getExp(pStack);
            int level = MentorsBrewItem.getLevel(pStack);
            if (exp != -1 && level != -1) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerVaultStatsData data = PlayerVaultStatsData.get(serverPlayer.m_183503_());
                PlayerVaultStats vaultPlayerStats = data.getVaultStats(serverPlayer.m_142081_());
                if (vaultPlayerStats.getVaultLevel() >= level) {
                    return pStack;
                }
                int currentLevelExp = ModConfigs.LEVELS_META.getTotalExpAtLevel(vaultPlayerStats.getVaultLevel()) + vaultPlayerStats.getExp();
                int totalExp = ModConfigs.LEVELS_META.getTotalExpAtLevel(level) + exp;
                int difference = totalExp - currentLevelExp;
                if (difference > 0) {
                    vaultPlayerStats.addVaultExp(serverPlayer.m_20194_(), difference);
                }
            }
        }
        if (player != null) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                pStack.m_41774_(1);
            }
        }
        if ((player == null || !player.m_150110_().f_35937_) && pStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        pLevel.m_142346_((Entity)pEntityLiving, GameEvent.f_157805_, pEntityLiving.m_146901_());
        return pStack;
    }

    public SoundEvent m_6023_() {
        return SoundEvents.f_11911_;
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_11911_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (!pLevel.f_46443_) {
            if (!((ServerLevel)pLevel).m_142572_().m_129900_().m_46207_(ModGameRules.ALLOW_MENTOR_BREW)) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            ServerLevel serverLevel = (ServerLevel)pLevel;
            PlayerVaultStatsData data = PlayerVaultStatsData.get(serverLevel);
            if (data.getVaultStats(pPlayer.m_142081_()).getVaultUncappedLevel() > 100) {
                pPlayer.m_5661_((Component)new TextComponent("You cannot use Mentors Brew at level 100").m_130940_(ChatFormatting.RED), true);
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            if (MentorsBrewItem.getLevel(itemStack) > data.getVaultStats(pPlayer.m_142081_()).getVaultLevel()) {
                return ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level level, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, level, pTooltipComponents, pIsAdvanced);
        if (MentorsBrewItem.getOwner(pStack) != null) {
            UUID ownerUUID = MentorsBrewItem.getOwner(pStack);
            assert (ownerUUID != null);
            String playerName = "";
            if (level != null) {
                Player player = level.m_46003_(ownerUUID);
                if (player != null) {
                    playerName = player.m_7755_().getString();
                }
                pTooltipComponents.add((Component)new TextComponent("Owner: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(playerName).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#FFE637")))));
            }
        }
        int vaultExp = MentorsBrewItem.getExp(pStack);
        int vaultLevel = MentorsBrewItem.getLevel(pStack);
        if (vaultExp != -1 && vaultLevel != -1) {
            int clientLevel = VaultBarOverlay.vaultLevel;
            if (clientLevel >= 100) {
                pTooltipComponents.add((Component)new TextComponent("Mentor Brews cannot be used past level 100").m_130940_(ChatFormatting.RED));
                return;
            }
            Component differenceComponent = TextComponent.f_131282_;
            int levelDifference = vaultLevel - clientLevel;
            if (vaultLevel >= clientLevel && Screen.m_96638_()) {
                differenceComponent = new TextComponent(" (+").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(levelDifference + StringUtils.pluralise(" level", levelDifference)).m_130940_(ChatFormatting.GRAY));
                if (Screen.m_96639_()) {
                    differenceComponent = differenceComponent.m_6881_().m_7220_((Component)new TextComponent(" and " + vaultExp + " exp").m_130940_(ChatFormatting.GRAY));
                }
                differenceComponent = differenceComponent.m_6881_().m_7220_((Component)new TextComponent(")").m_130940_(ChatFormatting.GRAY));
            }
            pTooltipComponents.add((Component)new TextComponent("Level: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(vaultLevel)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#FFE637")))).m_7220_(differenceComponent));
            if (levelDifference <= 0 || clientLevel >= vaultLevel) {
                pTooltipComponents.add(TextComponent.f_131282_);
                pTooltipComponents.add((Component)new TextComponent("Cannot be used to gain more exp").m_130940_(ChatFormatting.RED));
            }
        }
    }
}

