/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.block.entity.ModifierDiscoveryTileEntity;
import iskallia.vault.container.modifier.DiscoverableModifier;
import iskallia.vault.container.provider.ModifierScrollProvider;
import iskallia.vault.init.ModItems;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class ModifierScrollItem
extends Item {
    public ModifierScrollItem(ResourceLocation id) {
        super(new Item.Properties().m_41487_(1).m_41491_(ModItems.VAULT_MOD_GROUP));
        this.setRegistryName(id);
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> items) {
        if (this.m_41389_(category)) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag advanced) {
        String openName = ModifierScrollItem.getPlayerName(stack);
        if (openName != null) {
            tooltip.add((Component)new TextComponent("Opened by " + openName).m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack inHand = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            int slot = hand == InteractionHand.MAIN_HAND ? sPlayer.m_150109_().f_35977_ : 40;
            this.openScroll(sPlayer, slot, inHand);
            return InteractionResultHolder.m_19090_((Object)inHand);
        }
        return InteractionResultHolder.m_19098_((Object)inHand);
    }

    private void openScroll(ServerPlayer sPlayer, int slot, ItemStack inHand) {
        UUID playerUid;
        UUID scrollUuid = ModifierScrollItem.getUuid(inHand);
        if (scrollUuid == null) {
            this.generateScrollContents(sPlayer, inHand);
            scrollUuid = ModifierScrollItem.getUuid(inHand);
        }
        if ((playerUid = ModifierScrollItem.getPlayerUuid(inHand)) != null && !sPlayer.m_142081_().equals(playerUid)) {
            sPlayer.m_6352_((Component)new TextComponent("Scroll was already used by " + ModifierScrollItem.getPlayerName(inHand)).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return;
        }
        ModifierScrollProvider provider = new ModifierScrollProvider(sPlayer, slot, scrollUuid, inHand);
        NetworkHooks.openGui((ServerPlayer)sPlayer, (MenuProvider)provider, provider.extraDataWriter());
    }

    private void generateScrollContents(ServerPlayer sPlayer, ItemStack stack) {
        ModifierScrollItem.setOpenInformation(stack, (Player)sPlayer);
        ModifierScrollItem.setDiscoverableModifiers(stack, ModifierDiscoveryTileEntity.generateRandomDiscoverableModifiers(sPlayer, 3));
    }

    public static List<DiscoverableModifier> getDiscoverableModifiers(ItemStack stack) {
        return stack.m_41784_().m_128437_("DiscoverableModifiers", 10).stream().map(tag -> (CompoundTag)tag).map(DiscoverableModifier::deserialize).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static void setDiscoverableModifiers(ItemStack stack, List<DiscoverableModifier> discoverableModifiers) {
        stack.m_41784_().m_128365_("DiscoverableModifiers", (Tag)discoverableModifiers.stream().map(modifier -> {
            CompoundTag tag = new CompoundTag();
            modifier.serialize(tag);
            return tag;
        }).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
    }

    public static void setOpenInformation(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128362_("Uuid", UUID.randomUUID());
        tag.m_128362_("PlayerUuid", player.m_142081_());
        tag.m_128359_("PlayerName", player.m_7755_().getString());
    }

    public static void generateUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128362_("Uuid", UUID.randomUUID());
    }

    @Nullable
    public static UUID getUuid(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41784_().m_128342_("Uuid") : null;
    }

    @Nullable
    public static UUID getPlayerUuid(ItemStack stack) {
        return stack.m_41782_() ? (stack.m_41784_().m_128441_("PlayerUuid") ? stack.m_41784_().m_128342_("PlayerUuid") : null) : null;
    }

    @Nullable
    public static String getPlayerName(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41784_().m_128461_("PlayerName") : null;
    }
}

