/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.modifiers.CrystalModifiers;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoulFlameItem
extends BasicItem {
    public SoulFlameItem(ResourceLocation id) {
        super(id);
    }

    public static ItemStack create(int stacks, String playerName, UUID playerUuid, CrystalModifiers modifiers) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SOUL_FLAME);
        SoulFlameItem.setStacks(stack, stacks);
        SoulFlameItem.setOwnerName(stack, playerName);
        SoulFlameItem.setOwnerUuid(stack, playerUuid);
        SoulFlameItem.setModifiers(stack, modifiers);
        return stack;
    }

    public void m_6883_(@Nonnull ItemStack itemStack, @Nonnull Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (SoulFlameItem.getOwnerUUID(itemStack).isEmpty()) {
            SoulFlameItem.setOwner(itemStack, player);
        }
        super.m_6883_(itemStack, world, entity, itemSlot, isSelected);
    }

    public static int getStacks(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("Stacks", 3)) {
            return nbt.m_128451_("Stacks");
        }
        return 0;
    }

    public static Optional<UUID> getOwnerUUID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("OwnerUUID", 8)) {
            return Optional.of(UUID.fromString(nbt.m_128461_("OwnerUUID")));
        }
        return Optional.empty();
    }

    public static Optional<String> getOwnerName(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("OwnerName", 8)) {
            return Optional.of(nbt.m_128461_("OwnerName"));
        }
        return Optional.empty();
    }

    public static Optional<CrystalModifiers> getModifiers(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("Modifiers", 10)) {
            return CrystalData.MODIFIERS.readNbt((Tag)nbt.m_128469_("Modifiers"));
        }
        return Optional.empty();
    }

    public static void setStacks(ItemStack stack, int stackCount) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_("Stacks", stackCount);
    }

    public static void setOwnerUuid(ItemStack stack, UUID uuid) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("OwnerUUID", uuid.toString());
    }

    public static void setOwnerName(ItemStack stack, String name) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("OwnerName", name);
    }

    public static void setOwner(ItemStack stack, ServerPlayer player) {
        SoulFlameItem.setOwnerUuid(stack, player.m_142081_());
        SoulFlameItem.setOwnerName(stack, player.m_36316_().getName());
    }

    private static void setModifiers(ItemStack stack, CrystalModifiers modifiers) {
        CompoundTag nbt = stack.m_41784_();
        CrystalData.MODIFIERS.writeNbt(modifiers).ifPresent(tag -> nbt.m_128365_("Modifiers", tag));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        SoulFlameItem.getOwnerUUID(stack).ifPresentOrElse(uuid -> {
            String name = SoulFlameItem.getOwnerName(stack).orElse("Unknown");
            tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent("Player: ")).m_7220_((Component)new TextComponent(name).m_130940_(ChatFormatting.YELLOW)));
        }, () -> tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent("Player: ")).m_7220_((Component)new TextComponent("???").m_130940_(ChatFormatting.GRAY))));
        tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent("Stacks: ")).m_7220_((Component)new TextComponent("" + SoulFlameItem.getStacks(stack)).m_130940_(ChatFormatting.AQUA)));
        SoulFlameItem.getModifiers(stack).ifPresent(modifiers -> modifiers.addText(tooltip, tooltip.size(), flag, ClientScheduler.INSTANCE.getTick()));
    }
}

