/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.client.ClientTalentData;
import iskallia.vault.client.render.TalentScrollItemRenderer;
import iskallia.vault.config.TalentsGUIConfig;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.core.DataInitializationItem;
import iskallia.vault.item.render.core.IManualModelLoading;
import iskallia.vault.skill.base.GroupedSkill;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.Nullable;

public class TalentScrollItem
extends Item
implements DataInitializationItem,
IManualModelLoading {
    private static final String TALENT = "Talent";

    public TalentScrollItem(ResourceLocation id) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41497_(Rarity.EPIC));
        this.setRegistryName(id);
    }

    public static Optional<Skill> getTalentFromStack(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(TALENT)) {
            String abilityId = stack.m_41783_().m_128461_(TALENT);
            return ModConfigs.TALENTS.getTalentById(abilityId);
        }
        return Optional.empty();
    }

    @Override
    public void initialize(ItemStack stack, RandomSource rand) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(TALENT)) {
            return;
        }
        String id = ModConfigs.SKILL_SCROLLS.getRandomTalent(rand);
        if (id != null) {
            stack.m_41784_().m_128359_(TALENT, id);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_(TALENT)) {
                String talentId = tag.m_128461_(TALENT);
                TalentTree talentTree = PlayerTalentsData.get(serverPlayer.m_183503_()).getTalents((Player)serverPlayer);
                talentTree.getForId(talentId).ifPresent(skill -> {
                    if (skill instanceof LearnableSkill) {
                        SkillContext context;
                        LearnableSkill learnable = (LearnableSkill)skill;
                        Skill patt3264$temp = skill.getParent();
                        if (patt3264$temp instanceof GroupedSkill) {
                            GroupedSkill grouped = (GroupedSkill)patt3264$temp;
                            grouped.select(skill.getId());
                            skill = grouped;
                            learnable = (LearnableSkill)skill;
                        }
                        if (learnable.canLearn(context = SkillContext.of(serverPlayer)) && !ModConfigs.SKILL_GATES.getGates().isLocked(talentId, talentTree)) {
                            level.m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_12275_, serverPlayer.m_5720_(), 0.6f, 1.0f);
                            learnable.learn(context);
                            PlayerVaultStatsData.get(serverPlayer.m_183503_()).getVaultStats((Player)serverPlayer).setSkillPoints(context.getLearnPoints());
                            talentTree.sync(context);
                            stack.m_41774_(1);
                        }
                    }
                });
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (pStack.m_41782_() && pStack.m_41783_().m_128441_(TALENT)) {
            String talentId = pStack.m_41783_().m_128461_(TALENT);
            Optional<Skill> abilityTree = ModConfigs.TALENTS.getTalentById(talentId);
            abilityTree.ifPresent(skill -> {
                Skill talent;
                pTooltipComponents.add(TextComponent.f_131282_);
                pTooltipComponents.add((Component)new TextComponent("Talent: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(skill.getName()).m_130940_(ChatFormatting.WHITE)));
                pTooltipComponents.add((Component)new TextComponent("Consume to learn or level up this talent.").m_130940_(ChatFormatting.YELLOW));
                pTooltipComponents.add(TextComponent.f_131282_);
                SkillContext context = SkillContext.ofClient();
                TalentTree learnt = ClientTalentData.getTree();
                if (learnt.getForId(talentId).isPresent() && (talent = learnt.getForId(talentId).get()) instanceof TieredSkill) {
                    TieredSkill a = (TieredSkill)talent;
                    if (a.canLearn(context) && !ModConfigs.SKILL_GATES.getGates().isLocked(talentId, learnt)) {
                        pTooltipComponents.add((Component)new TextComponent("You can learn this talent!").m_130940_(ChatFormatting.GREEN));
                    } else {
                        pTooltipComponents.add((Component)new TextComponent("You cannot learn this talent.").m_130940_(ChatFormatting.RED));
                    }
                }
            });
        }
    }

    public Component m_7626_(ItemStack pStack) {
        return (Component)TalentScrollItem.getTalentFromStack(pStack).map(skill -> {
            String abilityName = skill.getName();
            return new TextComponent(abilityName).m_130940_(ChatFormatting.GOLD);
        }).orElse(super.m_7626_(pStack).m_6881_());
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return TalentScrollItemRenderer.INSTANCE;
            }
        });
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        consumer.accept(new ModelResourceLocation("the_vault:talent_scroll_back#inventory"));
        TalentsGUIConfig config = (TalentsGUIConfig)new TalentsGUIConfig().readConfig();
        ModConfigs.CONFIGS.remove(config);
        config.getStyles().values().stream().map(style -> style.icon).forEach(icon -> {
            if (icon == null) {
                return;
            }
            String[] split = icon.toString().split("/");
            String last = split[split.length - 1];
            consumer.accept(new ModelResourceLocation("the_vault:skills/" + last + "#inventory"));
        });
    }
}

