/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.config.PlayerTitlesConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.BasicItem;
import iskallia.vault.world.data.PlayerTitlesData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TitleScrollItem
extends BasicItem {
    public TitleScrollItem(ResourceLocation id) {
        super(id);
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (!ModConfigs.isInitialized()) {
            return;
        }
        if (tab != CreativeModeTab.f_40754_) {
            return;
        }
        for (PlayerTitlesConfig.Affix affix : PlayerTitlesConfig.Affix.values()) {
            Map<String, PlayerTitlesConfig.Title> titles = ModConfigs.PLAYER_TITLES.getAll(affix);
            for (String titleId : titles.keySet()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                TitleScrollItem.setTitle(stack, titleId, affix);
                items.add((Object)stack);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && player.m_142081_().equals(TitleScrollItem.getOwnerUUID(stack).orElse(null))) {
            String titleId = TitleScrollItem.getTitleId(stack).orElse(null);
            PlayerTitlesConfig.Affix affix = TitleScrollItem.getAffix(stack).orElse(null);
            if (titleId != null && affix != null) {
                PlayerTitlesData.setCustomName(player, titleId, affix);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).refreshTabListName();
                }
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    public void m_6883_(@Nonnull ItemStack itemStack, @Nonnull Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (TitleScrollItem.getOwnerUUID(itemStack).isEmpty()) {
            TitleScrollItem.setOwner(itemStack, player);
        }
        super.m_6883_(itemStack, world, entity, itemSlot, isSelected);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        TitleScrollItem.getOwnerUUID(stack).ifPresentOrElse(uuid -> {
            String name = TitleScrollItem.getOwnerName(stack).orElse("Unknown");
            tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent("Player: ")).m_7220_((Component)new TextComponent(name).m_130940_(ChatFormatting.YELLOW)));
        }, () -> tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent("Player: ")).m_7220_((Component)new TextComponent("???").m_130940_(ChatFormatting.GRAY))));
        PlayerTitlesData.Entry entry = new PlayerTitlesData.Entry();
        PlayerTitlesConfig.Affix affix = TitleScrollItem.getAffix(stack).orElse(PlayerTitlesConfig.Affix.PREFIX);
        if (affix == PlayerTitlesConfig.Affix.PREFIX) {
            entry.setPrefix(TitleScrollItem.getTitleId(stack).orElse(null));
        } else if (affix == PlayerTitlesConfig.Affix.SUFFIX) {
            entry.setSuffix(TitleScrollItem.getTitleId(stack).orElse(null));
        }
        entry.getCustomName((Component)new TextComponent("<Player>"), PlayerTitlesData.Type.TAB_LIST).ifPresent(display -> tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent("Preview: ")).m_7220_((Component)display)));
    }

    public static Optional<CompoundTag> get(ItemStack stack) {
        return Optional.ofNullable(stack.m_41783_());
    }

    public static Optional<UUID> getOwnerUUID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("OwnerUUID", 8)) {
            return Optional.of(UUID.fromString(nbt.m_128461_("OwnerUUID")));
        }
        return Optional.empty();
    }

    public static Optional<String> getOwnerName(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("OwnerName", 8)) {
            return Optional.of(nbt.m_128461_("OwnerName"));
        }
        return Optional.empty();
    }

    public static Optional<String> getTitleId(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("TitleId", 8)) {
            return Optional.of(nbt.m_128461_("TitleId"));
        }
        return Optional.empty();
    }

    public static Optional<PlayerTitlesConfig.Affix> getAffix(ItemStack stack) {
        return TitleScrollItem.get(stack).map(tag -> Enum.valueOf(PlayerTitlesConfig.Affix.class, tag.m_128461_("Affix")));
    }

    public static void setOwnerUuid(ItemStack stack, UUID uuid) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("OwnerUUID", uuid.toString());
    }

    public static void setOwnerName(ItemStack stack, String name) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("OwnerName", name);
    }

    public static void setOwner(ItemStack stack, ServerPlayer player) {
        TitleScrollItem.setOwnerUuid(stack, player.m_142081_());
        TitleScrollItem.setOwnerName(stack, player.m_36316_().getName());
    }

    public static void setTitleId(ItemStack stack, String titleId) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("TitleId", titleId);
    }

    public static void setAffix(ItemStack stack, PlayerTitlesConfig.Affix affix) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("Affix", affix.name());
    }

    public static void setTitle(ItemStack stack, String titleId, PlayerTitlesConfig.Affix affix) {
        TitleScrollItem.setTitleId(stack, titleId);
        TitleScrollItem.setAffix(stack, affix);
    }
}

