/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.config.VaultModifiersConfig;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.VaultModifierItemUseEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.core.DataInitializationItem;
import iskallia.vault.item.render.core.IManualModelLoading;
import iskallia.vault.item.render.core.SpecialItemRenderer;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaultModifierItem
extends Item
implements DataInitializationItem,
IManualModelLoading {
    private static final String KEY = "Modifier";

    public VaultModifierItem(ResourceLocation id) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41497_(Rarity.EPIC));
        this.setRegistryName(id);
    }

    public static Optional<VaultModifier<?>> getModifierFromStack(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(KEY)) {
            ResourceLocation modifierId = ResourceLocation.m_135820_((String)stack.m_41783_().m_128461_(KEY));
            return VaultModifierRegistry.getOpt(modifierId);
        }
        return Optional.empty();
    }

    @Override
    public void initialize(ItemStack stack, RandomSource rand) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(KEY)) {
            return;
        }
        ResourceLocation id = ModConfigs.SKILL_SCROLLS.getRandomModifier(rand);
        if (id != null) {
            stack.m_41784_().m_128359_(KEY, id.toString());
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            VaultModifierItem.getModifierFromStack(stack).ifPresent(modifier -> VaultUtils.getVault(level).ifPresent(vault -> {
                VaultModifierItemUseEvent.Data pre = CommonEvents.VAULT_MODIFIER_ITEM_USE.invoke(serverPlayer, (Vault)vault, (VaultModifier<?>)modifier, VaultModifierItemUseEvent.Phase.PRE);
                if (pre.isCancelled()) {
                    return;
                }
                vault.get(Vault.MODIFIERS).addModifier(pre.getModifier(), 1, true, JavaRandom.ofNanoTime());
                MutableComponent text = new TextComponent("").m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_(modifier.getChatDisplayNameComponent(1)).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
                for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                    listener.getPlayer().ifPresent(arg_0 -> VaultModifierItem.lambda$use$0(listener, level, (Component)text, arg_0));
                }
                stack.m_41774_(1);
                CommonEvents.VAULT_MODIFIER_ITEM_USE.invoke(serverPlayer, (Vault)vault, pre.getModifier(), VaultModifierItemUseEvent.Phase.POST);
            }));
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        VaultModifierItem.getModifierFromStack(pStack).ifPresent(modifier -> {
            String descriptionTxt;
            pTooltipComponents.add(TextComponent.f_131282_);
            pTooltipComponents.add((Component)new TextComponent("Modifier: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(modifier.getDisplayName()).m_130948_(Style.f_131099_.m_131148_(modifier.getDisplayTextColor()))));
            if (Screen.m_96638_() && !(descriptionTxt = modifier.getDisplayDescriptionFormatted(1)).isEmpty()) {
                MutableComponent description = new TextComponent("  " + descriptionTxt).m_130940_(ChatFormatting.DARK_GRAY);
                pTooltipComponents.add((Component)description);
            }
            pTooltipComponents.add((Component)new TextComponent("Consume to add this modifier to your vault.").m_130940_(ChatFormatting.YELLOW));
        });
    }

    public Component m_7626_(ItemStack pStack) {
        return (Component)VaultModifierItem.getModifierFromStack(pStack).map(modifier -> new TextComponent(modifier.getDisplayName()).m_130948_(Style.f_131099_.m_131148_(modifier.getDisplayTextColor()))).orElse(super.m_7626_(pStack).m_6881_());
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return ItemRenderer.INSTANCE;
            }
        });
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        VaultModifiersConfig config = (VaultModifiersConfig)new VaultModifiersConfig().readConfig();
        ModConfigs.CONFIGS.remove(config);
        for (VaultModifier<?> modifier : VaultModifierRegistry.getAll().toList()) {
            modifier.getIcon().ifPresent(id -> {
                String[] parts = modifier.getIcon().get().m_135815_().split("/");
                String last = parts[parts.length - 1];
                consumer.accept(new ModelResourceLocation("the_vault:modifiers/" + last + "#inventory"));
            });
        }
    }

    private static /* synthetic */ void lambda$use$0(Listener listener, Level level, Component text, ServerPlayer other) {
        if (!(listener instanceof Runner)) {
            return;
        }
        level.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
        other.m_5661_(text, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemRenderer
    extends SpecialItemRenderer {
        public static final ItemRenderer INSTANCE = new ItemRenderer();

        public void m_108829_(@NotNull ItemStack stack, @NotNull ItemTransforms.TransformType transformType, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int light, int overlay) {
            VaultModifierItem.getModifierFromStack(stack).flatMap(VaultModifier::getIcon).ifPresent(id -> {
                String[] parts = id.m_135815_().split("/");
                String last = parts[parts.length - 1];
                this.renderModel(new ModelResourceLocation("the_vault:modifiers/" + last + "#inventory"), 0xFFFFFF, stack, transformType, poseStack, buffer, light, overlay, null);
            });
        }
    }
}

