/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.bottle;

import iskallia.vault.config.AlchemyTableConfig;
import iskallia.vault.init.ModConfigs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;

public abstract class BottleEffect {
    private final String effectId;

    protected BottleEffect(String effectId) {
        this.effectId = effectId;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", this.getType());
        tag.m_128359_("id", this.effectId);
        this.serializeData(tag);
        return tag;
    }

    public String getEffectId() {
        return this.effectId;
    }

    public int getColor() {
        AlchemyTableConfig.CraftableEffectConfig effectConfig = ModConfigs.VAULT_ALCHEMY_TABLE.getConfig(this.effectId);
        if (effectConfig == null) {
            return -1;
        }
        return effectConfig.getColor() == null ? -1 : effectConfig.getColor().m_131265_();
    }

    public Component getTooltip() {
        AlchemyTableConfig.CraftableEffectConfig effectConfig = ModConfigs.VAULT_ALCHEMY_TABLE.getConfig(this.effectId);
        if (effectConfig == null) {
            return TextComponent.f_131282_;
        }
        return new TextComponent(this.getTooltipText(effectConfig.getTooltip())).m_130948_(Style.f_131099_.m_131148_(effectConfig.getColor()));
    }

    protected abstract String getType();

    protected abstract void trigger(ServerPlayer var1);

    protected abstract CompoundTag serializeData(CompoundTag var1);

    protected abstract String getTooltipText(String var1);
}

