/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.bottle;

import com.google.common.base.Functions;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.bottle.BottleEffect;
import iskallia.vault.item.bottle.BottleEffectManager;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.talent.type.PrudentTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.InventorySnapshotData;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.ServerVaults;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BottleItem
extends Item {
    public static final String TYPE = "type";
    public static final String RECHARGE = "recharge";
    public static final String VAULT = "vault";
    public static final String PROGRESS = "progress";
    public static final String CHARGES = "charges";
    public static final String EFFECT = "effect";
    private static final float CHARGE_NOTIFICATION_DURATION = 20.0f;
    private static final float PROGRESS_NOTIFICATION_DURATION = 40.0f;
    private static ItemStack notifiableBottleStack = ItemStack.f_41583_;
    private static long chargeNotificationTime = -1L;
    private static long progressNotificationTime = -1L;
    private static int progressPoints = 0;

    public BottleItem(ResourceLocation id, Item.Properties properties) {
        super(properties);
        this.setRegistryName(id);
    }

    public static int getEffectColor(ItemStack stack) {
        return BottleItem.getEffect(stack).map(effect -> effect.getColor()).orElse(16150747);
    }

    public static void onChestOpen(ItemStack stack, ServerPlayer player, BlockState state) {
        Type type = BottleItem.getType(stack).orElse(null);
        Recharge recharge = BottleItem.getRecharge(stack).orElse(null);
        if (type == null || ModConfigs.POTION.getPotion(type).getCharges() <= BottleItem.getCharges(stack) || recharge != Recharge.CHESTS) {
            return;
        }
        if (!(state.m_60734_() instanceof VaultChestBlock)) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        int newProgress = nbt.m_128451_(PROGRESS) + 1;
        nbt.m_128405_(PROGRESS, newProgress);
        int vaultLevel = SidedHelper.getVaultLevel((Player)player);
        int progressRequired = ModConfigs.POTION.getPotion(type).getChestRecharge(vaultLevel);
        if (progressRequired <= newProgress && nbt.m_128451_(CHARGES) < ModConfigs.POTION.getPotion(type).getCharges()) {
            nbt.m_128405_(CHARGES, nbt.m_128451_(CHARGES) + 1);
            nbt.m_128405_(PROGRESS, newProgress - progressRequired);
        }
    }

    public static void addCharges(ItemStack bottle, int charges) {
        int currentCharges = bottle.m_41784_().m_128451_(CHARGES);
        BottleItem.getType(bottle).ifPresent(type -> {
            int maxCharges = ModConfigs.POTION.getPotion((Type)((Object)type)).getCharges();
            if (currentCharges >= maxCharges) {
                return;
            }
            bottle.m_41784_().m_128405_(CHARGES, Math.min(maxCharges, currentCharges + charges));
        });
    }

    public static void setActive(Vault vault, ServerPlayer player) {
        BottleItem.getAnyInactive(player).ifPresent(stack -> {
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128359_(VAULT, vault.get(Vault.ID).toString());
            nbt.m_128473_(PROGRESS);
            BottleItem.getType(stack).ifPresent(type -> stack.m_41784_().m_128405_(CHARGES, ModConfigs.POTION.getPotion((Type)((Object)((Object)type))).getCharges()));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onAfterGuiItemRender(ItemStack stack, PoseStack poseStack) {
        if (BottleItem.shouldRenderNotification(stack)) {
            poseStack.m_85849_();
        }
    }

    public boolean isDamageable(ItemStack stack) {
        return BottleItem.getType(stack).isPresent();
    }

    public int getMaxDamage(ItemStack stack) {
        return ModConfigs.POTION.getPotion(BottleItem.getType(stack).orElse(Type.VIAL)).getCharges();
    }

    public int getDamage(ItemStack stack) {
        return stack.m_41782_() ? this.getMaxDamage(stack) - stack.m_41784_().m_128451_(CHARGES) : 0;
    }

    public boolean m_142522_(ItemStack pStack) {
        return false;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)entity;
        Vault vault = ServerVaults.get(player.f_19853_).orElse(null);
        if ((vault == null || BottleItem.isActive(vault, stack)) && stack.m_41784_().m_128451_(CHARGES) > 0) {
            CriteriaTriggers.f_10592_.m_23682_(player, stack);
            BottleItem.getEffect(stack).ifPresent(effect -> effect.trigger(player));
            BottleItem.getType(stack).ifPresent(type -> entity.m_5634_((float)ModConfigs.POTION.getPotion((Type)((Object)type)).getHealing()));
            BottleItem.consumeCharge(stack, player);
            world.m_142346_((Entity)entity, GameEvent.f_157805_, entity.m_146901_());
        }
        return stack;
    }

    public static Optional<BottleEffect> getEffect(ItemStack bottle) {
        if (!bottle.m_41782_() || !bottle.m_41783_().m_128441_(EFFECT)) {
            return Optional.empty();
        }
        return BottleEffectManager.deserialize(bottle.m_41783_().m_128469_(EFFECT));
    }

    public static void setEffect(ItemStack bottle, BottleEffect effect) {
        bottle.m_41784_().m_128365_(EFFECT, (Tag)effect.serialize());
    }

    public static void consumeCharge(ItemStack stack, ServerPlayer player) {
        float probability = 0.0f;
        TalentTree talents = PlayerTalentsData.get((ServerLevel)player.f_19853_).getTalents((Player)player);
        for (PrudentTalent talent : talents.getAll(PrudentTalent.class, Skill::isUnlocked)) {
            probability += talent.getProbability();
        }
        if (player.f_19853_.m_5822_().nextFloat() >= probability) {
            int currentCharges = stack.m_41784_().m_128451_(CHARGES);
            stack.m_41784_().m_128405_(CHARGES, currentCharges - 1);
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return stack.m_41784_().m_128451_(CHARGES) > 0 ? 32 : Integer.MAX_VALUE;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int currentCharges = stack.m_41784_().m_128451_(CHARGES);
        if (currentCharges > 0) {
            return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
        }
        return super.m_7203_(world, player, hand);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return new TranslatableComponent(this.m_5524_() + ".recharge." + BottleItem.getRecharge(stack).orElse(Recharge.TIME).getName().toLowerCase(Locale.ROOT)).m_7220_((Component)new TranslatableComponent(BottleItem.getType(stack).map(type -> this.m_5524_() + "." + type.getName()).orElseGet(() -> super.m_5524_()))).m_6270_(Style.f_131099_.m_178520_(BottleItem.getColor(stack)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (ModConfigs.POTION != null) {
            BottleItem.getType(stack).ifPresent(type -> {
                BottleItem.getRecharge(stack).ifPresent(recharge -> {
                    switch (recharge) {
                        case TIME: {
                            tooltip.add((Component)new TextComponent("Passively restores charges while inside a vault").m_130940_(ChatFormatting.GRAY));
                            break;
                        }
                        case MOBS: {
                            tooltip.add((Component)new TextComponent("Kill vault mobs to restore charges").m_130940_(ChatFormatting.GRAY));
                            break;
                        }
                        case CHESTS: {
                            tooltip.add((Component)new TextComponent("Loot vault chests to restore charges").m_130940_(ChatFormatting.GRAY));
                        }
                    }
                });
                this.addProgressTooltip(stack, tooltip, (Type)((Object)type));
                tooltip.add((Component)new TextComponent("Consume a ").m_7220_((Component)new TextComponent("charge").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent(" to")).m_130948_(Style.f_131099_.m_178520_(0xCFCFCF)));
                tooltip.add((Component)new TextComponent(" \u2022 Heal ").m_7220_((Component)new TextComponent(String.valueOf(ModConfigs.POTION.getPotion((Type)((Object)type)).getHealing()))).m_7220_((Component)new TextComponent(" Hit Points")).m_130940_(ChatFormatting.GREEN));
                BottleItem.getEffect(stack).ifPresent(effect -> tooltip.add((Component)new TextComponent(" \u2022 ").m_7220_(effect.getTooltip())));
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addProgressTooltip(ItemStack stack, List<Component> tooltip, Type type) {
        if (ModConfigs.POTION.getPotion(type).getCharges() > BottleItem.getCharges(stack)) {
            BottleItem.getRecharge(stack).ifPresent(recharge -> {
                switch (recharge) {
                    case TIME: {
                        int remainingTime = ModConfigs.POTION.getPotion(type).getTimeRecharge() - this.getProgress(stack);
                        String time = remainingTime / 20 / 60 + "m " + remainingTime / 20 % 60 + "s";
                        tooltip.add((Component)new TextComponent("Restores a charge in ").m_7220_((Component)new TextComponent(time).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_6270_(Style.f_131099_.m_178520_(0xCFCFCF)));
                        break;
                    }
                    case MOBS: {
                        tooltip.add((Component)new TextComponent("Kill ").m_7220_((Component)new TextComponent(this.getProgress(stack) + " / " + ModConfigs.POTION.getPotion(type).getMobRecharge(SidedHelper.getVaultLevel((Player)Minecraft.m_91087_().f_91074_))).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent(" vault mobs to recharge")).m_6270_(Style.f_131099_.m_178520_(0xCFCFCF)));
                        break;
                    }
                    case CHESTS: {
                        tooltip.add((Component)new TextComponent("Loot ").m_7220_((Component)new TextComponent(this.getProgress(stack) + " / " + ModConfigs.POTION.getPotion(type).getChestRecharge(SidedHelper.getVaultLevel((Player)Minecraft.m_91087_().f_91074_))).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent(" vault chests to recharge")).m_6270_(Style.f_131099_.m_178520_(0xCFCFCF)));
                    }
                }
            });
        } else {
            tooltip.add((Component)new TextComponent("Fully charged").m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (stack.m_41782_() && stack.m_41783_().m_128441_(VAULT)) {
                UUID vaultId = UUID.fromString(stack.m_41784_().m_128461_(VAULT));
                Vault vault = ServerVaults.get(vaultId).orElse(null);
                boolean inVaultWorld = ServerVaults.isInVault(player.f_19853_);
                if (vault == null || !vault.get(Vault.LISTENERS).contains(player.m_142081_()) && !inVaultWorld) {
                    stack.m_41784_().m_128473_(VAULT);
                    BottleItem.getType(stack).ifPresent(type -> stack.m_41784_().m_128405_(CHARGES, ModConfigs.POTION.getPotion((Type)((Object)type)).getCharges()));
                }
            }
        } else {
            if (this.isActive(stack) && BottleItem.getRecharge(stack).map(r -> r != Recharge.TIME).orElse(false).booleanValue() && notifiableBottleStack != stack) {
                if (!notifiableBottleStack.m_41619_()) {
                    if (BottleItem.getCharges(stack) > BottleItem.getCharges(notifiableBottleStack)) {
                        chargeNotificationTime = world.m_46467_();
                    }
                    if (this.getProgress(stack) > this.getProgress(notifiableBottleStack)) {
                        progressPoints += this.getProgress(stack) - this.getProgress(notifiableBottleStack);
                        progressNotificationTime = world.m_46467_();
                    }
                }
                notifiableBottleStack = stack;
            }
            if ((float)Math.abs(chargeNotificationTime - world.m_46467_()) > 20.0f) {
                chargeNotificationTime = -1L;
            }
            if ((float)Math.abs(progressNotificationTime - world.m_46467_()) > 40.0f) {
                progressNotificationTime = -1L;
                progressPoints = 0;
            }
        }
    }

    private int getProgress(ItemStack stack) {
        return stack.m_41784_().m_128451_(PROGRESS);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void m_6787_(@NotNull CreativeModeTab category, @NotNull NonNullList<ItemStack> items) {
        if (!this.m_41389_(category)) {
            return;
        }
        for (Type type : Type.values()) {
            for (Recharge recharge : Recharge.values()) {
                items.add((Object)BottleItem.create(type, recharge));
            }
        }
    }

    public static ItemStack create(Type type, Recharge recharge) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.BOTTLE);
        if (type != null) {
            stack.m_41784_().m_128359_(TYPE, type.getName());
            stack.m_41784_().m_128405_(CHARGES, 6);
        }
        if (recharge != null) {
            stack.m_41784_().m_128359_(RECHARGE, recharge.getName());
        }
        return stack;
    }

    public static Optional<Type> getType(ItemStack stack) {
        if (stack == null || !stack.m_41782_()) {
            return Optional.empty();
        }
        String raw = stack.m_41784_().m_128461_(TYPE);
        return Optional.ofNullable(Type.fromString(raw));
    }

    public static Optional<Recharge> getRecharge(ItemStack stack) {
        if (stack == null || !stack.m_41782_()) {
            return Optional.empty();
        }
        String raw = stack.m_41784_().m_128461_(RECHARGE);
        return Optional.ofNullable(Recharge.fromString(raw));
    }

    public static int getCharges(ItemStack stack) {
        if (stack == null || !stack.m_41782_()) {
            return 0;
        }
        return stack.m_41784_().m_128451_(CHARGES);
    }

    public static boolean isActive(Vault vault, ItemStack stack) {
        if (!(stack.m_41720_() instanceof BottleItem) || !stack.m_41782_()) {
            return false;
        }
        String uuid = stack.m_41784_().m_128461_(VAULT);
        return vault.get(Vault.ID).toString().equals(uuid);
    }

    private boolean isActive(ItemStack stack) {
        if (!(stack.m_41720_() instanceof BottleItem) || !stack.m_41782_()) {
            return false;
        }
        return stack.m_41784_().m_128441_(VAULT);
    }

    public static Optional<ItemStack> getActive(Vault vault, ServerPlayer player) {
        int size = ((InventorySnapshotData.InventoryAccessor)player.m_150109_()).getSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!BottleItem.isActive(vault, stack)) continue;
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getAnyInactive(ServerPlayer player) {
        int size = ((InventorySnapshotData.InventoryAccessor)player.m_150109_()).getSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof BottleItem) || !stack.m_41782_() || stack.m_41784_().m_128441_(VAULT)) continue;
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public static void onMobKill(ItemStack stack, ServerPlayer player, Entity entityKilled) {
        Type type = BottleItem.getType(stack).orElse(null);
        Recharge recharge = BottleItem.getRecharge(stack).orElse(null);
        if (type == null || ModConfigs.POTION.getPotion(type).getCharges() <= BottleItem.getCharges(stack) || recharge != Recharge.MOBS || !(entityKilled instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingKilled = (LivingEntity)entityKilled;
        CompoundTag nbt = stack.m_41784_();
        int newProgress = nbt.m_128451_(PROGRESS) + EntityHelper.getEntityValue(livingKilled);
        nbt.m_128405_(PROGRESS, newProgress);
        int vaultLevel = SidedHelper.getVaultLevel((Player)player);
        int progressRequired = ModConfigs.POTION.getPotion(type).getMobRecharge(vaultLevel);
        if (progressRequired <= newProgress && nbt.m_128451_(CHARGES) < ModConfigs.POTION.getPotion(type).getCharges()) {
            nbt.m_128405_(CHARGES, nbt.m_128451_(CHARGES) + 1);
            nbt.m_128405_(PROGRESS, newProgress - progressRequired);
        }
    }

    public static void onTimeTick(ItemStack stack) {
        Type type = BottleItem.getType(stack).orElse(null);
        Recharge recharge = BottleItem.getRecharge(stack).orElse(null);
        if (type == null || ModConfigs.POTION.getPotion(type).getCharges() <= BottleItem.getCharges(stack) || recharge != Recharge.TIME) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        int value = nbt.m_128451_(PROGRESS) + 1;
        nbt.m_128405_(PROGRESS, value);
        if (value % ModConfigs.POTION.getPotion(type).getTimeRecharge() == 0 && nbt.m_128451_(CHARGES) < ModConfigs.POTION.getPotion(type).getCharges()) {
            nbt.m_128405_(CHARGES, nbt.m_128451_(CHARGES) + 1);
            nbt.m_128405_(PROGRESS, 0);
        }
    }

    public static int getColor(ItemStack stack) {
        Type type = BottleItem.getType(stack).orElse(null);
        Recharge recharge = BottleItem.getRecharge(stack).orElse(null);
        if (type == null || recharge == null) {
            return 0xFFFFFF;
        }
        return switch (recharge) {
            default -> throw new IncompatibleClassChangeError();
            case Recharge.TIME -> 1004218;
            case Recharge.MOBS -> 16720896;
            case Recharge.CHESTS -> 16766720;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderBottleProgressNotification(Font font, ItemStack stack, int xPosition, int yPosition) {
        if (BottleItem.shouldRenderProgressNotification(stack)) {
            PoseStack poseStack = new PoseStack();
            poseStack.m_85837_(0.0, 0.0, (double)(Minecraft.m_91087_().m_91291_().f_115093_ + 200.0f));
            float scale = 0.8f;
            poseStack.m_85841_(scale, scale, 1.0f);
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            String s = "+" + progressPoints;
            int color = DyeColor.LIME.m_41071_();
            Minecraft.m_91087_().f_91062_.m_92811_(s, ((float)(xPosition + 19 - 2) - (float)font.m_92895_(s) * scale) / scale, ((float)yPosition + (1.0f / (scale * scale) - 1.0f)) / scale, color, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
            bufferSource.m_109911_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onBeforeGuiItemRender(ItemStack stack, PoseStack poseStack) {
        if (BottleItem.shouldRenderNotification(stack)) {
            poseStack.m_85836_();
            float additionalScale = 0.5f;
            long timePassedSinceNotification = (Minecraft.m_91087_().f_91073_.m_46467_() - chargeNotificationTime) % 20L;
            float partial = 1.0f - Math.abs(((float)timePassedSinceNotification - 10.0f) / 10.0f);
            float scale = 1.0f + additionalScale * partial;
            poseStack.m_85841_(scale, scale, scale);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean shouldRenderNotification(ItemStack stack) {
        return stack == notifiableBottleStack && chargeNotificationTime > 0L;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean shouldRenderProgressNotification(ItemStack stack) {
        return stack == notifiableBottleStack && progressNotificationTime > 0L;
    }

    public static enum Type {
        VIAL,
        POTION,
        MIXTURE,
        BREW;

        private static final Map<String, Type> NAME_TO_TYPE;

        public String getName() {
            return this.name().toLowerCase();
        }

        public static Type fromString(String name) {
            return NAME_TO_TYPE.get(name.toLowerCase());
        }

        static {
            NAME_TO_TYPE = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, Functions.identity()));
        }
    }

    public static enum Recharge {
        TIME,
        MOBS,
        CHESTS;

        private static final Map<String, Recharge> NAME_TO_TYPE;

        public String getName() {
            return this.name().toLowerCase();
        }

        public static Recharge fromString(String name) {
            return NAME_TO_TYPE.get(name.toLowerCase());
        }

        static {
            NAME_TO_TYPE = Arrays.stream(Recharge.values()).collect(Collectors.toMap(Recharge::getName, Functions.identity()));
        }
    }
}

