/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.bottle;

import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.item.bottle.BottleEffect;
import iskallia.vault.mana.FullManaPlayer;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.source.SkillSource;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CastAbilityBottleEffect
extends BottleEffect {
    public static final String TYPE = "cast_ability";
    private final String abilityId;

    public CastAbilityBottleEffect(String effectId, String abilityId) {
        super(effectId);
        this.abilityId = abilityId;
    }

    @Override
    protected String getType() {
        return TYPE;
    }

    @Override
    protected void trigger(ServerPlayer player) {
        AbilityTree tree = PlayerAbilitiesData.get((ServerLevel)player.f_19853_).getAbilities((Player)player);
        tree.getForId(this.abilityId).ifPresent(skill -> {
            if (skill instanceof SpecializedSkill) {
                SpecializedSkill specialized = (SpecializedSkill)skill;
                v0 = specialized.getSpecialization();
            } else {
                v0 = skill = skill;
            }
            if (skill instanceof TieredSkill) {
                TieredSkill tiered = (TieredSkill)skill;
                v1 = tiered.getChild();
            } else {
                v1 = skill = skill;
            }
            if (!(skill instanceof InstantAbility)) {
                return;
            }
            InstantAbility instantAbility = (InstantAbility)skill;
            instantAbility.onAction(SkillContext.of(player, SkillSource.of((Entity)player).setPos(player.m_20182_()).setMana(FullManaPlayer.INSTANCE)));
        });
    }

    @Override
    public CompoundTag serializeData(CompoundTag tag) {
        tag.m_128359_("abilityId", this.abilityId);
        return tag;
    }

    @Override
    protected String getTooltipText(String tooltipFormat) {
        return ClientAbilityData.getTree().getForId(this.abilityId).map(skill -> {
            Ability ability;
            Skill patt1948$temp;
            if (skill instanceof Ability && (patt1948$temp = (ability = (Ability)skill).getParent()) instanceof TieredSkill) {
                TieredSkill tiered = (TieredSkill)patt1948$temp;
                return String.format(tooltipFormat, tiered.getName(), tiered.getTierOf(this.abilityId));
            }
            return tooltipFormat;
        }).orElse(tooltipFormat);
    }

    public static CastAbilityBottleEffect deserialize(String effectId, CompoundTag tag) {
        return new CastAbilityBottleEffect(effectId, tag.m_128461_("abilityId"));
    }
}

