/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.bottle;

import iskallia.vault.init.ModEffects;
import iskallia.vault.item.bottle.BottleEffect;
import java.util.HashSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CleanseBottleEffect
extends BottleEffect {
    public static final String TYPE = "cleanse";
    private final int duration;

    public CleanseBottleEffect(String effectId, int duration) {
        super(effectId);
        this.duration = duration;
    }

    @Override
    protected String getType() {
        return TYPE;
    }

    @Override
    protected void trigger(ServerPlayer player) {
        HashSet effectsToRemove = new HashSet();
        player.m_21220_().forEach(effectInstance -> {
            if (effectInstance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
                effectsToRemove.add(effectInstance.m_19544_());
            }
        });
        effectsToRemove.forEach(arg_0 -> ((ServerPlayer)player).m_21195_(arg_0));
        player.m_7292_(new MobEffectInstance(ModEffects.PURIFYING_AURA, this.duration, 0, false, false, true));
    }

    @Override
    public CompoundTag serializeData(CompoundTag tag) {
        tag.m_128405_("duration", this.duration);
        return tag;
    }

    @Override
    protected String getTooltipText(String tooltipFormat) {
        return String.format(tooltipFormat, this.duration / 20);
    }

    @SubscribeEvent
    public static void onPotionApplicable(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntityLiving().m_21023_(ModEffects.PURIFYING_AURA) && event.getPotionEffect().m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
            event.setResult(Event.Result.DENY);
        }
    }

    public static BottleEffect deserialize(String effectId, CompoundTag tag) {
        return new CleanseBottleEffect(effectId, tag.m_128451_("duration"));
    }

    public static class PurifyingAuraEffect
    extends MobEffect {
        public PurifyingAuraEffect(ResourceLocation key, int color) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(key);
        }
    }
}

