/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.bottle;

import iskallia.vault.item.bottle.BottleEffect;
import iskallia.vault.mana.Mana;
import iskallia.vault.mana.ManaAction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ManaFlatBottleEffect
extends BottleEffect {
    public static final String TYPE = "mana_flat";
    private final float amount;

    public ManaFlatBottleEffect(String effectId, float amount) {
        super(effectId);
        this.amount = amount;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getTooltipText(String tooltipFormat) {
        return String.format(tooltipFormat, (int)this.amount);
    }

    @Override
    public void trigger(ServerPlayer player) {
        float current = Mana.get((Player)player);
        float total = Mana.getMax((Player)player);
        Mana.set((Player)player, ManaAction.PLAYER_ACTION, Math.min(total, this.amount + current));
    }

    @Override
    public CompoundTag serializeData(CompoundTag tag) {
        tag.m_128350_("amount", this.amount);
        return tag;
    }

    public static BottleEffect deserialize(String effectId, CompoundTag tag) {
        return new ManaFlatBottleEffect(effectId, tag.m_128457_("amount"));
    }
}

