/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.bottle;

import iskallia.vault.item.bottle.BottleEffect;
import iskallia.vault.util.calc.EffectDurationHelper;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionBottleEffect
extends BottleEffect {
    public static final String TYPE = "potion";
    private final MobEffect potion;
    private final int duration;
    private final int amplifier;

    public PotionBottleEffect(String effectId, MobEffect potion, int duration, int amplifier) {
        super(effectId);
        this.potion = potion;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void trigger(ServerPlayer player) {
        int totalAmplifier;
        MobEffectInstance effect = player.m_21124_(this.potion);
        if (effect instanceof BottleMobEffectInstance) {
            totalAmplifier = effect.m_19564_();
        } else {
            int n = totalAmplifier = effect == null ? this.amplifier : effect.m_19564_() + this.amplifier + 1;
        }
        if (effect != null) {
            player.m_6234_(this.potion);
        }
        int durationTicks = this.duration;
        durationTicks = EffectDurationHelper.adjustEffectDurationFloor((LivingEntity)player, durationTicks);
        player.m_7292_((MobEffectInstance)new BottleMobEffectInstance(this.potion, durationTicks, totalAmplifier));
    }

    @Override
    public CompoundTag serializeData(CompoundTag tag) {
        tag.m_128359_(TYPE, this.potion.getRegistryName().toString());
        tag.m_128405_("duration", this.duration);
        tag.m_128405_("amplifier", this.amplifier);
        return tag;
    }

    @Override
    public String getTooltipText(String tooltipFormat) {
        return String.format(tooltipFormat, this.duration / 20, this.potion.m_19482_().getString(), Language.m_128107_().m_6834_("potion.potency." + this.amplifier));
    }

    public static BottleEffect deserialize(String effectId, CompoundTag tag) {
        MobEffect potion = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(tag.m_128461_(TYPE)));
        return new PotionBottleEffect(effectId, potion, tag.m_128451_("duration"), tag.m_128451_("amplifier"));
    }

    public static class BottleMobEffectInstance
    extends MobEffectInstance {
        public BottleMobEffectInstance(MobEffect potion, int duration, int totalAmplifier) {
            super(potion, duration, totalAmplifier, false, false, true);
        }

        public boolean m_19552_(LivingEntity pEntity, Runnable p_19554_) {
            return super.m_19552_(pEntity, p_19554_);
        }
    }
}

