/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.core;

import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import java.util.HashSet;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface DataTransferItem {
    public static ItemStack doConvertStack(ItemStack stack) {
        return DataTransferItem.doConvertStack(stack, JavaRandom.ofNanoTime());
    }

    public static ItemStack doConvertStack(ItemStack stack, RandomSource random) {
        Item item = stack.m_41720_();
        if (item instanceof DataTransferItem) {
            DataTransferItem transferItem = (DataTransferItem)item;
            return transferItem.convertStack(stack, random);
        }
        return stack;
    }

    default public ItemStack convertStack(ItemStack stack, RandomSource random) {
        this.convertData(stack);
        return stack;
    }

    default public void convertData(ItemStack stack) {
        if (!stack.m_41782_()) {
            return;
        }
        HashSet<String> convertedKeys = new HashSet<String>();
        CompoundTag tag = stack.m_41784_();
        Object data = AttributeGearData.read(stack);
        for (String key : tag.m_128431_()) {
            ResourceLocation attrKey;
            try {
                attrKey = new ResourceLocation(key);
            }
            catch (ResourceLocationException exc) {
                continue;
            }
            VaultGearAttribute<?> attr = VaultGearAttributeRegistry.getAttribute(attrKey);
            if (attr == null) continue;
            this.transferData((AttributeGearData)data, attr, tag.m_128423_(key));
            convertedKeys.add(key);
        }
        ((AttributeGearData)data).write(stack);
        convertedKeys.forEach(arg_0 -> ((CompoundTag)tag).m_128473_(arg_0));
    }

    default public <T> void transferData(AttributeGearData data, VaultGearAttribute<T> attr, Tag tag) {
        if (attr == ModGearAttributes.STATE && data instanceof VaultGearData) {
            VaultGearData vaultGearData = (VaultGearData)data;
            vaultGearData.setState(ModGearAttributes.STATE.getType().nbtRead(tag));
        } else {
            data.createOrReplaceAttributeValue(attr, attr.getType().nbtRead(tag));
        }
    }
}

