/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.item.crystal.CrystalEntry;
import iskallia.vault.item.crystal.CrystalVersion;
import iskallia.vault.item.crystal.layout.ArchitectCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicCircleCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicPolygonCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicSpiralCrystalLayout;
import iskallia.vault.item.crystal.layout.CompoundCrystalLayout;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.layout.HeraldCrystalLayout;
import iskallia.vault.item.crystal.layout.NullCrystalLayout;
import iskallia.vault.item.crystal.layout.ParadoxCrystalLayout;
import iskallia.vault.item.crystal.layout.PersonalCrystalLayout;
import iskallia.vault.item.crystal.layout.RaidCrystalLayout;
import iskallia.vault.item.crystal.model.AugmentCrystalModel;
import iskallia.vault.item.crystal.model.ChaosCrystalModel;
import iskallia.vault.item.crystal.model.CompoundCrystalModel;
import iskallia.vault.item.crystal.model.CrystalModel;
import iskallia.vault.item.crystal.model.GrayscaleCrystalModel;
import iskallia.vault.item.crystal.model.NullCrystalModel;
import iskallia.vault.item.crystal.model.RainbowCrystalModel;
import iskallia.vault.item.crystal.model.RawCrystalModel;
import iskallia.vault.item.crystal.modifiers.CrystalModifiers;
import iskallia.vault.item.crystal.modifiers.DefaultCrystalModifiers;
import iskallia.vault.item.crystal.modifiers.ParadoxCrystalModifiers;
import iskallia.vault.item.crystal.modifiers.PersonalCrystalModifiers;
import iskallia.vault.item.crystal.objective.AscensionCrystalObjective;
import iskallia.vault.item.crystal.objective.BingoCrystalObjective;
import iskallia.vault.item.crystal.objective.BossCrystalObjective;
import iskallia.vault.item.crystal.objective.CakeCrystalObjective;
import iskallia.vault.item.crystal.objective.CompoundCrystalObjective;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.crystal.objective.ElixirCrystalObjective;
import iskallia.vault.item.crystal.objective.EmptyCrystalObjective;
import iskallia.vault.item.crystal.objective.GreedCrystalObjective;
import iskallia.vault.item.crystal.objective.HeraldCrystalObjective;
import iskallia.vault.item.crystal.objective.MonolithCrystalObjective;
import iskallia.vault.item.crystal.objective.NullCrystalObjective;
import iskallia.vault.item.crystal.objective.ParadoxCrystalObjective;
import iskallia.vault.item.crystal.objective.PersonalCrystalObjective;
import iskallia.vault.item.crystal.objective.PoolCrystalObjective;
import iskallia.vault.item.crystal.objective.PvPCrystalObjective;
import iskallia.vault.item.crystal.objective.RaidCrystalObjective;
import iskallia.vault.item.crystal.objective.RoyaleCrystalObjective;
import iskallia.vault.item.crystal.objective.RoyalePvPCrystalObjective;
import iskallia.vault.item.crystal.objective.ScavengerCrystalObjective;
import iskallia.vault.item.crystal.objective.SpeedrunCrystalObjective;
import iskallia.vault.item.crystal.objective.VaultRuneBossCrystalObjective;
import iskallia.vault.item.crystal.properties.CapacityCrystalProperties;
import iskallia.vault.item.crystal.properties.CrystalProperties;
import iskallia.vault.item.crystal.properties.InstabilityCrystalProperties;
import iskallia.vault.item.crystal.theme.CrystalTheme;
import iskallia.vault.item.crystal.theme.NullCrystalTheme;
import iskallia.vault.item.crystal.theme.PoolCrystalTheme;
import iskallia.vault.item.crystal.theme.ValueCrystalTheme;
import iskallia.vault.item.crystal.time.CrystalTime;
import iskallia.vault.item.crystal.time.InfiniteCrystalTime;
import iskallia.vault.item.crystal.time.NullCrystalTime;
import iskallia.vault.item.crystal.time.PoolCrystalTime;
import iskallia.vault.item.crystal.time.ValueCrystalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class CrystalData
extends CrystalEntry
implements ISerializable<CompoundTag, JsonObject> {
    public static EnumAdapter<CrystalVersion> VERSION = Adapters.ofEnum(CrystalVersion.class, EnumAdapter.Mode.ORDINAL);
    public static TypeSupplierAdapter<CrystalModel> MODEL = ((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)new TypeSupplierAdapter<CrystalModel>("type", false).register("null", NullCrystalModel.class, () -> NullCrystalModel.INSTANCE)).register("compound", CompoundCrystalModel.class, CompoundCrystalModel::new)).register("rainbow", RainbowCrystalModel.class, RainbowCrystalModel::new)).register("raw", RawCrystalModel.class, RawCrystalModel::new)).register("chaos", ChaosCrystalModel.class, ChaosCrystalModel::new)).register("grayscale", GrayscaleCrystalModel.class, GrayscaleCrystalModel::new)).register("augment", AugmentCrystalModel.class, AugmentCrystalModel::new);
    public static TypeSupplierAdapter<CrystalTheme> THEME = ((TypeSupplierAdapter)((TypeSupplierAdapter)new TypeSupplierAdapter<CrystalTheme>("type", false).register("null", NullCrystalTheme.class, () -> NullCrystalTheme.INSTANCE)).register("value", ValueCrystalTheme.class, ValueCrystalTheme::new)).register("pool", PoolCrystalTheme.class, PoolCrystalTheme::new);
    public static TypeSupplierAdapter<CrystalLayout> LAYOUT = ((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)new TypeSupplierAdapter<CrystalLayout>("type", false).register("null", NullCrystalLayout.class, () -> NullCrystalLayout.INSTANCE)).register("infinite", ClassicInfiniteCrystalLayout.class, ClassicInfiniteCrystalLayout::new)).register("circle", ClassicCircleCrystalLayout.class, ClassicCircleCrystalLayout::new)).register("polygon", ClassicPolygonCrystalLayout.class, ClassicPolygonCrystalLayout::new)).register("spiral", ClassicSpiralCrystalLayout.class, ClassicSpiralCrystalLayout::new)).register("architect", ArchitectCrystalLayout.class, ArchitectCrystalLayout::new)).register("paradox", ParadoxCrystalLayout.class, ParadoxCrystalLayout::new)).register("personal", PersonalCrystalLayout.class, PersonalCrystalLayout::new)).register("herald", HeraldCrystalLayout.class, HeraldCrystalLayout::new)).register("raid", RaidCrystalLayout.class, RaidCrystalLayout::new)).register("compound", CompoundCrystalLayout.class, CompoundCrystalLayout::new);
    public static TypeSupplierAdapter<CrystalObjective> OBJECTIVE = ((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)new TypeSupplierAdapter<CrystalObjective>("type", false).register("null", NullCrystalObjective.class, () -> NullCrystalObjective.INSTANCE)).register("pool", PoolCrystalObjective.class, PoolCrystalObjective::new)).register("empty", EmptyCrystalObjective.class, EmptyCrystalObjective::new)).register("boss", BossCrystalObjective.class, BossCrystalObjective::new)).register("cake", CakeCrystalObjective.class, CakeCrystalObjective::new)).register("scavenger", ScavengerCrystalObjective.class, ScavengerCrystalObjective::new)).register("speedrun", SpeedrunCrystalObjective.class, SpeedrunCrystalObjective::new)).register("monolith", MonolithCrystalObjective.class, MonolithCrystalObjective::new)).register("elixir", ElixirCrystalObjective.class, ElixirCrystalObjective::new)).register("paradox", ParadoxCrystalObjective.class, ParadoxCrystalObjective::new)).register("personal", PersonalCrystalObjective.class, PersonalCrystalObjective::new)).register("herald", HeraldCrystalObjective.class, HeraldCrystalObjective::new)).register("compound", CompoundCrystalObjective.class, CompoundCrystalObjective::new)).register("ascension", AscensionCrystalObjective.class, AscensionCrystalObjective::new)).register("bingo", BingoCrystalObjective.class, BingoCrystalObjective::new)).register("rune_boss", VaultRuneBossCrystalObjective.class, VaultRuneBossCrystalObjective::new)).register("raid", RaidCrystalObjective.class, RaidCrystalObjective::new)).register("royale", RoyaleCrystalObjective.class, RoyaleCrystalObjective::new)).register("greed", GreedCrystalObjective.class, GreedCrystalObjective::new)).register("pvp", PvPCrystalObjective.class, PvPCrystalObjective::new)).register("royale_pvp", RoyalePvPCrystalObjective.class, RoyalePvPCrystalObjective::new);
    public static TypeSupplierAdapter<CrystalTime> TIME = ((TypeSupplierAdapter)((TypeSupplierAdapter)((TypeSupplierAdapter)new TypeSupplierAdapter<CrystalTime>("type", false).register("null", NullCrystalTime.class, () -> NullCrystalTime.INSTANCE)).register("value", ValueCrystalTime.class, ValueCrystalTime::new)).register("pool", PoolCrystalTime.class, PoolCrystalTime::new)).register("infinite", InfiniteCrystalTime.class, InfiniteCrystalTime::new);
    public static TypeSupplierAdapter<CrystalModifiers> MODIFIERS = ((TypeSupplierAdapter)((TypeSupplierAdapter)new TypeSupplierAdapter<CrystalModifiers>("type", false).register("default", DefaultCrystalModifiers.class, DefaultCrystalModifiers::new)).register("paradox", ParadoxCrystalModifiers.class, ParadoxCrystalModifiers::new)).register("personal", PersonalCrystalModifiers.class, PersonalCrystalModifiers::new);
    public static TypeSupplierAdapter<CrystalProperties> PROPERTIES = ((TypeSupplierAdapter)new TypeSupplierAdapter<CrystalProperties>("type", false).register("instability", InstabilityCrystalProperties.class, InstabilityCrystalProperties::new)).register("capacity", CapacityCrystalProperties.class, CapacityCrystalProperties::new);
    private CrystalVersion version = CrystalVersion.latest();
    private CrystalModel model = NullCrystalModel.INSTANCE;
    private CrystalTheme theme = NullCrystalTheme.INSTANCE;
    private CrystalLayout layout = NullCrystalLayout.INSTANCE;
    private CrystalObjective objective = NullCrystalObjective.INSTANCE;
    private CrystalTime time = NullCrystalTime.INSTANCE;
    private CrystalModifiers modifiers = new DefaultCrystalModifiers();
    private CrystalProperties properties = new CapacityCrystalProperties();

    protected CrystalData() {
    }

    protected CrystalData(@Nullable CompoundTag nbt) {
        if (nbt != null) {
            this.readNbt(nbt);
        }
    }

    public static CrystalData empty() {
        return new CrystalData();
    }

    public static CrystalData read(ItemStack stack) {
        return new CrystalData(stack.m_41737_("CrystalData"));
    }

    public CrystalData write(ItemStack stack) {
        this.writeNbt().ifPresent(nbt -> stack.m_41784_().m_128365_("CrystalData", (Tag)nbt));
        return this;
    }

    public static void run(ItemStack stack, Consumer<CrystalData> consumer) {
        CrystalData data = CrystalData.read(stack);
        consumer.accept(data);
        data.write(stack);
    }

    public CrystalModel getModel() {
        return this.model;
    }

    public CrystalTheme getTheme() {
        return this.theme;
    }

    public CrystalLayout getLayout() {
        return this.layout;
    }

    public CrystalObjective getObjective() {
        return this.objective;
    }

    public CrystalTime getTime() {
        return this.time;
    }

    public CrystalModifiers getModifiers() {
        return this.modifiers;
    }

    public CrystalProperties getProperties() {
        return this.properties;
    }

    public void setModel(CrystalModel model) {
        this.model = model;
    }

    public void setTheme(CrystalTheme theme) {
        this.theme = theme;
    }

    public void setLayout(CrystalLayout layout) {
        this.layout = layout;
    }

    public void setObjective(CrystalObjective objective) {
        this.objective = objective;
    }

    public void setTime(CrystalTime time) {
        this.time = time;
    }

    public void setModifiers(CrystalModifiers modifiers) {
        this.modifiers = modifiers;
    }

    public void setProperties(CrystalProperties properties) {
        this.properties = properties;
    }

    public boolean canGenerateCatalystFragments() {
        return this.modifiers.hasRandomModifiers() || this.objective instanceof AscensionCrystalObjective;
    }

    public boolean canGenerateRunes() {
        return !(this.layout instanceof ArchitectCrystalLayout);
    }

    public boolean addModifierByCrafting(VaultModifierStack modifierStack, boolean preventsRandomModifiers, boolean simulate) {
        return this.modifiers.addByCrafting(this, modifierStack, preventsRandomModifiers, simulate);
    }

    @Override
    public Collection<CrystalEntry> getChildren() {
        return Arrays.asList(this.properties, this.objective, this.layout, this.theme, this.time, this.modifiers);
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        this.objective.addText(tooltip, minIndex, flag, time);
        this.theme.addText(tooltip, minIndex, flag, time);
        this.layout.addText(tooltip, minIndex, flag, time);
        this.time.addText(tooltip, minIndex, flag, time);
        this.properties.addText(tooltip, minIndex, flag, time);
        this.modifiers.addText(tooltip, minIndex, flag, time);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        VERSION.writeNbt(this.version).ifPresent(version -> nbt.m_128365_("Version", version));
        MODEL.writeNbt(this.model).ifPresent(model -> nbt.m_128365_("Model", model));
        THEME.writeNbt(this.theme).ifPresent(theme -> nbt.m_128365_("Theme", theme));
        LAYOUT.writeNbt(this.layout).ifPresent(layout -> nbt.m_128365_("Layout", layout));
        OBJECTIVE.writeNbt(this.objective).ifPresent(objective -> nbt.m_128365_("Objective", objective));
        TIME.writeNbt(this.time).ifPresent(time -> nbt.m_128365_("Time", time));
        MODIFIERS.writeNbt(this.modifiers).ifPresent(modifiers -> nbt.m_128365_("Modifiers", modifiers));
        PROPERTIES.writeNbt(this.properties).ifPresent(modifiers -> nbt.m_128365_("Properties", modifiers));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        nbt = CrystalVersion.upgrade(nbt.m_6426_());
        this.version = VERSION.readNbt(nbt.m_128423_("Version")).orElse(CrystalVersion.LEGACY);
        this.model = MODEL.readNbt((Tag)nbt.m_128469_("Model")).orElse(NullCrystalModel.INSTANCE);
        this.theme = THEME.readNbt((Tag)nbt.m_128469_("Theme")).orElse(NullCrystalTheme.INSTANCE);
        this.layout = LAYOUT.readNbt((Tag)nbt.m_128469_("Layout")).orElse(NullCrystalLayout.INSTANCE);
        this.objective = OBJECTIVE.readNbt((Tag)nbt.m_128469_("Objective")).orElse(NullCrystalObjective.INSTANCE);
        this.time = TIME.readNbt((Tag)nbt.m_128469_("Time")).orElse(NullCrystalTime.INSTANCE);
        this.modifiers = MODIFIERS.readNbt((Tag)nbt.m_128469_("Modifiers")).orElse(new DefaultCrystalModifiers());
        this.properties = PROPERTIES.readNbt((Tag)nbt.m_128469_("Properties")).orElse(new CapacityCrystalProperties());
    }

    public CrystalData copy() {
        return new CrystalData(this.writeNbt().orElse(null));
    }
}

