/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal;

import iskallia.vault.VaultMod;
import iskallia.vault.block.VaultPortalBlock;
import iskallia.vault.block.VaultPortalSize;
import iskallia.vault.block.entity.VaultPortalTileEntity;
import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.objective.ParadoxObjective;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.CrystalRenderer;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import iskallia.vault.item.crystal.layout.HeraldCrystalLayout;
import iskallia.vault.item.crystal.layout.ParadoxCrystalLayout;
import iskallia.vault.item.crystal.layout.PersonalCrystalLayout;
import iskallia.vault.item.crystal.layout.RaidCrystalLayout;
import iskallia.vault.item.crystal.model.RawCrystalModel;
import iskallia.vault.item.crystal.modifiers.ParadoxCrystalModifiers;
import iskallia.vault.item.crystal.modifiers.PersonalCrystalModifiers;
import iskallia.vault.item.crystal.objective.BingoCrystalObjective;
import iskallia.vault.item.crystal.objective.EmptyCrystalObjective;
import iskallia.vault.item.crystal.objective.HeraldCrystalObjective;
import iskallia.vault.item.crystal.objective.ParadoxCrystalObjective;
import iskallia.vault.item.crystal.objective.PersonalCrystalObjective;
import iskallia.vault.item.crystal.objective.RaidCrystalObjective;
import iskallia.vault.item.crystal.properties.CapacityCrystalProperties;
import iskallia.vault.item.crystal.theme.PoolCrystalTheme;
import iskallia.vault.item.crystal.theme.ValueCrystalTheme;
import iskallia.vault.item.render.core.IManualModelLoading;
import iskallia.vault.www.metrics.StatsManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;

public class VaultCrystalItem
extends Item
implements IManualModelLoading {
    public static final String KEY_SCHEDULED_TASKS = "scheduledTasks";
    private static final Map<String, IScheduledTaskDeserializer> SCHEDULED_TASK_DESERIALIZER_MAP = new HashMap<String, IScheduledTaskDeserializer>(){
        {
            this.put("exhaust", ExhaustTask::deserializeNBT);
            this.put("removeRandomCurse", RemoveRandomCurseTask::deserializeNBT);
            this.put("addCurses", AddModifiersTask::deserializeNBT);
            this.put("addClarity", AddClarityTask::deserializeNBT);
            this.put("echo", EchoTask::deserializeNBT);
            this.put("clone", CloneTask::deserializeNBT);
            this.put("removeRandomNegativeModifier", RemoveRandomNegativeModifierTask::deserializeNBT);
            this.put("addRandomCurse", NoOpTask::deserializeNBT);
            this.put("addRandomCurses", NoOpTask::deserializeNBT);
        }
    };
    public static final ResourceLocation NEGATIVE_MODIFIER_POOL_NAME = VaultMod.id("challenge_stack");

    public VaultCrystalItem(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(1));
        this.setRegistryName(id);
    }

    public void onWorldTick(Level world, ItemEntity entity) {
        ItemStack stack = entity.m_32055_().m_41777_();
        CrystalData data = CrystalData.read(stack);
        data.onWorldTick(world, entity);
        data.write(stack);
        entity.m_32045_(stack);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)VaultCrystalItem.create(crystal -> crystal.setProperties(new CapacityCrystalProperties())));
            items.add((Object)VaultCrystalItem.create(crystal -> {
                crystal.setLayout(new ClassicInfiniteCrystalLayout(1));
                crystal.setProperties(new CapacityCrystalProperties());
            }));
            items.add((Object)VaultCrystalItem.create(crystal -> {
                crystal.setModel(new RawCrystalModel());
                crystal.setObjective(new EmptyCrystalObjective());
                crystal.setTheme(new PoolCrystalTheme(VaultMod.id("raw")));
                crystal.setProperties(new CapacityCrystalProperties());
            }));
            items.add((Object)VaultCrystalItem.create(crystal -> {
                crystal.setObjective(new ParadoxCrystalObjective(ParadoxObjective.Type.BUILD));
                crystal.setLayout(new ParadoxCrystalLayout());
                crystal.setModifiers(new ParadoxCrystalModifiers());
                crystal.setProperties(new CapacityCrystalProperties().setVolume(0).setUnmodifiable(true));
            }));
            items.add((Object)VaultCrystalItem.create(crystal -> {
                crystal.setObjective(new ParadoxCrystalObjective(ParadoxObjective.Type.RUN));
                crystal.setLayout(new ParadoxCrystalLayout());
                crystal.setModifiers(new ParadoxCrystalModifiers());
                crystal.setProperties(new CapacityCrystalProperties().setVolume(0).setUnmodifiable(true));
            }));
            items.add((Object)VaultCrystalItem.create(crystal -> {
                crystal.setObjective(new PersonalCrystalObjective());
                crystal.setLayout(new PersonalCrystalLayout());
                crystal.setModifiers(new PersonalCrystalModifiers());
                crystal.setTheme(new ValueCrystalTheme(VaultMod.id("classic_vault_plastic")));
                crystal.setProperties(new CapacityCrystalProperties().setVolume(0).setUnmodifiable(true));
            }));
            items.add((Object)VaultCrystalItem.create(crystal -> {
                crystal.setObjective(new HeraldCrystalObjective());
                crystal.setTheme(new ValueCrystalTheme(VaultMod.id("classic_vault_herald")));
                crystal.setLayout(new HeraldCrystalLayout());
                crystal.getModifiers().setRandomModifiers(false);
                crystal.setProperties(new CapacityCrystalProperties().setVolume(0).setLevel(100).setUnmodifiable(true));
            }));
            items.add((Object)VaultCrystalItem.create(crystal -> {
                crystal.setProperties(new CapacityCrystalProperties());
                crystal.setObjective(new BingoCrystalObjective());
            }));
            items.add((Object)VaultCrystalItem.create(crystal -> {
                crystal.setProperties(new CapacityCrystalProperties());
                crystal.setTheme(new PoolCrystalTheme(VaultMod.id("base_raid")));
                crystal.setObjective(new RaidCrystalObjective());
                crystal.setLayout(new RaidCrystalLayout());
                crystal.getModifiers().setRandomModifiers(false);
                crystal.setProperties(new CapacityCrystalProperties().setVolume(0).setUnmodifiable(true));
            }));
            items.add((Object)VaultCrystalItem.create(crystal -> {
                crystal.setProperties(new CapacityCrystalProperties());
                crystal.setTheme(new PoolCrystalTheme(VaultMod.id("infinite_raid")));
                crystal.setObjective(new RaidCrystalObjective());
                crystal.setLayout(new RaidCrystalLayout());
                crystal.getModifiers().setRandomModifiers(false);
                crystal.setProperties(new CapacityCrystalProperties().setVolume(0).setUnmodifiable(true));
            }));
        }
    }

    public static ItemStack create(Consumer<CrystalData> action) {
        return VaultCrystalItem.create(new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL), action);
    }

    public static ItemStack create(ItemStack base, Consumer<CrystalData> action) {
        ItemStack stack = base.m_41777_();
        CrystalData crystal = CrystalData.read(stack);
        action.accept(crystal);
        crystal.write(stack);
        return stack;
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = super.getShareTag(stack);
        if (nbt == null) {
            return null;
        }
        nbt = nbt.m_6426_();
        nbt.m_128473_(KEY_SCHEDULED_TASKS);
        return nbt;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_ || context.m_43723_() == null) {
            return InteractionResult.SUCCESS;
        }
        CrystalData data = CrystalData.read(context.m_43722_());
        BlockPos pos = context.m_8083_();
        if (this.createPortal(context.m_43725_(), pos, context.m_43719_(), data, true) && data.onPlaced(context)) {
            this.createPortal(context.m_43725_(), pos, context.m_43719_(), data, false);
            context.m_43725_().m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSounds.VAULT_PORTAL_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            MutableComponent playerName = context.m_43723_().m_5446_().m_6881_();
            playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
            String suffix = " opened a Vault!";
            TextComponent suffixComponent = new TextComponent(suffix);
            context.m_43725_().m_142572_().m_6846_().m_11264_((Component)new TextComponent("").m_7220_((Component)playerName).m_7220_((Component)suffixComponent), ChatType.CHAT, context.m_43723_().m_142081_());
            context.m_43722_().m_41774_(1);
            StatsManager.increment("vaults_opened", 1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    private boolean createPortal(Level world, BlockPos pos, Direction facing, CrystalData data, boolean simulate) {
        Optional<VaultPortalSize> optional = VaultPortalSize.getPortalSize((LevelAccessor)world, pos.m_142300_(facing), Direction.Axis.X, VaultPortalBlock.FRAME);
        if (optional.isPresent()) {
            if (!simulate) {
                VaultPortalSize portal = optional.get();
                BlockState state = (BlockState)ModBlocks.VAULT_PORTAL.m_49966_().m_61124_((Property)VaultPortalBlock.f_54904_, (Comparable)portal.getAxis());
                portal.placePortalBlocks(blockPos -> {
                    world.m_7731_(blockPos, state, 3);
                    BlockEntity patt12544$temp = world.m_7702_(blockPos);
                    if (patt12544$temp instanceof VaultPortalTileEntity) {
                        VaultPortalTileEntity entity = (VaultPortalTileEntity)patt12544$temp;
                        entity.setCrystalData(data.copy());
                    }
                });
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (ModConfigs.isInitialized()) {
            CrystalData.run(stack, data -> data.addText(tooltip, tooltip.size(), flag, ClientScheduler.INSTANCE.getTick()));
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        consumer.accept(new ModelResourceLocation("the_vault:crystal/core/rainbow#inventory"));
        consumer.accept(new ModelResourceLocation("the_vault:crystal/core/raw#inventory"));
        consumer.accept(new ModelResourceLocation("the_vault:crystal/core/chaos#inventory"));
        consumer.accept(new ModelResourceLocation("the_vault:crystal/core/grayscale#inventory"));
        consumer.accept(new ModelResourceLocation("the_vault:crystal/augment/core#inventory"));
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return CrystalRenderer.INSTANCE;
            }
        });
    }

    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (this.hasScheduledTasks(itemStack)) {
                this.executeScheduledTasks(serverPlayer, itemStack);
                this.clearScheduledTasks(itemStack);
            }
        }
        CrystalData.run(itemStack, data -> data.onInventoryTick(world, entity, itemSlot, isSelected));
        super.m_6883_(itemStack, world, entity, itemSlot, isSelected);
    }

    public static void scheduleTask(IScheduledTask task, ItemStack itemStack) {
        if (task instanceof NoOpTask) {
            return;
        }
        CompoundTag nbt = itemStack.m_41784_();
        CompoundTag scheduledTasks = nbt.m_128469_(KEY_SCHEDULED_TASKS);
        scheduledTasks.m_128365_(task.getId(), (Tag)task.serializeNBT());
        nbt.m_128365_(KEY_SCHEDULED_TASKS, (Tag)scheduledTasks);
    }

    private boolean hasScheduledTasks(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        return nbt.m_128441_(KEY_SCHEDULED_TASKS) && nbt.m_128469_(KEY_SCHEDULED_TASKS).m_128440_() > 0;
    }

    private void clearScheduledTasks(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        nbt.m_128473_(KEY_SCHEDULED_TASKS);
    }

    private void executeScheduledTasks(ServerPlayer serverPlayer, ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        CompoundTag scheduledTasks = nbt.m_128469_(KEY_SCHEDULED_TASKS);
        for (String key : scheduledTasks.m_128431_()) {
            IScheduledTaskDeserializer deserializer = SCHEDULED_TASK_DESERIALIZER_MAP.get(key);
            if (deserializer == null) {
                throw new IllegalStateException("Missing scheduled task deserializer registration for key [%s]".formatted(key));
            }
            deserializer.deserialize(scheduledTasks.m_128469_(key)).execute(serverPlayer, itemStack, CrystalData.read(itemStack));
        }
        nbt.m_128473_(KEY_SCHEDULED_TASKS);
    }

    private static class NoOpTask
    implements IScheduledTask {
        public static final NoOpTask INSTANCE = new NoOpTask();

        private NoOpTask() {
        }

        @Override
        public String getId() {
            return "noop";
        }

        @Override
        public void execute(ServerPlayer player, ItemStack itemStack, CrystalData data) {
        }

        @Override
        public CompoundTag serializeNBT() {
            return IScheduledTask.super.serializeNBT();
        }

        public static NoOpTask deserializeNBT(CompoundTag nbt) {
            return INSTANCE;
        }
    }

    public static interface IScheduledTask {
        public static final CompoundTag EMPTY_COMPOUND_TAG = new CompoundTag();

        public String getId();

        public void execute(ServerPlayer var1, ItemStack var2, CrystalData var3);

        default public CompoundTag serializeNBT() {
            return EMPTY_COMPOUND_TAG;
        }
    }

    @FunctionalInterface
    public static interface IScheduledTaskDeserializer {
        public IScheduledTask deserialize(CompoundTag var1);
    }

    public record CloneTask(boolean success) implements IScheduledTask
    {
        public static final String ID = "clone";
        private static final String KEY_SUCCESS = "success";
        public static final String CLONED = "Cloned";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack itemStack, CrystalData data) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = IScheduledTask.super.serializeNBT();
            nbt.m_128379_(KEY_SUCCESS, this.success);
            return nbt;
        }

        public static CloneTask deserializeNBT(CompoundTag nbt) {
            return new CloneTask(nbt.m_128471_(KEY_SUCCESS));
        }
    }

    public record EchoTask(int amount) implements IScheduledTask
    {
        public static final String ID = "echo";
        private static final String KEY_AMOUNT = "amount";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack itemStack, CrystalData data) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = IScheduledTask.super.serializeNBT();
            nbt.m_128405_(KEY_AMOUNT, this.amount);
            return nbt;
        }

        public static EchoTask deserializeNBT(CompoundTag nbt) {
            return new EchoTask(nbt.m_128451_(KEY_AMOUNT));
        }
    }

    public static class AddClarityTask
    implements IScheduledTask {
        public static final AddClarityTask INSTANCE = new AddClarityTask();
        public static final String ID = "addClarity";

        private AddClarityTask() {
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack stack, CrystalData data) {
            if (!data.getModifiers().hasClarity()) {
                data.getModifiers().setClarity(true);
                data.write(stack);
            }
        }

        public static AddClarityTask deserializeNBT(CompoundTag nbt) {
            return INSTANCE;
        }
    }

    public static class RemoveRandomNegativeModifierTask
    implements IScheduledTask {
        public static final RemoveRandomNegativeModifierTask INSTANCE = new RemoveRandomNegativeModifierTask();
        public static final String ID = "removeRandomNegativeModifier";

        private RemoveRandomNegativeModifierTask() {
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack stack, CrystalData data) {
            Iterator<VaultModifierStack> it = data.getModifiers().iterator();
            while (it.hasNext()) {
                VaultModifierStack modifier = it.next();
                if (!modifier.getModifier().getId().equals((Object)NEGATIVE_MODIFIER_POOL_NAME)) continue;
                modifier.shrink(1);
                if (modifier.isEmpty()) {
                    it.remove();
                }
                data.write(stack);
                return;
            }
        }

        public static RemoveRandomNegativeModifierTask deserializeNBT(CompoundTag nbt) {
            return INSTANCE;
        }
    }

    public static class RemoveRandomCurseTask
    implements IScheduledTask {
        public static final RemoveRandomCurseTask INSTANCE = new RemoveRandomCurseTask();
        public static final String ID = "removeRandomCurse";

        private RemoveRandomCurseTask() {
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack stack, CrystalData data) {
            data.getModifiers().removeRandomCurse();
            data.write(stack);
        }

        public static RemoveRandomCurseTask deserializeNBT(CompoundTag nbt) {
            return INSTANCE;
        }
    }

    public record AddModifiersTask(ResourceLocation pool, int count) implements IScheduledTask
    {
        public static final String ID = "addCurses";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack stack, CrystalData data) {
            Integer level = data.getProperties().getLevel().orElse(null);
            if (level == null) {
                return;
            }
            ModConfigs.VAULT_MODIFIER_POOLS.getRandom(this.pool, level, JavaRandom.ofNanoTime()).forEach(modifier -> data.getModifiers().add(VaultModifierStack.of(modifier)));
            data.write(stack);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = IScheduledTask.super.serializeNBT();
            nbt.m_128359_("pool", this.pool.toString());
            nbt.m_128405_("count", this.count);
            return nbt;
        }

        public static AddModifiersTask deserializeNBT(CompoundTag nbt) {
            return new AddModifiersTask(new ResourceLocation(nbt.m_128461_("pool")), nbt.m_128441_("count") ? nbt.m_128451_("count") : 1);
        }
    }

    public static class ExhaustTask
    implements IScheduledTask {
        public static final ExhaustTask INSTANCE = new ExhaustTask();
        public static final String ID = "exhaust";

        private ExhaustTask() {
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack stack, CrystalData data) {
            if (!data.getProperties().isUnmodifiable()) {
                data.getProperties().setUnmodifiable(true);
                data.write(stack);
            }
        }

        public static ExhaustTask deserializeNBT(CompoundTag nbt) {
            return INSTANCE;
        }
    }
}

