/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.layout;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.objective.ArchitectObjective;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.layout.ArchitectRoomEntry;
import iskallia.vault.core.world.generator.layout.ArchitectVaultLayout;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class ArchitectCrystalLayout
extends CrystalLayout {
    private Integer tunnelSpan;
    private ArchitectRoomEntry.List entries = new ArchitectRoomEntry.List();
    private Float completion;

    public ArchitectCrystalLayout() {
    }

    public ArchitectCrystalLayout(int tunnelSpan, Collection<ArchitectRoomEntry> entries) {
        this.tunnelSpan = tunnelSpan;
        this.entries.addAll(entries);
    }

    public ArchitectCrystalLayout add(ArchitectRoomEntry entry) {
        for (ArchitectRoomEntry e : this.entries) {
            e.mergeWith(entry);
        }
        if (entry.get(ArchitectRoomEntry.COUNT) > 0) {
            this.entries.add(entry);
        }
        return this;
    }

    public boolean addCompletion(float completion) {
        if (this.completion == null) {
            return false;
        }
        this.completion = Float.valueOf(this.completion.floatValue() + completion);
        return true;
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        if (!vault.has(Vault.WORLD)) {
            return;
        }
        if (this.tunnelSpan != null && this.completion != null) {
            vault.get(Vault.WORLD).ifPresent(WorldManager.GENERATOR, generator -> {
                if (!(generator instanceof GridGenerator)) {
                    return;
                }
                GridGenerator grid = (GridGenerator)generator;
                grid.set(GridGenerator.LAYOUT, new ArchitectVaultLayout(this.tunnelSpan, this.entries, this.completion.floatValue()));
            });
        } else {
            vault.get(Vault.OBJECTIVES).add(ArchitectObjective.create(this.entries));
        }
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        if (this.completion != null) {
            tooltip.add((Component)new TextComponent("Layout: ").m_7220_((Component)new TextComponent("Architect").m_130948_(Style.f_131099_.m_178520_(4766456)).m_7220_((Component)new TextComponent(" | %.1f%%".formatted(Float.valueOf(Math.min(this.completion.floatValue(), 1.0f) * 100.0f))).m_130940_(ChatFormatting.GRAY))));
        }
        for (ArchitectRoomEntry entry : this.entries) {
            int count = entry.get(ArchitectRoomEntry.COUNT);
            String roomStr = entry.getName().getString().endsWith("Room") ? "" : (count > 1 ? "Rooms" : "Room");
            MutableComponent txt = new TextComponent(" \u2022 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(count)).m_130940_(ChatFormatting.GRAY)).m_130946_(" ").m_7220_(entry.getName()).m_7220_((Component)new TextComponent(" " + roomStr).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)txt);
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        if (this.tunnelSpan != null) {
            nbt.m_128405_("tunnel_span", this.tunnelSpan.intValue());
        }
        ListTag list = new ListTag();
        for (ArchitectRoomEntry entry : this.entries) {
            list.add((Object)entry.serializeNBT());
        }
        nbt.m_128365_("entries", (Tag)list);
        if (this.completion != null) {
            nbt.m_128350_("completion", this.completion.floatValue());
        }
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.tunnelSpan = nbt.m_128441_("tunnel_span") ? Integer.valueOf(nbt.m_128451_("tunnel_span")) : null;
        this.entries.clear();
        ListTag list = nbt.m_128437_("entries", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.entries.add(ArchitectRoomEntry.fromNBT(list.m_128728_(i)));
        }
        this.completion = nbt.m_128441_("completion") ? Float.valueOf(nbt.m_128457_("completion")) : null;
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        if (this.tunnelSpan != null) {
            json.addProperty("tunnel_span", (Number)this.tunnelSpan);
        }
        JsonArray list = new JsonArray();
        for (ArchitectRoomEntry entry : this.entries) {
            list.add((JsonElement)entry.serializeJson());
        }
        json.add("entries", (JsonElement)list);
        if (this.completion != null) {
            json.addProperty("completion", (Number)this.completion);
        }
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.tunnelSpan = json.has("tunnel_span") ? Integer.valueOf(json.get("tunnel_span").getAsInt()) : null;
        this.entries.clear();
        if (json.has("entries")) {
            JsonArray list = json.getAsJsonArray("entries");
            for (JsonElement element : list) {
                this.entries.add(ArchitectRoomEntry.fromJson(element.getAsJsonObject()));
            }
        }
        this.completion = json.has("completion") ? Float.valueOf(json.get("completion").getAsFloat()) : null;
    }
}

