/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.layout;

import com.google.gson.JsonObject;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.layout.ClassicInfiniteLayout;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class ClassicInfiniteCrystalLayout
extends CrystalLayout {
    protected int tunnelSpan;

    public ClassicInfiniteCrystalLayout() {
    }

    public ClassicInfiniteCrystalLayout(int tunnelSpan) {
        this.tunnelSpan = tunnelSpan;
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        vault.getOptional(Vault.WORLD).map(world -> world.get(WorldManager.GENERATOR)).ifPresent(generator -> {
            if (generator instanceof GridGenerator) {
                GridGenerator grid = (GridGenerator)generator;
                grid.set(GridGenerator.LAYOUT, new ClassicInfiniteLayout(this.tunnelSpan));
            }
        });
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Layout: ").m_7220_((Component)new TextComponent("Infinite").m_130940_(ChatFormatting.RED)));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("tunnel_span", this.tunnelSpan);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.tunnelSpan = nbt.m_128451_("tunnel_span");
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        json.addProperty("tunnel_span", (Number)this.tunnelSpan);
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.tunnelSpan = json.get("tunnel_span").getAsInt();
    }
}

