/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.layout;

import com.google.gson.JsonObject;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.layout.ClassicSpiralLayout;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Rotation;

public class ClassicSpiralCrystalLayout
extends ClassicInfiniteCrystalLayout {
    protected int halfLength;
    protected Rotation rotation;

    public ClassicSpiralCrystalLayout() {
    }

    public ClassicSpiralCrystalLayout(int tunnelSpan, int halfLength, Rotation rotation) {
        super(tunnelSpan);
        this.halfLength = halfLength;
        this.rotation = rotation;
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        vault.getOptional(Vault.WORLD).map(world -> world.get(WorldManager.GENERATOR)).ifPresent(generator -> {
            if (generator instanceof GridGenerator) {
                GridGenerator grid = (GridGenerator)generator;
                grid.set(GridGenerator.LAYOUT, new ClassicSpiralLayout(this.tunnelSpan, this.halfLength, this.rotation));
            }
        });
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Layout: ").m_7220_((Component)new TextComponent("Spiral").m_130940_(ChatFormatting.BLUE)));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            nbt.m_128405_("half_length", this.halfLength);
            nbt.m_128359_("rotation", this.rotation.name());
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.halfLength = nbt.m_128451_("half_length");
        this.rotation = Enum.valueOf(Rotation.class, nbt.m_128461_("rotation"));
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            json.addProperty("half_length", (Number)this.halfLength);
            json.addProperty("rotation", this.rotation.name());
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.halfLength = json.get("half_length").getAsInt();
        this.rotation = (Rotation)Rotation.valueOf(Rotation.class, (String)json.get("rotation").getAsString());
    }
}

