/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.layout;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.CrystalEntry;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.layout.NullCrystalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class CompoundCrystalLayout
extends CrystalLayout {
    protected List<CrystalLayout> children;

    public CompoundCrystalLayout() {
        this.children = new ArrayList<CrystalLayout>();
    }

    public CompoundCrystalLayout(List<CrystalLayout> children) {
        this.children = children;
    }

    @Override
    public Collection<CrystalEntry> getChildren() {
        return this.children.stream().map(child -> child).toList();
    }

    public static <T> T get(CrystalLayout layout, Class<T> type) {
        List<CrystalLayout> children = CompoundCrystalLayout.flatten((CrystalLayout[])new CrystalLayout[]{layout}).children;
        for (CrystalLayout child : children) {
            if (!type.isAssignableFrom(child.getClass())) continue;
            return (T)child;
        }
        return null;
    }

    public static CompoundCrystalLayout flatten(CrystalLayout ... layouts) {
        ArrayList<CrystalLayout> children = new ArrayList<CrystalLayout>();
        for (CrystalLayout layout : layouts) {
            if (layout instanceof CompoundCrystalLayout) {
                children.addAll(((CompoundCrystalLayout)layout).children);
                continue;
            }
            if (layout == null) continue;
            children.add(layout);
        }
        return new CompoundCrystalLayout(children);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        for (CrystalLayout child : this.children) {
            if (child == NullCrystalLayout.INSTANCE) {
                CompoundTag element = new CompoundTag();
                element.m_128359_("type", "null");
                list.add((Object)element);
                continue;
            }
            CrystalData.LAYOUT.writeNbt(child).ifPresent(arg_0 -> list.add(arg_0));
        }
        nbt.m_128365_("children", (Tag)list);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.children = new ArrayList<CrystalLayout>();
        ListTag list = nbt.m_128437_("children", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag element = list.m_128728_(i);
            if (element.m_128441_("type") && element.m_128461_("type").equals("null")) {
                this.children.add(NullCrystalLayout.INSTANCE);
                continue;
            }
            this.children.add((CrystalLayout)CrystalData.LAYOUT.readNbt((Tag)element).orElseThrow());
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        for (CrystalLayout child : this.children) {
            if (child == NullCrystalLayout.INSTANCE) {
                JsonObject element = new JsonObject();
                element.addProperty("type", "null");
                array.add((JsonElement)element);
                continue;
            }
            CrystalData.LAYOUT.writeJson(child).ifPresent(arg_0 -> ((JsonArray)array).add(arg_0));
        }
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.children = new ArrayList<CrystalLayout>();
        JsonArray array = json.getAsJsonArray("children");
        for (int i = 0; i < array.size(); ++i) {
            JsonObject element = array.get(i).getAsJsonObject();
            if (element.has("type") && element.get("type").getAsString().equals("null")) {
                this.children.add(NullCrystalLayout.INSTANCE);
                continue;
            }
            this.children.add((CrystalLayout)CrystalData.LAYOUT.readJson((JsonElement)element).orElseThrow());
        }
    }
}

