/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.modifiers;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.modifier.PlayerInventoryRestoreModifier;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.CrystalEntry;
import iskallia.vault.item.crystal.properties.CrystalProperties;
import iskallia.vault.item.crystal.properties.InstabilityCrystalProperties;
import iskallia.vault.world.VaultMode;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public abstract class CrystalModifiers
extends CrystalEntry
implements Iterable<VaultModifierStack>,
ISerializable<CompoundTag, JsonObject> {
    public abstract List<VaultModifierStack> getList();

    @Override
    @NotNull
    public Iterator<VaultModifierStack> iterator() {
        return this.getList().iterator();
    }

    public abstract boolean hasRandomModifiers();

    public abstract boolean hasClarity();

    public abstract void setRandomModifiers(boolean var1);

    public abstract void setClarity(boolean var1);

    @Override
    public void configure(Vault vault, RandomSource random) {
        VaultModifier modifier;
        boolean casual;
        boolean bl = casual = ((VaultMode.GameRuleValue)ServerLifecycleHooks.getCurrentServer().m_129900_().m_46170_(ModGameRules.MODE)).get() == VaultMode.CASUAL;
        if (VaultUtils.isRoyaleVault(vault)) {
            casual = false;
        }
        for (VaultModifierStack stack : this) {
            vault.ifPresent(Vault.MODIFIERS, m -> m.addModifier(stack.getModifier(), stack.getSize(), true, random));
        }
        if (casual && (modifier = VaultModifierRegistry.getOrDefault(VaultMod.id("casual"), null)) != null) {
            vault.ifPresent(Vault.MODIFIERS, m -> m.addModifier(modifier, 1, false, random));
        }
        if (this.hasRandomModifiers()) {
            List<VaultModifier<?>> modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(VaultMod.id("default"), vault.get(Vault.LEVEL).get(), random);
            for (VaultModifier<?> modifier2 : modifiers) {
                if (casual && modifier2 instanceof PlayerInventoryRestoreModifier) continue;
                vault.ifPresent(Vault.MODIFIERS, m -> m.addModifier(modifier2, 1, true, random));
            }
        }
    }

    protected boolean canAdd(CrystalData crystal, VaultModifierStack modifierStack) {
        return !crystal.getProperties().isUnmodifiable();
    }

    public boolean addByCrafting(CrystalData crystal, List<VaultModifierStack> modifierStackList, boolean simulate) {
        for (VaultModifierStack modifierStack : modifierStackList) {
            if (this.addByCrafting(crystal, modifierStack, true, true)) continue;
            return false;
        }
        if (!simulate) {
            for (VaultModifierStack modifierStack : modifierStackList) {
                this.addByCrafting(crystal, modifierStack, true, false);
            }
        }
        return true;
    }

    public boolean addByCrafting(CrystalData crystal, VaultModifierStack modifierStack, boolean preventsRandomModifiers, boolean simulate) {
        if (!this.canAdd(crystal, modifierStack)) {
            return false;
        }
        if (!simulate) {
            CrystalProperties crystalProperties;
            if (preventsRandomModifiers) {
                this.setRandomModifiers(false);
            }
            if ((crystalProperties = crystal.getProperties()) instanceof InstabilityCrystalProperties) {
                InstabilityCrystalProperties properties = (InstabilityCrystalProperties)crystalProperties;
                properties.setInstability(properties.getInstability() + ModConfigs.VAULT_CRYSTAL.MODIFIER_STABILITY.instabilityPerCraft);
            }
            this.add(modifierStack);
        }
        return true;
    }

    public void add(VaultModifierStack modifierStack) {
        if (modifierStack.isEmpty()) {
            VaultMod.LOGGER.error("Attempted to add Empty modifier to crystal. If you see this stacktrace, please share it with the devs.", (Throwable)new Exception());
            return;
        }
        boolean found = false;
        ResourceLocation modifierId = modifierStack.getModifierId();
        for (VaultModifierStack modifier : this.getList()) {
            if (!modifier.getModifierId().equals((Object)modifierId)) continue;
            modifier.grow(modifierStack.getSize());
            found = true;
            break;
        }
        if (!found) {
            this.getList().add(modifierStack.copy());
        }
        this.sortModifiers();
    }

    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    public int getCurseCount() {
        return this.getList().stream().filter(vaultModifierStack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isCurse(vaultModifierStack.getModifierId())).map(VaultModifierStack::getSize).reduce(0, Integer::sum);
    }

    public boolean hasCurse() {
        return this.getCurseCount() > 0;
    }

    public boolean removeAllCurses() {
        return this.getList().removeIf(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isCurse(stack.getModifierId()));
    }

    public boolean removeRandomCurse() {
        List<VaultModifierStack> curseList = this.getList().stream().filter(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isCurse(stack.getModifierId())).toList();
        if (curseList.isEmpty()) {
            return false;
        }
        JavaRandom random = JavaRandom.ofNanoTime();
        VaultModifierStack modifierStack = curseList.get(random.nextInt(curseList.size()));
        if (modifierStack.shrink(1).isEmpty()) {
            this.getList().remove(modifierStack);
        }
        return true;
    }

    public void sortModifiers() {
        this.getList().sort(Comparator.comparing(VaultModifierStack::getSize).reversed());
    }

    protected void addNonCatalystModifierInformation(Predicate<VaultModifierStack> filter, Component headerComponent, List<Component> tooltip) {
        List<VaultModifierStack> modifierList = this.getList().stream().filter(filter).toList();
        if (modifierList.isEmpty()) {
            return;
        }
        tooltip.add(headerComponent);
        for (VaultModifierStack modifierStack : modifierList) {
            String descriptionTxt;
            VaultModifier<?> vaultModifier = modifierStack.getModifier();
            TextComponent modifierName = new TextComponent(vaultModifier.getDisplayNameFormatted(modifierStack.getSize()));
            modifierName.m_6270_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor()));
            if (modifierStack.getSize() > 1) {
                MutableComponent stackSize = new TextComponent("%dx".formatted(modifierStack.getSize())).m_130940_(ChatFormatting.GRAY);
                tooltip.add((Component)new TextComponent("  ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)stackSize).m_130946_(" ").m_7220_((Component)modifierName));
            } else {
                tooltip.add((Component)new TextComponent("  ").m_7220_((Component)modifierName));
            }
            if (!Screen.m_96638_() || (descriptionTxt = vaultModifier.getDisplayDescriptionFormatted(modifierStack.getSize())).isEmpty()) continue;
            MutableComponent description = new TextComponent("  " + descriptionTxt).m_130940_(ChatFormatting.DARK_GRAY);
            tooltip.add((Component)description);
        }
    }

    protected void addCatalystModifierInformation(Predicate<VaultModifierStack> filter, Component headerComponent, List<Component> tooltip) {
        List<VaultModifierStack> modifierList = this.getList().stream().filter(filter).toList();
        if (modifierList.isEmpty()) {
            return;
        }
        tooltip.add(headerComponent);
        for (VaultModifierStack modifierStack : modifierList) {
            VaultModifier<?> vaultModifier = modifierStack.getModifier();
            TextComponent modifierName = new TextComponent(vaultModifier.getDisplayNameFormatted(modifierStack.getSize()));
            modifierName.m_6270_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor()));
            MutableComponent stackSize = new TextComponent("%dx".formatted(modifierStack.getSize())).m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)new TextComponent("  ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)stackSize).m_130946_(" ").m_7220_((Component)modifierName));
            if (!Screen.m_96638_()) continue;
            MutableComponent description = new TextComponent("  " + vaultModifier.getDisplayDescriptionFormatted(modifierStack.getSize())).m_130940_(ChatFormatting.DARK_GRAY);
            tooltip.add((Component)description);
        }
    }
}

