/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.modifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.modifiers.CrystalModifiers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class DefaultCrystalModifiers
extends CrystalModifiers {
    private final List<VaultModifierStack> list = new ArrayList<VaultModifierStack>();
    private boolean randomModifiers = true;
    private boolean clarity = false;

    @Override
    public List<VaultModifierStack> getList() {
        return this.list;
    }

    @Override
    @NotNull
    public Iterator<VaultModifierStack> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean hasRandomModifiers() {
        return this.randomModifiers;
    }

    @Override
    public boolean hasClarity() {
        return this.clarity;
    }

    @Override
    public void setRandomModifiers(boolean randomModifiers) {
        this.randomModifiers = randomModifiers;
    }

    @Override
    public void setClarity(boolean clarity) {
        this.clarity = clarity;
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        int curseCount;
        if (this.clarity) {
            tooltip.add((Component)new TextComponent("Clarity").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)4973509))));
            if (Screen.m_96638_()) {
                MutableComponent description = new TextComponent("  All curses on this crystal are revealed.").m_130940_(ChatFormatting.DARK_GRAY);
                tooltip.add((Component)description);
            }
        }
        if ((curseCount = this.getCurseCount()) > 0) {
            Style style = Style.f_131099_.m_131148_(ModConfigs.VAULT_CRYSTAL.MODIFIER_STABILITY.curseColor);
            if (this.clarity) {
                this.addCatalystModifierInformation(vaultModifierStack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isCurse(vaultModifierStack.getModifierId()), (Component)new TextComponent("Cursed").m_130948_(style), tooltip);
            } else {
                MutableComponent component = new TextComponent("Cursed ").m_130948_(style);
                tooltip.add((Component)component.m_130946_("\u2620".repeat(curseCount)));
                if (Screen.m_96638_()) {
                    MutableComponent description = new TextComponent("  Each curse shortens the vault by 2.5 minutes").m_130940_(ChatFormatting.DARK_GRAY);
                    tooltip.add((Component)description);
                }
            }
        }
        this.addCatalystModifierInformation(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isGood(stack.getModifierId()), (Component)new TextComponent("Positive Modifiers").m_130940_(ChatFormatting.GREEN), tooltip);
        this.addCatalystModifierInformation(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isBad(stack.getModifierId()), (Component)new TextComponent("Negative Modifiers").m_130940_(ChatFormatting.RED), tooltip);
        this.addNonCatalystModifierInformation(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isUnlisted(stack.getModifierId()), (Component)new TextComponent("Other Modifiers").m_130940_(ChatFormatting.WHITE), tooltip);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        for (VaultModifierStack stack : this.list) {
            list.add((Object)stack.serializeNBT());
        }
        nbt.m_128365_("List", (Tag)list);
        Adapters.BOOLEAN.writeNbt(this.randomModifiers).ifPresent(tag -> nbt.m_128365_("RandomModifiers", tag));
        Adapters.BOOLEAN.writeNbt(this.clarity).ifPresent(tag -> nbt.m_128365_("Clarity", tag));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.list.clear();
        ListTag list = nbt.m_128437_("List", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.list.add(VaultModifierStack.of(list.m_128728_(i)));
        }
        this.randomModifiers = Adapters.BOOLEAN.readNbt(nbt.m_128423_("RandomModifiers")).orElse(true);
        this.clarity = Adapters.BOOLEAN.readNbt(nbt.m_128423_("Clarity")).orElse(false);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        for (VaultModifierStack stack : this.list) {
            JsonObject element = new JsonObject();
            element.addProperty("modifier", stack.getModifierId().toString());
            element.addProperty("count", (Number)stack.getSize());
            array.add((JsonElement)element);
        }
        json.add("list", (JsonElement)json);
        json.addProperty("random_modifiers", Boolean.valueOf(this.randomModifiers));
        json.addProperty("clarity", Boolean.valueOf(this.clarity));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        if (json.has("list")) {
            this.list.clear();
            for (JsonElement element : json.getAsJsonArray("list")) {
                JsonObject object = element.getAsJsonObject();
                this.list.add(VaultModifierStack.of(VaultModifierRegistry.get(new ResourceLocation(object.get("modifier").getAsString())), object.get("count").getAsInt()));
            }
        }
        if (json.has("random_modifiers")) {
            this.randomModifiers = json.get("random_modifiers").getAsBoolean();
        }
        if (json.has("clarity")) {
            this.clarity = json.get("clarity").getAsBoolean();
        }
    }
}

