/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.modifiers;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.InfusedCatalystItem;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.modifiers.CrystalModifiers;
import iskallia.vault.item.data.InscriptionData;
import iskallia.vault.world.data.PersonalVaultData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PersonalCrystalModifiers
extends CrystalModifiers {
    private UUID playerUuid;

    public void setPlayerUuid(UUID id) {
        this.playerUuid = id;
    }

    @Override
    public List<VaultModifierStack> getList() {
        LinkedHashMap counts = new LinkedHashMap();
        if (this.playerUuid == null) {
            return List.of();
        }
        PersonalVaultData.Entry entry = PersonalVaultData.getEntry(this.playerUuid);
        for (ItemStack catalyst : entry.getInfusedCatalysts()) {
            if (catalyst.m_41619_()) continue;
            for (ResourceLocation id : InfusedCatalystItem.getModifiers(catalyst)) {
                Object mod = VaultModifierRegistry.get(id);
                if (mod == null) continue;
                counts.merge(mod, 1, Integer::sum);
            }
        }
        for (ItemStack inscription : entry.getSlotItems().values()) {
            if (inscription.m_41619_()) continue;
            InscriptionData data = InscriptionData.from(inscription);
            for (ResourceLocation id : data.getModifiers()) {
                Object mod = VaultModifierRegistry.get(id);
                if (mod == null) continue;
                counts.merge(mod, 1, Integer::sum);
            }
        }
        return counts.entrySet().stream().sorted((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue())).map(e -> VaultModifierStack.of((VaultModifier)e.getKey(), (Integer)e.getValue())).toList();
    }

    @Override
    public boolean hasRandomModifiers() {
        return false;
    }

    @Override
    public boolean hasClarity() {
        return true;
    }

    @Override
    public void setRandomModifiers(boolean flag) {
    }

    @Override
    public void setClarity(boolean flag) {
    }

    @Override
    public boolean addByCrafting(CrystalData crystal, List<VaultModifierStack> stacks, boolean simulate) {
        return false;
    }

    @Override
    public boolean addByCrafting(CrystalData crystal, VaultModifierStack stack, boolean preventsRandom, boolean simulate) {
        return false;
    }

    @Override
    public void add(VaultModifierStack modifierStack) {
        super.add(modifierStack);
        PersonalVaultData.getEntry((UUID)this.playerUuid).changed = true;
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        Style good = Style.f_131099_.m_131140_(ChatFormatting.GREEN);
        Style bad = Style.f_131099_.m_131140_(ChatFormatting.RED);
        Style other = Style.f_131099_.m_131140_(ChatFormatting.WHITE);
        this.addCatalystModifierInformation(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isGood(stack.getModifierId()), (Component)new TextComponent("Positive").m_130948_(good), tooltip);
        this.addCatalystModifierInformation(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isBad(stack.getModifierId()), (Component)new TextComponent("Negative").m_130948_(bad), tooltip);
        this.addNonCatalystModifierInformation(stack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isUnlisted(stack.getModifierId()), (Component)new TextComponent("Other").m_130948_(other), tooltip);
    }

    @Override
    public void onInventoryTick(Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.playerUuid = player.m_142081_();
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.UUID.writeNbt(this.playerUuid).ifPresent(tag -> nbt.m_128365_("player_uuid", tag));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.playerUuid = Adapters.UUID.readNbt(nbt.m_128423_("player_uuid")).orElse(null);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.UUID.writeJson(this.playerUuid).ifPresent(uuid -> json.add("player_uuid", uuid));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.playerUuid = Adapters.UUID.readJson(json.get("player_uuid")).orElse(null);
    }
}

