/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.objective;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.AscensionObjective;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.modifiers.CrystalModifiers;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.render.ColorBlender;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class AscensionCrystalObjective
extends CrystalObjective {
    protected int stacks;
    protected String playerName;
    protected UUID playerUuid;
    protected Tag modifiers;

    public AscensionCrystalObjective() {
    }

    public AscensionCrystalObjective(int stacks, String playerName, UUID playerUuid, CrystalModifiers modifiers) {
        this.stacks = stacks;
        this.playerName = playerName;
        this.playerUuid = playerUuid;
        this.modifiers = CrystalData.MODIFIERS.writeNbt(modifiers).orElse(null);
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        vault.get(Vault.LISTENERS).get(Listeners.LOGIC).set(ClassicListenersLogic.MAX_PLAYERS, 1);
        vault.ifPresent(Vault.OBJECTIVES, objectives -> objectives.add(AscensionObjective.create(this.stacks, this.playerName, this.playerUuid, this.modifiers)));
    }

    @Override
    public Optional<Integer> getColor(float time) {
        ColorBlender blender = new ColorBlender(1.0f).add(0xC1FFFF, 60.0f).add(7535612, 60.0f).add(1699570, 60.0f);
        return Optional.of(blender.getColor(time));
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Ascension: "));
        if (this.playerUuid == null) {
            tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent(" \u2022 ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent("Player: ???").m_130940_(ChatFormatting.GRAY)));
        } else {
            tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent(" \u2022 ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent("Player: ")).m_7220_((Component)new TextComponent(this.playerName == null ? "Unknown" : this.playerName).m_130940_(ChatFormatting.YELLOW)));
        }
        tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent(" \u2022 ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent("Stacks: ")).m_7220_((Component)new TextComponent(String.valueOf(this.stacks)).m_130940_(ChatFormatting.AQUA)));
    }

    @Override
    public void onInventoryTick(Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.playerName = player.m_36316_().getName();
            this.playerUuid = player.m_36316_().getId();
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.INT.writeNbt(this.stacks).ifPresent(tag -> nbt.m_128365_("stack", tag));
        Adapters.UTF_8.writeNbt(this.playerName).ifPresent(tag -> nbt.m_128365_("player_name", tag));
        Adapters.UUID.writeNbt(this.playerUuid).ifPresent(tag -> nbt.m_128365_("player_uuid", tag));
        Adapters.GENERIC_NBT.writeNbt(this.modifiers).ifPresent(tag -> nbt.m_128365_("modifiers", tag));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.stacks = Adapters.INT.readNbt(nbt.m_128423_("stack")).orElse(0);
        this.playerName = Adapters.UTF_8.readNbt(nbt.m_128423_("player_name")).orElse(null);
        this.playerUuid = Adapters.UUID.readNbt(nbt.m_128423_("player_uuid")).orElse(null);
        this.modifiers = Adapters.GENERIC_NBT.readNbt(nbt.m_128423_("modifiers")).orElse(null);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.INT.writeJson(this.stacks).ifPresent(tag -> json.add("stack", tag));
        Adapters.UTF_8.writeJson(this.playerName).ifPresent(tag -> json.add("player_name", tag));
        Adapters.UUID.writeJson(this.playerUuid).ifPresent(tag -> json.add("player_uuid", tag));
        Adapters.GENERIC_NBT.writeJson(this.modifiers).ifPresent(tag -> json.add("modifiers", tag));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.stacks = Adapters.INT.readJson(json.get("stack")).orElse(0);
        this.playerName = Adapters.UTF_8.readJson(json.get("player_name")).orElse(null);
        this.playerUuid = Adapters.UUID.readJson(json.get("player_uuid")).orElse(null);
        this.modifiers = Adapters.GENERIC_NBT.readJson(json.get("modifiers")).orElse(null);
    }
}

