/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.objective;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.AwardCrateObjective;
import iskallia.vault.core.vault.objective.BailObjective;
import iskallia.vault.core.vault.objective.DeathObjective;
import iskallia.vault.core.vault.objective.GreedObjective;
import iskallia.vault.core.vault.objective.GreedPillarObjective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.objective.VictoryObjective;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.render.ColorBlender;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class GreedCrystalObjective
extends CrystalObjective {
    protected float objectiveProbability;
    protected int greedTier;

    public GreedCrystalObjective() {
    }

    public GreedCrystalObjective(float objectiveProbability, int greedTier) {
        this.objectiveProbability = objectiveProbability;
        this.greedTier = greedTier;
    }

    public void setGreedTier(int greedTier) {
        this.greedTier = greedTier;
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        int level = vault.get(Vault.LEVEL).get();
        vault.ifPresent(Vault.OBJECTIVES, objectives -> {
            ModConfigs.GREED.generate(VaultMod.id("default"), level).ifPresent(task -> objectives.add(GreedObjective.of(task, this.greedTier).add(GreedPillarObjective.of(this.objectiveProbability).add(AwardCrateObjective.ofConfig(VaultCrateBlock.Type.GREED, "greed", level, false)).add(VictoryObjective.of(300)))));
            objectives.add(BailObjective.create(true, ClassicPortalLogic.EXIT));
            objectives.add(DeathObjective.create(true));
            objectives.set(Objectives.KEY, CrystalData.OBJECTIVE.getType(this));
        });
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        int color = this.getColor(time).orElseThrow();
        tooltip.add((Component)new TextComponent("Objective: ").m_7220_((Component)new TextComponent("Greed").m_130948_(Style.f_131099_.m_178520_(color))));
        tooltip.add((Component)new TextComponent("  Greed Tier: ").m_130948_(Style.f_131099_.m_178520_(0xE0E0E0)).m_7220_((Component)new TextComponent(String.valueOf(this.greedTier)).m_130948_(Style.f_131099_.m_178520_(color))));
    }

    @Override
    public Optional<Integer> getColor(float time) {
        ColorBlender blender = new ColorBlender(1.0f).add(1499165, 60.0f).add(1499360, 60.0f).add(1470944, 60.0f).add(1499360, 60.0f);
        return Optional.of(blender.getColor(time));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.FLOAT.writeNbt(Float.valueOf(this.objectiveProbability)).ifPresent(tag -> nbt.m_128365_("objective_probability", tag));
        Adapters.INT.writeNbt(this.greedTier).ifPresent(tag -> nbt.m_128365_("greed_tier", tag));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.objectiveProbability = Adapters.FLOAT.readNbt(nbt.m_128423_("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
        this.greedTier = Adapters.INT.readNbt(nbt.m_128423_("greed_tier")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.FLOAT.writeJson(Float.valueOf(this.objectiveProbability)).ifPresent(tag -> json.add("objective_probability", tag));
        Adapters.INT.writeJson(this.greedTier).ifPresent(tag -> json.add("greed_tier", tag));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.objectiveProbability = Adapters.FLOAT.readJson(json.get("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
        this.greedTier = Adapters.INT.readJson(json.get("greed_tier")).orElse(0);
    }
}

