/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.objective;

import com.google.gson.JsonObject;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.objective.BailObjective;
import iskallia.vault.core.vault.objective.DeathObjective;
import iskallia.vault.core.vault.objective.FindExitObjective;
import iskallia.vault.core.vault.objective.HeraldObjective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.objective.VictoryObjective;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.player.ListenersLogic;
import iskallia.vault.core.vault.time.TickStopwatch;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.GameType;
import net.minecraftforge.server.ServerLifecycleHooks;

public class HeraldCrystalObjective
extends CrystalObjective {
    @Override
    public void configure(Vault vault, RandomSource random) {
        int level = ServerLifecycleHooks.getCurrentServer().m_129900_().m_46215_(ModGameRules.HERALD_MIN_LEVEL);
        vault.set(Vault.SEED, 0L);
        vault.set(Vault.CLOCK, new TickStopwatch());
        ListenersLogic listenersLogic = vault.get(Vault.LISTENERS).get(Listeners.LOGIC);
        if (listenersLogic instanceof ClassicListenersLogic) {
            ClassicListenersLogic classic = (ClassicListenersLogic)listenersLogic;
            classic.set(ClassicListenersLogic.GAME_MODE, GameType.ADVENTURE);
            classic.set(ClassicListenersLogic.MIN_LEVEL, level);
            classic.set(ClassicListenersLogic.ADDED_BONUS_TIME);
        }
        vault.get(Vault.WORLD).set(WorldManager.FACING, Direction.EAST);
        vault.ifPresent(Vault.OBJECTIVES, objectives -> {
            objectives.add(HeraldObjective.of().add(FindExitObjective.create(ClassicPortalLogic.EXIT)).add(VictoryObjective.empty()));
            objectives.add(BailObjective.create(true, ClassicPortalLogic.EXIT));
            objectives.add(DeathObjective.create(true));
            objectives.set(Objectives.KEY, CrystalData.OBJECTIVE.getType(this));
        });
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Objective: ").m_7220_((Component)new TextComponent("Defeat the Herald").m_130948_(Style.f_131099_.m_178520_(this.getColor(time).orElseThrow().intValue()))));
    }

    @Override
    public Optional<Integer> getColor(float time) {
        return Optional.of(0x8F7F77);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag());
    }

    @Override
    public void readNbt(CompoundTag nbt) {
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return Optional.of(new JsonObject());
    }

    @Override
    public void readJson(JsonObject json) {
    }
}

