/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.objective;

import com.google.gson.JsonObject;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.BailObjective;
import iskallia.vault.core.vault.objective.DeathObjective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.world.data.PersonalVaultData;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PersonalCrystalObjective
extends CrystalObjective {
    protected String playerName;
    protected UUID playerUuid;
    protected long expiry = -1L;

    @Override
    public void configure(Vault vault, RandomSource random) {
        vault.get(Vault.LISTENERS).get(Listeners.LOGIC).set(ClassicListenersLogic.MAX_PLAYERS, 1);
        vault.ifPresent(Vault.OBJECTIVES, objectives -> {
            objectives.add(BailObjective.create(true, ClassicPortalLogic.EXIT));
            objectives.add(DeathObjective.create(true));
            objectives.set(Objectives.KEY, CrystalData.OBJECTIVE.getType(this));
        });
        vault.ifPresent(Vault.CLOCK, clock -> {
            clock.set(TickClock.PAUSED);
            clock.remove(TickClock.VISIBLE);
        });
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Objective: ").m_7220_((Component)this.styleLetters("Personal Vault", time, 2.0f)));
        long ticksLeft = this.getCooldown() / 50L;
        MutableComponent cd = new TextComponent(ticksLeft < 0L ? "Ready" : UIHelper.formatTimeString((int)ticksLeft)).m_130940_(ChatFormatting.GRAY);
        tooltip.add((Component)new TextComponent(" \u2022 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent("Cooldown: ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)cd));
        MutableComponent player = new TextComponent(this.playerName == null ? "Unknown" : this.playerName).m_130940_(ChatFormatting.YELLOW);
        tooltip.add((Component)new TextComponent(" \u2022 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent("Player: ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)player));
    }

    private TextComponent styleLetters(String str, float time, float offset) {
        TextComponent text = new TextComponent("");
        int count = 0;
        for (char c : str.toCharArray()) {
            text.m_7220_((Component)new TextComponent(String.valueOf(c)).m_130948_(Style.f_131099_.m_178520_(this.getColor(time + (float)count * offset).orElse(0xFFFFFF).intValue())));
            if (c == ' ') continue;
            ++count;
        }
        return text;
    }

    @Override
    public Optional<Integer> getColor(float time) {
        return Optional.of(0xFFFFFF);
    }

    @Override
    public void onInventoryTick(Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.playerName = player.m_36316_().getName();
            this.playerUuid = player.m_36316_().getId();
        }
    }

    @Override
    public boolean onPlaced(UseOnContext context) {
        if (this.playerUuid == null || this.getCooldown() > 0L) {
            super.onPlaced(context);
            return false;
        }
        long unlockMs = ZonedDateTime.now().plusHours(20L).withZoneSameInstant(ZoneId.of("UTC")).toInstant().toEpochMilli();
        PersonalVaultData.Entry entry = PersonalVaultData.getEntry(this.playerUuid);
        entry.unlockTime = unlockMs;
        entry.changed = true;
        this.expiry = unlockMs;
        return super.onPlaced(context);
    }

    @Override
    public void onPortalTick(Level world, BlockPos pos, BlockState state) {
        if (this.isExpired()) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
        super.onPortalTick(world, pos, state);
    }

    public long getCooldown() {
        long now = ZonedDateTime.now().withZoneSameInstant(ZoneId.of("UTC")).toInstant().toEpochMilli();
        return PersonalVaultData.getEntry((UUID)this.playerUuid).unlockTime - now;
    }

    public boolean isExpired() {
        if (this.expiry <= 0L) {
            return false;
        }
        long now = ZonedDateTime.now().withZoneSameInstant(ZoneId.of("UTC")).toInstant().toEpochMilli();
        return now > this.expiry;
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.playerUuid = Adapters.UUID.readNbt(nbt.m_128423_("player_uuid")).orElse(null);
        this.playerName = Adapters.UTF_8.readNbt(nbt.m_128423_("player_name")).orElse(null);
        this.expiry = Adapters.LONG.readNbt(nbt.m_128423_("expiry")).orElse(-1L);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.UUID.writeNbt(this.playerUuid).ifPresent(t -> nbt.m_128365_("player_uuid", t));
        Adapters.UTF_8.writeNbt(this.playerName).ifPresent(t -> nbt.m_128365_("player_name", t));
        if (this.expiry > 0L) {
            Adapters.LONG.writeNbt(this.expiry).ifPresent(t -> nbt.m_128365_("expiry", t));
        }
        return Optional.of(nbt);
    }

    @Override
    public void readJson(JsonObject json) {
        this.playerUuid = Adapters.UUID.readJson(json.get("player_uuid")).orElse(null);
        this.playerName = Adapters.UTF_8.readJson(json.get("player_name")).orElse(null);
        this.expiry = Adapters.LONG.readJson(json.get("expiry")).orElse(-1L);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.UUID.writeJson(this.playerUuid).ifPresent(t -> json.add("player_uuid", t));
        Adapters.UTF_8.writeJson(this.playerName).ifPresent(t -> json.add("player_name", t));
        if (this.expiry > 0L) {
            Adapters.LONG.writeJson(this.expiry).ifPresent(t -> json.add("expiry", t));
        }
        return Optional.of(json);
    }
}

