/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.objective;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.BailObjective;
import iskallia.vault.core.vault.objective.DeathObjective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.objective.PvPObjective;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.player.ListenersLogic;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.render.ColorBlender;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class PvPCrystalObjective
extends CrystalObjective {
    protected int minLevel = 50;
    protected int maxPlayers = 8;

    public PvPCrystalObjective() {
    }

    public PvPCrystalObjective(int minLevel, int maxPlayers) {
        this.minLevel = minLevel;
        this.maxPlayers = maxPlayers;
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        int level = vault.get(Vault.LEVEL).get();
        ListenersLogic listenersLogic = vault.get(Vault.LISTENERS).get(Listeners.LOGIC);
        if (listenersLogic instanceof ClassicListenersLogic) {
            ClassicListenersLogic classic = (ClassicListenersLogic)listenersLogic;
            classic.set(ClassicListenersLogic.MIN_LEVEL, this.minLevel);
            classic.set(ClassicListenersLogic.MAX_PLAYERS, this.maxPlayers);
        }
        ModConfigs.VAULT_CRYSTAL.getRandomObjective(VaultMod.id("pvp"), vault.get(Vault.LEVEL).get(), random).ifPresent(objective -> objective.configure(vault, random));
        vault.ifPresent(Vault.OBJECTIVES, objectives -> {
            objectives.add(BailObjective.create(true, ClassicPortalLogic.EXIT));
            objectives.add(DeathObjective.create(true));
            objectives.add(PvPObjective.create());
            objectives.set(Objectives.KEY, CrystalData.OBJECTIVE.getType(this));
        });
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Objective: ").m_7220_((Component)new TextComponent("PvP").m_130948_(Style.f_131099_.m_178520_(this.getColor(time).orElseThrow().intValue()))));
    }

    @Override
    public Optional<Integer> getColor(float time) {
        ColorBlender blender = new ColorBlender(1.0f).add(0xFF4444, 60.0f).add(0xCC2222, 60.0f);
        return Optional.of(blender.getColor(time));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("min_level", this.minLevel);
        nbt.m_128405_("max_players", this.maxPlayers);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.minLevel = nbt.m_128451_("min_level");
        this.maxPlayers = nbt.m_128451_("max_players");
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        json.addProperty("min_level", (Number)this.minLevel);
        json.addProperty("max_players", (Number)this.maxPlayers);
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.minLevel = json.has("min_level") ? json.get("min_level").getAsInt() : 50;
        this.maxPlayers = json.has("max_players") ? json.get("max_players").getAsInt() : 8;
    }
}

