/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.objective;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.BailObjective;
import iskallia.vault.core.vault.objective.DeathObjective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.objective.RoyaleObjective;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.player.ListenersLogic;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.render.ColorBlender;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;

public class RoyaleCrystalObjective
extends CrystalObjective {
    protected float objectiveProbability;
    protected ResourceLocation startCrateLootTable;
    protected int lootMultiplier = 1;
    protected int minLevel = 50;

    public RoyaleCrystalObjective() {
    }

    public RoyaleCrystalObjective(float objectiveProbability) {
        this.objectiveProbability = objectiveProbability;
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        ListenersLogic listenersLogic = vault.get(Vault.LISTENERS).get(Listeners.LOGIC);
        if (listenersLogic instanceof ClassicListenersLogic) {
            ClassicListenersLogic classic = (ClassicListenersLogic)listenersLogic;
            classic.set(ClassicListenersLogic.MIN_LEVEL, this.minLevel);
        }
        ModConfigs.VAULT_CRYSTAL.getRandomObjective(VaultMod.id("royale"), vault.get(Vault.LEVEL).get(), random).ifPresent(objective -> objective.configure(vault, random));
        vault.ifPresent(Vault.OBJECTIVES, objectives -> {
            objectives.add(RoyaleObjective.of(this.startCrateLootTable, this.lootMultiplier));
            objectives.add(BailObjective.create(true, ClassicPortalLogic.EXIT));
            objectives.add(DeathObjective.create(true));
            objectives.set(Objectives.KEY, CrystalData.OBJECTIVE.getType(this));
        });
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Objective: ").m_7220_((Component)new TextComponent("Vault Royale").m_130948_(Style.f_131099_.m_178520_(this.getColor(time).orElseThrow().intValue()))));
        if (this.lootMultiplier > 1) {
            tooltip.add((Component)new TextComponent("Loot Multiplier: ").m_7220_((Component)new TextComponent(String.valueOf(this.lootMultiplier)).m_130948_(Style.f_131099_.m_178520_(this.getColor(time).orElseThrow().intValue()))));
        }
    }

    @Override
    public Optional<Integer> getColor(float time) {
        ColorBlender blender = new ColorBlender(1.0f).add(16770573, 60.0f).add(16757779, 60.0f);
        return Optional.of(blender.getColor(time));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.FLOAT.writeNbt(Float.valueOf(this.objectiveProbability)).ifPresent(tag -> nbt.m_128365_("objective_probability", tag));
        Adapters.IDENTIFIER.writeNbt(this.startCrateLootTable).ifPresent(tag -> nbt.m_128365_("start_crate_loot_table", tag));
        Adapters.INT_SEGMENTED_7.writeNbt(this.lootMultiplier).ifPresent(tag -> nbt.m_128365_("loot_multiplier", tag));
        Adapters.INT_SEGMENTED_7.writeNbt(this.minLevel).ifPresent(tag -> nbt.m_128365_("min_level", tag));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.objectiveProbability = Adapters.FLOAT.readNbt(nbt.m_128423_("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
        this.startCrateLootTable = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("start_crate_loot_table")).orElse(VaultMod.id("royale_crate"));
        this.lootMultiplier = Adapters.INT_SEGMENTED_7.readNbt(nbt.m_128423_("loot_multiplier")).orElse(1);
        this.minLevel = Adapters.INT_SEGMENTED_7.readNbt(nbt.m_128423_("min_level")).orElse(50);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.FLOAT.writeJson(Float.valueOf(this.objectiveProbability)).ifPresent(tag -> json.add("objective_probability", tag));
        Adapters.IDENTIFIER.writeJson(this.startCrateLootTable).ifPresent(tag -> json.add("start_crate_loot_table", tag));
        Adapters.INT_SEGMENTED_7.writeJson(this.lootMultiplier).ifPresent(tag -> json.add("loot_multiplier", tag));
        Adapters.INT_SEGMENTED_7.writeJson(this.minLevel).ifPresent(tag -> json.add("min_level", tag));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.objectiveProbability = Adapters.FLOAT.readJson(json.get("objective_probability")).orElse(Float.valueOf(0.0f)).floatValue();
        this.startCrateLootTable = Adapters.IDENTIFIER.readJson(json.get("start_crate_loot_table")).orElse(VaultMod.id("royale_crate"));
        this.lootMultiplier = Adapters.INT_SEGMENTED_7.readJson(json.get("loot_multiplier")).orElse(1);
        this.minLevel = Adapters.INT_SEGMENTED_7.readJson(json.get("min_level")).orElse(50);
    }

    public void setLootMultiplier(int i) {
        this.lootMultiplier = i;
    }

    public int getLootMultiplier() {
        return this.lootMultiplier;
    }
}

