/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.properties;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.properties.CrystalProperties;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.MysticExpertise;
import iskallia.vault.skill.prestige.SuperCrystalsPrestigePower;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerPrestigePowersData;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CapacityCrystalProperties
extends CrystalProperties {
    private Integer volume = null;
    private int size = 0;

    public Optional<Integer> getVolume() {
        return Optional.ofNullable(this.volume);
    }

    public int getSize() {
        return this.size;
    }

    public Optional<Integer> getCapacity() {
        return this.volume == null ? Optional.empty() : Optional.of(this.volume - this.size);
    }

    public CapacityCrystalProperties setVolume(int volume) {
        this.volume = volume;
        return this;
    }

    public CapacityCrystalProperties setSize(int size) {
        this.size = size;
        return this;
    }

    public boolean canAccept(int size) {
        return this.volume != null && size <= this.volume - this.size;
    }

    @Override
    public void onInventoryTick(Level world, Entity entity, int slot, boolean selected) {
        super.onInventoryTick(world, entity, slot, selected);
        if (this.volume == null && this.level != null && entity instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)entity;
            ModConfigs.VAULT_CRYSTAL.getRandomProperties(VaultMod.id("default"), this.level).ifPresent(properties -> {
                if (properties instanceof CapacityCrystalProperties) {
                    CapacityCrystalProperties capacityProperties = (CapacityCrystalProperties)properties;
                    capacityProperties.getVolume().ifPresent(volume -> {
                        int additionalVolume = 0;
                        additionalVolume += PlayerExpertisesData.get(sPlayer.m_183503_()).getExpertises((Player)sPlayer).getAll(MysticExpertise.class, Skill::isUnlocked).stream().mapToInt(MysticExpertise::getAdditionalCrystalVolume).sum();
                        this.volume = volume + (additionalVolume += PlayerPrestigePowersData.get(sPlayer.m_183503_()).getPowers((Player)sPlayer).getAll(SuperCrystalsPrestigePower.class, Skill::isUnlocked).stream().mapToInt(SuperCrystalsPrestigePower::getExtraCapacity).sum());
                    });
                }
            });
        }
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        super.addText(tooltip, minIndex, flag, time);
        if (this.volume == null) {
            tooltip.add(minIndex + 1, (Component)new TextComponent("Capacity: ???").m_130940_(ChatFormatting.GRAY));
        } else if (this.volume > 0) {
            int color = this.getCapacityTextColor(1.0f - (float)this.size / (float)this.volume.intValue()).m_131265_();
            tooltip.add(minIndex + 1, (Component)new TextComponent("Capacity: ").m_7220_((Component)new TextComponent(String.valueOf(Math.max(this.volume - this.size, 0))).m_6270_(Style.f_131099_.m_178520_(color))).m_7220_((Component)new TextComponent("/").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(String.valueOf(this.volume)).m_130940_(ChatFormatting.WHITE)));
        }
    }

    private TextColor getCapacityTextColor(float fullness) {
        float value;
        float saturation;
        float hue;
        float threshold = 0.5f;
        float hueDarkGreen = 0.3334f;
        float hueGold = 0.1111f;
        if (fullness >= 0.5f) {
            float p = (fullness - 0.5f) / 0.5f;
            hue = (1.0f - p) * 0.1111f + p * 0.3334f;
            saturation = 1.0f;
            value = (1.0f - p) * 0.8f + p;
        } else {
            float p = fullness / 0.5f;
            hue = (1.0f - p) * 0.1111f;
            saturation = 1.0f - p + p * 0.8f;
            value = 1.0f - p + p * 0.8f;
        }
        return TextColor.m_131266_((int)Color.HSBtoRGB(hue, saturation, value));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT_SEGMENTED_7.writeNbt(this.volume).ifPresent(tag -> nbt.m_128365_("volume", tag));
            Adapters.INT_SEGMENTED_7.writeNbt(this.size).ifPresent(tag -> nbt.m_128365_("size", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.volume = Adapters.INT_SEGMENTED_7.readNbt(nbt.m_128423_("volume")).orElse(null);
        this.size = Adapters.INT_SEGMENTED_7.readNbt(nbt.m_128423_("size")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(nbt -> {
            Adapters.INT_SEGMENTED_7.writeJson(this.volume).ifPresent(tag -> nbt.add("volume", tag));
            Adapters.INT_SEGMENTED_7.writeJson(this.size).ifPresent(tag -> nbt.add("size", tag));
            return nbt;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.volume = Adapters.INT_SEGMENTED_7.readJson(json.get("volume")).orElse(null);
        this.size = Adapters.INT_SEGMENTED_7.readJson(json.get("size")).orElse(0);
    }
}

