/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.properties;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.item.crystal.CrystalEntry;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class CrystalProperties
extends CrystalEntry
implements ISerializable<CompoundTag, JsonObject> {
    protected long customSeed = 0L;
    protected UUID vaultId = null;
    protected Integer level = null;
    protected boolean unmodifiable = false;

    public long getCustomSeed() {
        return this.customSeed;
    }

    public UUID getVaultId() {
        return this.vaultId;
    }

    public Optional<Integer> getLevel() {
        return Optional.ofNullable(this.level);
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    public CrystalProperties setCustomSeed(long customSeed) {
        this.customSeed = customSeed;
        return this;
    }

    public CrystalProperties setVaultId(UUID vaultId) {
        this.vaultId = vaultId;
        return this;
    }

    public CrystalProperties setLevel(Integer level) {
        this.level = level;
        return this;
    }

    public CrystalProperties setUnmodifiable(boolean unmodifiable) {
        this.unmodifiable = unmodifiable;
        return this;
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        int level = Math.max(this.getLevel().orElse(0), 0);
        vault.set(Vault.LEVEL, (VaultLevel)new VaultLevel().set(VaultLevel.VALUE, level));
        super.configure(vault, random);
    }

    @Override
    public void onInventoryTick(Level world, Entity entity, int slot, boolean selected) {
        if (this.level == null && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (entity.m_20194_() != null) {
                this.level = PlayerVaultStatsData.get(entity.m_20194_()).getVaultStats((Player)serverPlayer).getVaultLevel();
            }
        }
        super.onInventoryTick(world, entity, slot, selected);
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        if (this.level == null) {
            tooltip.add(minIndex, (Component)new TextComponent("Level: ???").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add(minIndex, (Component)new TextComponent("Level: ").m_7220_((Component)new TextComponent("" + this.level).m_6270_(Style.f_131099_.m_178520_(11583738))));
        }
        super.addText(tooltip, minIndex, flag, time);
        if (this.unmodifiable) {
            tooltip.add((Component)new TextComponent("Unmodifiable").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)11027010))));
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.UUID.writeNbt(this.vaultId).ifPresent(vaultId -> nbt.m_128365_("vault_id", vaultId));
        Adapters.INT.writeNbt(this.level).ifPresent(level -> nbt.m_128365_("level", level));
        Adapters.BOOLEAN.writeNbt(this.unmodifiable).ifPresent(unmodifiable -> nbt.m_128365_("exhausted", unmodifiable));
        Adapters.LONG.writeNbt(this.customSeed).ifPresent(seed -> nbt.m_128365_("seed", seed));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.vaultId = Adapters.UUID.readNbt(nbt.m_128423_("vault_id")).orElse(null);
        this.level = Adapters.INT.readNbt(nbt.m_128423_("level")).orElse(null);
        this.unmodifiable = Adapters.BOOLEAN.readNbt(nbt.m_128423_("exhausted")).orElse(false);
        this.customSeed = Adapters.LONG.readNbt(nbt.m_128423_("seed")).orElse(0L);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.UUID.writeJson(this.vaultId).ifPresent(vaultId -> json.add("vault_id", vaultId));
        Adapters.INT.writeJson(this.level).ifPresent(level -> json.add("level", level));
        Adapters.BOOLEAN.writeJson(this.unmodifiable).ifPresent(unmodifiable -> json.add("exhausted", unmodifiable));
        Adapters.LONG.writeJson(this.customSeed).ifPresent(seed -> json.add("seed", seed));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.vaultId = Adapters.UUID.readJson(json.get("vault_id")).orElse(null);
        this.level = Adapters.INT.readJson(json.get("level")).orElse(null);
        this.unmodifiable = Adapters.BOOLEAN.readJson(json.get("exhausted")).orElse(false);
        this.customSeed = Adapters.LONG.readJson(json.get("seed")).orElse(0L);
    }
}

